/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    public static final String DUNGEON_CHEST = "dungeonChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    ArrayList<lp> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ChestGenHooks.addInfo(MINESHAFT_CORRIDOR, aem.a, 3, 7);
        ChestGenHooks.addInfo(PYRAMID_DESERT_CHEST, afq.i, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_CHEST, afr.l, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_DISPENSER, afr.m, 2, 2);
        ChestGenHooks.addInfo(STRONGHOLD_CORRIDOR, agb.a, 2, 4);
        ChestGenHooks.addInfo(STRONGHOLD_LIBRARY, agf.b, 1, 5);
        ChestGenHooks.addInfo(STRONGHOLD_CROSSING, agk.c, 1, 5);
        ChestGenHooks.addInfo(VILLAGE_BLACKSMITH, ahl.a, 3, 9);
        ChestGenHooks.addInfo(BONUS_CHEST, iz.S, 10, 10);
        wm book = new wm(wk.bX, 1, 0);
        lp tmp = new lp(book, 1, 1, 1);
        ChestGenHooks.getInfo(MINESHAFT_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_DESERT_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_JUNGLE_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_LIBRARY).addItem(new lp(book, 1, 5, 2));
        ChestGenHooks.getInfo(STRONGHOLD_CROSSING).addItem(tmp);
        ChestGenHooks d = new ChestGenHooks(DUNGEON_CHEST);
        d.countMin = 8;
        d.countMax = 8;
        chestInfo.put(DUNGEON_CHEST, d);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.aB), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.p), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.V), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.U), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.N), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.L), 100, 1, 4);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.ax), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.au), 1, 1, 1);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.aD), 50, 1, 4);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.cd), 5, 1, 1);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.ce), 5, 1, 1);
        ChestGenHooks.addDungeonLoot(d, new wm(wk.aX, 1, 3), 100, 1, 1);
        ChestGenHooks.addDungeonLoot(d, book, 100, 1, 1);
    }

    static void addDungeonLoot(ChestGenHooks dungeon, wm item, int weight, int min, int max) {
        dungeon.addItem(new lp(item, min, max, weight));
    }

    private static void addInfo(String category, lp[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static wm[] generateStacks(Random rand, wm source, int min, int max) {
        wm[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new wm[]{};
        } else if (count > source.b().l()) {
            ret = new wm[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.m();
                ret[x].a = 1;
            }
        } else {
            ret = new wm[]{source.m()};
            ret[0].a = count;
        }
        return ret;
    }

    public static lp[] getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, lp item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, wm item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static wm getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, lp[] items, int min, int max) {
        this(category);
        for (lp item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(lp item) {
        this.contents.add(item);
    }

    public void removeItem(wm item) {
        Iterator<lp> itr = this.contents.iterator();
        while (itr.hasNext()) {
            lp cont = itr.next();
            if (!item.a(cont.b) && (item.k() != Short.MAX_VALUE || item.c != cont.b.c)) continue;
            itr.remove();
        }
    }

    public lp[] getItems(Random rnd) {
        ArrayList<lp> ret = new ArrayList<lp>();
        for (lp orig : this.contents) {
            lp n;
            wk item = orig.b.b();
            if (item == null || (n = item.getChestGenBase(this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new lp[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public wm getOneItem(Random rand) {
        lo[] items = this.getItems(rand);
        lp item = (lp)ln.a(rand, items);
        wm[] stacks = ChestGenHooks.generateStacks(rand, item.b, item.c, item.d);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

