/*
 * Decompiled with CFR 0.152.
 */
package icbm.gangshao.access;

import icbm.gangshao.access.AccessLevel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class UserAccess {
    public String username;
    public AccessLevel level;
    public boolean shouldSave;

    public UserAccess(String user, AccessLevel level, boolean save) {
        this.username = user;
        this.level = level;
        this.shouldSave = save;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("username", this.username);
        nbt.func_74768_a("ID", this.level.ordinal());
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.username = nbt.func_74779_i("username");
        this.level = AccessLevel.get(nbt.func_74762_e("ID"));
    }

    public static UserAccess loadFromNBT(NBTTagCompound nbt) {
        UserAccess access = new UserAccess("", AccessLevel.NONE, true);
        access.readFromNBT(nbt);
        return access;
    }

    public static List readListFromNBT(NBTTagCompound nbt, String tagName) {
        NBTTagList userList = nbt.func_74761_m(tagName);
        ArrayList<UserAccess> users = new ArrayList<UserAccess>();
        for (int i = 0; i < userList.func_74745_c(); ++i) {
            NBTTagCompound var4 = (NBTTagCompound)userList.func_74743_b(i);
            users.add(UserAccess.loadFromNBT(var4));
        }
        return users;
    }

    public static void writeListToNBT(NBTTagCompound save, List users) {
        NBTTagList usersTag = new NBTTagList();
        for (int player = 0; player < users.size(); ++player) {
            UserAccess access = (UserAccess)users.get(player);
            if (access == null || !access.shouldSave) continue;
            NBTTagCompound accessData = new NBTTagCompound();
            access.writeToNBT(accessData);
            usersTag.func_74742_a((NBTBase)accessData);
        }
        save.func_74782_a("Users", (NBTBase)usersTag);
    }

    public static List removeUserAccess(String player, List users) {
        ArrayList<UserAccess> removeList = new ArrayList<UserAccess>();
        List returnList = users;
        for (int i = 0; i < users.size(); ++i) {
            UserAccess ref = (UserAccess)users.get(i);
            if (!ref.username.equalsIgnoreCase(player)) continue;
            removeList.add(ref);
        }
        if (removeList != null && removeList.size() > 0) {
            returnList.removeAll(removeList);
        }
        return returnList;
    }
}

