/*
 * Decompiled with CFR 0.152.
 */
package icbm.gangshao.task;

import icbm.gangshao.turret.TPaoDaiBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import universalelectricity.core.vector.Vector3;

public class LookHelper {
    public static final int PITCH_DISPLACEMENT = 0;
    TPaoDaiBase sentry;

    public LookHelper(TPaoDaiBase turret) {
        this.sentry = turret;
    }

    public void lookAt(Vector3 target) {
        this.sentry.rotateTo(LookHelper.getYaw(this.sentry.getMuzzle(), target), LookHelper.getPitch(this.sentry.getMuzzle(), target));
    }

    public float[] getDeltaRotations(Vector3 target) {
        return new float[]{LookHelper.getYaw(this.sentry.getMuzzle(), target), LookHelper.getPitch(this.sentry.getMuzzle(), target)};
    }

    public void lookAtEntity(Entity entity) {
        this.lookAt(Vector3.add(new Vector3(entity), new Vector3(0.0, entity.func_70047_e(), 0.0)));
    }

    public boolean isLookingAt(Vector3 target, float allowedError) {
        float yaw = LookHelper.getYaw(this.sentry.getCenter(), target);
        float pitch = LookHelper.getPitch(this.sentry.getCenter(), target);
        return Math.abs(LookHelper.getAngleDif(this.sentry.currentRotationYaw, yaw)) <= allowedError && Math.abs(LookHelper.getAngleDif(this.sentry.currentRotationPitch, pitch)) <= allowedError;
    }

    public boolean isLookingAt(Entity entity, float allowedError) {
        return this.isLookingAt(new Vector3(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), allowedError);
    }

    public static float getPitch(Vector3 position, Vector3 target) {
        Vector3 difference = Vector3.subtract(target, position);
        double verticleDistance = MathHelper.func_76133_a((double)(difference.x * difference.x + difference.z * difference.z));
        return -MathHelper.func_76142_g((float)((float)(Math.atan2(difference.y, verticleDistance) * 180.0 / Math.PI) + 0.0f));
    }

    public static float getYaw(Vector3 position, Vector3 target) {
        Vector3 difference = Vector3.subtract(target, position);
        return MathHelper.func_76142_g((float)((float)(Math.atan2(difference.z, difference.x) * 180.0 / Math.PI) - 90.0f));
    }

    public static float getAngleDif(float angleOne, float angleTwo) {
        double dif = Math.max(angleOne, angleTwo) - Math.min(angleOne, angleTwo);
        return MathHelper.func_76142_g((float)((float)dif));
    }

    public boolean canPositionBeSeen(Vector3 target) {
        return this.sentry.field_70331_k.func_72933_a(this.sentry.getMuzzle().toVec3(), target.toVec3()) == null;
    }

    public boolean canEntityBeSeen(Entity entity) {
        Vector3 target = Vector3.add(new Vector3(entity), new Vector3(0.0, entity.func_70047_e(), 0.0));
        return this.canPositionBeSeen(target);
    }
}

