/*
 * Decompiled with CFR 0.152.
 */
package icbm.gangshao.turret;

import calclavia.lib.CalculationHelper;
import calclavia.lib.render.ITagRender;
import com.google.common.io.ByteArrayDataInput;
import icbm.core.ZhuYaoBase;
import icbm.gangshao.ISentry;
import icbm.gangshao.damage.EntityTileDamagable;
import icbm.gangshao.damage.IHealthTile;
import icbm.gangshao.platform.TPaoTaiZhan;
import icbm.gangshao.task.LookHelper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TPaoDaiBase
extends TileEntityAdvanced
implements IPacketReceiver,
ITagRender,
IVoltage,
ISentry,
IHealthTile {
    public float maxPitch = 35.0f;
    public float minPitch = -35.0f;
    protected boolean allowFreePitch = false;
    private ForgeDirection platformDirection = ForgeDirection.DOWN;
    public LookHelper lookHelper = new LookHelper(this);
    protected boolean speedUpRotation = false;
    public int health = -1;
    public int baseFiringDelay = 10;
    public int tickSinceFired = 0;
    public int minFiringDelay = 5;
    private EntityTileDamagable damageEntity;
    public float wantedRotationYaw;
    public float wantedRotationPitch = 0.0f;
    public float currentRotationYaw;
    public float currentRotationPitch = 0.0f;
    public int lastRotateTick = 0;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.tickSinceFired > 0) {
            --this.tickSinceFired;
        }
        if (!this.field_70331_k.field_72995_K && !this.isInvul() && this.getDamageEntity() == null && this.getHealth() > 0) {
            this.setDamageEntity(new EntityTileDamagable(this));
            this.field_70331_k.func_72838_d((Entity)this.getDamageEntity());
        }
        this.updateRotation();
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            this.onReceivePacket(dataStream.readInt(), player, dataStream);
        }
        catch (Exception e) {
            ZhuYaoBase.LOGGER.severe(MessageFormat.format("Packet receiving failed: {0}", this.getClass().getSimpleName()));
            e.printStackTrace();
        }
    }

    public void onReceivePacket(int packetID, EntityPlayer player, ByteArrayDataInput dataStream) throws IOException {
        if (packetID == TurretPacketType.ROTATION.ordinal()) {
            this.setRotation(dataStream.readFloat(), dataStream.readFloat());
        } else if (packetID == TurretPacketType.DESCRIPTION.ordinal()) {
            short size = dataStream.readShort();
            if (size > 0) {
                byte[] byteCode = new byte[size];
                dataStream.readFully(byteCode);
                this.func_70307_a(CompressedStreamTools.func_74792_a((byte[])byteCode));
            }
        } else if (packetID == TurretPacketType.STATS.ordinal()) {
            this.health = dataStream.readInt();
        }
    }

    public Packet getStatsPacket() {
        return PacketManager.getPacket("ICBM", this, new Object[]{TurretPacketType.STATS.ordinal(), this.health});
    }

    public Packet getRotationPacket() {
        return PacketManager.getPacket("ICBM", this, new Object[]{TurretPacketType.ROTATION.ordinal(), Float.valueOf(this.wantedRotationYaw), Float.valueOf(this.wantedRotationPitch)});
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return PacketManager.getPacket("ICBM", this, new Object[]{TurretPacketType.DESCRIPTION.ordinal(), nbt});
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74776_a("yaw", this.wantedRotationYaw);
        nbt.func_74776_a("pitch", this.wantedRotationPitch);
        nbt.func_74776_a("cYaw", this.currentRotationYaw);
        nbt.func_74776_a("cPitch", this.currentRotationPitch);
        nbt.func_74768_a("dir", this.platformDirection.ordinal());
        nbt.func_74768_a("health", this.getHealth());
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.wantedRotationYaw = nbt.func_74760_g("yaw");
        this.wantedRotationPitch = nbt.func_74760_g("pitch");
        this.currentRotationYaw = nbt.func_74760_g("cYaw");
        this.currentRotationPitch = nbt.func_74760_g("cPitch");
        this.platformDirection = ForgeDirection.getOrientation((int)nbt.func_74762_e("dir"));
        if (nbt.func_74764_b("health")) {
            this.health = nbt.func_74762_e("health");
        }
    }

    public abstract double getFiringRequest();

    public boolean isRunning() {
        return this.getPlatform() != null && this.getPlatform().isRunning() && this.isAlive();
    }

    @Override
    public TPaoTaiZhan getPlatform() {
        TileEntity tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l + this.platformDirection.offsetX, this.field_70330_m + this.platformDirection.offsetY, this.field_70327_n + this.platformDirection.offsetZ);
        if (tileEntity instanceof TPaoTaiZhan) {
            return (TPaoTaiZhan)tileEntity;
        }
        return null;
    }

    public void destroy(boolean doExplosion) {
        if (doExplosion) {
            if (!this.func_70320_p()) {
                this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
                this.field_70331_k.func_72876_a((Entity)this.getDamageEntity(), (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 2.0f, true);
            } else {
                this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
            }
        } else if (!this.field_70331_k.field_72995_K) {
            this.func_70311_o().func_71897_c(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70322_n(), 0);
            this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        }
    }

    public int getBarrels() {
        return 1;
    }

    public void setDeploySide(ForgeDirection side) {
        this.platformDirection = side.getOpposite();
    }

    @Override
    public float addInformation(HashMap map, EntityPlayer player) {
        map.put(this.getName(), 0x88FF88);
        return 1.0f;
    }

    @Override
    public String getName() {
        return new ItemStack(this.func_70311_o(), 1, this.func_70322_n()).func_82833_r() + " " + this.getHealth() + "/" + this.getMaxHealth();
    }

    @Override
    public Vector3 getMuzzle() {
        return this.getCenter().add(Vector3.multiply(CalculationHelper.getDeltaPositionFromRotation(this.currentRotationYaw, this.currentRotationPitch), 1.0));
    }

    @Override
    public void onWeaponActivated() {
        this.tickSinceFired += this.getFireDelay();
    }

    public int getFireDelay() {
        return this.baseFiringDelay;
    }

    @Override
    public abstract int getMaxHealth();

    public boolean isInvul() {
        return false;
    }

    @Override
    public int getHealth() {
        if (this.health == -1) {
            this.health = this.getMaxHealth();
        }
        return this.health;
    }

    @Override
    public void setHealth(int i, boolean increase) {
        if (increase) {
            i += this.health;
        }
        this.health = Math.min(Math.max(i, 0), this.getMaxHealth());
        if (!this.field_70331_k.field_72995_K) {
            PacketManager.sendPacketToClients(this.getStatsPacket(), this.field_70331_k, new Vector3(this), 100.0);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getHealth() > 0 || this.isInvul();
    }

    @Override
    public boolean onDamageTaken(DamageSource source, int amount) {
        if (this.isInvul()) {
            return false;
        }
        if (source != null && source.equals(DamageSource.field_76370_b)) {
            return true;
        }
        this.health -= amount;
        if (this.health <= 0) {
            this.destroy(true);
        } else {
            PacketManager.sendPacketToClients(this.getStatsPacket(), this.field_70331_k, new Vector3(this), 100.0);
        }
        return true;
    }

    public EntityTileDamagable getDamageEntity() {
        return this.damageEntity;
    }

    public void setDamageEntity(EntityTileDamagable damageEntity) {
        this.damageEntity = damageEntity;
    }

    public void updateRotation() {
        float pitchDifference;
        float yawDifference = Math.abs(LookHelper.getAngleDif(this.currentRotationYaw, this.wantedRotationYaw));
        if (yawDifference > 0.001f) {
            float speedYaw = Math.min(this.getRotationSpeed(), yawDifference);
            this.currentRotationYaw = this.currentRotationYaw > this.wantedRotationYaw ? (this.currentRotationYaw -= speedYaw) : (this.currentRotationYaw += speedYaw);
            if ((double)Math.abs(this.currentRotationYaw - this.wantedRotationYaw) <= (double)speedYaw + 0.1) {
                this.currentRotationYaw = this.wantedRotationYaw;
            }
        }
        if ((pitchDifference = Math.abs(LookHelper.getAngleDif(this.currentRotationPitch, this.wantedRotationPitch))) > 0.001f) {
            float speedPitch = Math.min(this.getRotationSpeed(), pitchDifference);
            this.currentRotationPitch = this.currentRotationPitch > this.wantedRotationPitch ? (this.currentRotationPitch -= speedPitch) : (this.currentRotationPitch += speedPitch);
            if ((double)Math.abs(this.currentRotationPitch - this.wantedRotationPitch) <= (double)speedPitch + 0.1) {
                this.currentRotationPitch = this.wantedRotationPitch;
            }
        }
        if (Math.abs(this.currentRotationPitch - this.wantedRotationPitch) <= 0.001f && Math.abs(this.currentRotationYaw - this.wantedRotationYaw) <= 0.001f) {
            ++this.lastRotateTick;
        }
        this.currentRotationPitch = MathHelper.func_76142_g((float)this.currentRotationPitch);
        this.wantedRotationYaw = MathHelper.func_76142_g((float)this.wantedRotationYaw);
        this.wantedRotationPitch = MathHelper.func_76142_g((float)this.wantedRotationPitch);
    }

    public float getRotationSpeed() {
        return Float.MAX_VALUE;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.wantedRotationYaw = MathHelper.func_76142_g((float)yaw);
        this.wantedRotationPitch = !this.allowFreePitch ? Math.max(Math.min(MathHelper.func_76142_g((float)pitch), this.maxPitch), this.minPitch) : MathHelper.func_76142_g((float)pitch);
    }

    public void rotateTo(float wantedRotationYaw, float wantedRotationPitch) {
        if (!(this.field_70331_k.field_72995_K || this.lastRotateTick <= 0 || this.wantedRotationYaw == wantedRotationYaw && this.wantedRotationPitch == wantedRotationPitch)) {
            this.setRotation(wantedRotationYaw, wantedRotationPitch);
            this.lastRotateTick = 0;
            if (!this.field_70331_k.field_72995_K) {
                PacketManager.sendPacketToClients(this.getRotationPacket(), this.field_70331_k, new Vector3(this), 50.0);
            }
        }
    }

    public void cancelRotation() {
        this.setRotation(this.currentRotationYaw, this.currentRotationPitch);
    }

    public void drawParticleStreamTo(Vector3 endPosition) {
        if (this.field_70331_k.field_72995_K) {
            Vector3 startPosition = this.getMuzzle();
            Vector3 direction = CalculationHelper.getDeltaPositionFromRotation(this.currentRotationYaw, this.currentRotationPitch);
            double xoffset = 0.0;
            double yoffset = 0.0;
            double zoffset = 0.0;
            Vector3 horzdir = direction.normalize();
            horzdir.y = 0.0;
            horzdir = horzdir.normalize();
            double cx = startPosition.x + direction.x * xoffset - direction.y * horzdir.x * yoffset - horzdir.z * zoffset;
            double cy = startPosition.y + direction.y * xoffset + (1.0 - Math.abs(direction.y)) * yoffset;
            double cz = startPosition.z + direction.x * xoffset - direction.y * horzdir.x * yoffset + horzdir.x * zoffset;
            double dx = endPosition.x - cx;
            double dy = endPosition.y - cy;
            double dz = endPosition.z - cz;
            double ratio = Math.sqrt(dx * dx + dy * dy + dz * dz);
            while (Math.abs(cx - endPosition.x) > Math.abs(dx / ratio)) {
                this.field_70331_k.func_72869_a("townaura", cx, cy, cz, 0.0, 0.0, 0.0);
                cx += dx * 0.1 / ratio;
                cy += dy * 0.1 / ratio;
                cz += dz * 0.1 / ratio;
            }
        }
    }

    public abstract void renderShot(Vector3 var1);

    public abstract void playFiringSound();

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public Vector3 getCenter() {
        return new Vector3(this).add(0.5);
    }

    public static enum TurretPacketType {
        ROTATION,
        DESCRIPTION,
        SHOT,
        STATS;

    }
}

