/*
 * Decompiled with CFR 0.152.
 */
package icbm.gangshao.turret.mount;

import calclavia.lib.CalculationHelper;
import icbm.api.explosion.IExplosive;
import icbm.core.ZhuYaoBase;
import icbm.gangshao.ProjectileType;
import icbm.gangshao.ZhuYaoGangShao;
import icbm.gangshao.turret.mount.TPaoTaiQi;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.implement.IRedstoneReceptor;
import universalelectricity.prefab.multiblock.IMultiBlock;
import universalelectricity.prefab.multiblock.TileEntityMulti;
import universalelectricity.prefab.network.IPacketReceiver;

public class TCiGuiPao
extends TPaoTaiQi
implements IPacketReceiver,
IRedstoneReceptor,
IMultiBlock {
    private int gunChargingTicks = 0;
    private boolean redstonePowerOn = false;
    private boolean isAntimatter;
    private float explosionSize;
    private int explosionDepth;
    private int endTicks = 0;

    public TCiGuiPao() {
        this.baseFiringDelay = 80;
        this.minFiringDelay = 50;
        this.maxPitch = 60.0f;
        this.minPitch = -60.0f;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.getPlatform() != null) {
            MovingObjectPosition objectMouseOver;
            if (this.redstonePowerOn) {
                this.tryActivateWeapon();
            }
            if (this.gunChargingTicks > 0) {
                ++this.gunChargingTicks;
                if (this.gunChargingTicks >= this.getFireDelay()) {
                    this.onFire();
                    this.gunChargingTicks = 0;
                }
            }
            if (this.field_70331_k.field_72995_K && this.endTicks-- > 0 && (objectMouseOver = this.rayTrace(2000.0)) != null && objectMouseOver.field_72307_f != null) {
                this.drawParticleStreamTo(new Vector3(objectMouseOver.field_72307_f));
            }
        }
    }

    @Override
    public void tryActivateWeapon() {
        if (this.canActivateWeapon() && this.gunChargingTicks == 0) {
            this.onWeaponActivated();
        }
    }

    public void onFire() {
        if (!this.field_70331_k.field_72995_K) {
            while (this.explosionDepth > 0) {
                MovingObjectPosition objectMouseOver = this.rayTrace(2000.0);
                if (objectMouseOver != null && !ZhuYaoGangShao.isProtected(this.field_70331_k, new Vector3(objectMouseOver), ZhuYaoGangShao.FLAG_RAILGUN)) {
                    Vector3 blockPosition;
                    int blockID;
                    Block block;
                    if (this.isAntimatter) {
                        int radius = 50;
                        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(objectMouseOver.field_72311_b - radius), (double)(objectMouseOver.field_72312_c - radius), (double)(objectMouseOver.field_72309_d - radius), (double)(objectMouseOver.field_72311_b + radius), (double)(objectMouseOver.field_72312_c + radius), (double)(objectMouseOver.field_72309_d + radius));
                        List missilesNearby = this.field_70331_k.func_72872_a(Entity.class, bounds);
                        for (Entity entity : missilesNearby) {
                            if (!(entity instanceof IExplosive)) continue;
                            entity.func_70106_y();
                        }
                    }
                    if ((block = Block.field_71973_m[blockID = (blockPosition = new Vector3(objectMouseOver.field_72307_f)).getBlockID((IBlockAccess)this.field_70331_k)]) != null && block.func_71934_m(this.field_70331_k, blockPosition.intX(), blockPosition.intY(), blockPosition.intZ()) != -1.0f) {
                        this.field_70331_k.func_72832_d(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d, 0, 0, 2);
                    }
                    Entity responsibleEntity = this.entityFake != null ? this.entityFake.field_70153_n : null;
                    this.field_70331_k.func_72885_a(responsibleEntity, blockPosition.x, blockPosition.y, blockPosition.z, this.explosionSize, true, true);
                }
                --this.explosionDepth;
            }
        }
    }

    @Override
    public void renderShot(Vector3 target) {
        this.endTicks = 20;
    }

    @Override
    public void playFiringSound() {
        this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "icbm.railgun", 5.0f, 1.0f);
    }

    @Override
    public double getVoltage() {
        return 220.0;
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, 0);
    }

    @Override
    public void onCreate(Vector3 position) {
        this.field_70331_k.func_72832_d(position.intX(), position.intY() + 1, position.intZ(), ZhuYaoBase.bJia.field_71990_ca, 0, 2);
        ((TileEntityMulti)this.field_70331_k.func_72796_p(position.intX(), position.intY() + 1, position.intZ())).setMainBlock(position);
    }

    @Override
    public Vector3 getCenter() {
        return new Vector3(this).add(new Vector3(0.5, 1.5, 0.5));
    }

    @Override
    public Vector3 getMuzzle() {
        return this.getCenter().add(Vector3.multiply(CalculationHelper.getDeltaPositionFromRotation(this.currentRotationYaw, this.currentRotationPitch), 1.6));
    }

    @Override
    public void onPowerOn() {
        this.redstonePowerOn = true;
    }

    @Override
    public void onPowerOff() {
        this.redstonePowerOn = false;
    }

    @Override
    public double getFiringRequest() {
        return 1000000.0;
    }

    @Override
    public void onWeaponActivated() {
        super.onWeaponActivated();
        this.gunChargingTicks = 1;
        this.redstonePowerOn = false;
        this.isAntimatter = false;
        ItemStack ammoStack = this.getPlatform().hasAmmunition(ProjectileType.RAILGUN);
        if (ammoStack != null) {
            if (ammoStack.equals(ZhuYaoGangShao.antimatterBullet) && this.getPlatform().useAmmunition(ammoStack)) {
                this.isAntimatter = true;
            } else {
                this.getPlatform().useAmmunition(ammoStack);
            }
        }
        this.getPlatform().wattsReceived = 0.0;
        this.explosionSize = 5.0f;
        this.explosionDepth = 5;
        if (this.isAntimatter) {
            this.explosionSize = 8.0f;
            this.explosionDepth = 10;
        }
        this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "icbm.railgun", 5.0f, 1.0f);
    }

    @Override
    public boolean canActivateWeapon() {
        return this.getPlatform() != null && this.getPlatform().hasAmmunition(ProjectileType.RAILGUN) != null && this.getPlatform().wattsReceived >= this.getFiringRequest();
    }

    @Override
    public float addInformation(HashMap map, EntityPlayer player) {
        super.addInformation(map, player);
        return 2.0f;
    }

    @Override
    public int getMaxHealth() {
        return 450;
    }
}

