/*
 * Decompiled with CFR 0.152.
 */
package icbm.gangshao.turret.sentries;

import com.google.common.io.ByteArrayDataInput;
import icbm.api.sentry.IAATarget;
import icbm.gangshao.IAmmunition;
import icbm.gangshao.IAutoSentry;
import icbm.gangshao.ProjectileType;
import icbm.gangshao.ZhuYaoGangShao;
import icbm.gangshao.damage.TileDamageSource;
import icbm.gangshao.task.TaskManager;
import icbm.gangshao.task.TaskSearchTarget;
import icbm.gangshao.turret.TPaoDaiBase;
import icbm.gangshao.turret.upgrades.ItPaoTaiUpgrades;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public abstract class TPaoTaiZiDong
extends TPaoDaiBase
implements IAutoSentry {
    public Entity target;
    public boolean targetPlayers = false;
    public boolean targetAir = false;
    public boolean targetHostile = false;
    public boolean targetFriendly = false;
    public boolean canTargetAir = false;
    public final TaskManager taskManager = new TaskManager(this);
    public int baseTargetRange = 20;
    public int maxTargetRange = 90;
    public float rotationSpeed = 3.0f;
    public ProjectileType projectileType = ProjectileType.CONVENTIONAL;

    @Override
    public void onReceivePacket(int packetID, EntityPlayer player, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, player, dataStream);
        if (packetID == TPaoDaiBase.TurretPacketType.SHOT.ordinal()) {
            this.renderShot(new Vector3(dataStream.readDouble(), dataStream.readDouble(), dataStream.readDouble()));
            this.currentRotationPitch = dataStream.readFloat();
            this.currentRotationYaw = dataStream.readFloat();
            this.playFiringSound();
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.isRunning()) {
            this.taskManager.onUpdate();
            if (!this.taskManager.hasTasks()) {
                this.taskManager.addTask(new TaskSearchTarget());
            }
        }
    }

    @Override
    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    @Override
    public AxisAlignedBB getTargetingBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_70329_l - this.getDetectRange()), (double)(this.field_70330_m - 5), (double)((double)this.field_70327_n - this.getDetectRange()), (double)((double)this.field_70329_l + this.getDetectRange()), (double)(this.field_70330_m + 5), (double)((double)this.field_70327_n + this.getDetectRange()));
    }

    @Override
    public Entity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Entity target) {
        this.target = target;
    }

    @Override
    public boolean isValidTarget(Entity entity) {
        if (entity != null && !entity.field_70128_L && !entity.func_85032_ar()) {
            float[] rotations;
            Vector3 vector3 = new Vector3(entity);
            if (this.getCenter().distanceTo(vector3) <= this.getDetectRange() && ((rotations = this.lookHelper.getDeltaRotations(new Vector3(entity).add(new Vector3(0.0, entity.func_70047_e(), 0.0))))[1] <= this.maxPitch && rotations[1] >= this.minPitch || this.allowFreePitch) && this.lookHelper.canEntityBeSeen(entity)) {
                if (this.targetAir && this.canTargetAir && this.isAir(entity)) {
                    return true;
                }
                if (this.targetPlayers && (entity instanceof EntityPlayer || entity.field_70153_n instanceof EntityPlayer)) {
                    EntityPlayer player = entity.field_70153_n instanceof EntityPlayer ? (EntityPlayer)entity.field_70153_n : (EntityPlayer)entity;
                    if (!player.field_71075_bZ.field_75098_d && this.getPlatform() != null && !this.getPlatform().canUserAccess(player.field_71092_bJ)) {
                        return true;
                    }
                }
                if (this.targetHostile && entity instanceof IMob && !this.isAir(entity)) {
                    return true;
                }
                if (this.targetFriendly && (entity instanceof IAnimals || entity instanceof INpc || entity instanceof IMerchant) && !this.isAir(entity)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isAir(Entity entity) {
        return entity instanceof IMob && entity instanceof EntityFlying || entity instanceof IAATarget && ((IAATarget)entity).canBeTargeted(this) || entity instanceof EntityWither || entity instanceof EntityDragon;
    }

    @Override
    public boolean canActivateWeapon() {
        if (this.isValidTarget(this.target) && this.getPlatform() != null && this.lookHelper.isLookingAt(this.target, 5.0f)) {
            return this.tickSinceFired == 0 && this.getPlatform().wattsReceived >= this.getFiringRequest() && (this.getPlatform().hasAmmunition(this.projectileType) != null || this.projectileType == ProjectileType.UNKNOWN);
        }
        return false;
    }

    public void sendShotToClient(Vector3 position) {
        PacketManager.sendPacketToClients(PacketManager.getPacket("ICBM", this, new Object[]{TPaoDaiBase.TurretPacketType.SHOT.ordinal(), position.x, position.y, position.z, Float.valueOf(this.currentRotationPitch), Float.valueOf(this.currentRotationYaw)}), this.field_70331_k, new Vector3(this), 40.0);
    }

    @Override
    public void onWeaponActivated() {
        super.onWeaponActivated();
        if (!this.field_70331_k.field_72995_K && this.onFire()) {
            this.sendShotToClient(this.getTargetPosition());
            this.playFiringSound();
            this.getPlatform().wattsReceived = Math.max(this.getPlatform().wattsReceived - this.getFiringRequest(), 0.0);
        }
    }

    @Override
    public void renderShot(Vector3 target) {
        this.drawParticleStreamTo(target);
    }

    protected boolean onFire() {
        if (!this.field_70331_k.field_72995_K) {
            ItemStack ammoStack = this.getPlatform().hasAmmunition(this.projectileType);
            if (this.getPlatform() != null && ammoStack != null) {
                boolean fired = false;
                IAmmunition bullet = (IAmmunition)ammoStack.func_77973_b();
                if (this.target instanceof EntityLiving) {
                    this.getPlatform().wattsReceived -= this.getFiringRequest();
                    if (bullet.getType(ammoStack) == ProjectileType.CONVENTIONAL) {
                        this.target.func_70097_a((DamageSource)TileDamageSource.doBulletDamage(this), bullet.getDamage());
                    }
                    fired = true;
                } else if (this.target instanceof IAATarget) {
                    if ((double)this.field_70331_k.field_73012_v.nextFloat() > 0.2) {
                        int damage = ((IAATarget)this.target).doDamage(8);
                        if (damage == -1 && (double)this.field_70331_k.field_73012_v.nextFloat() > 0.7) {
                            ((IAATarget)this.target).destroyCraft();
                        } else if (damage <= 0) {
                            ((IAATarget)this.target).destroyCraft();
                        }
                    }
                    fired = true;
                }
                if (fired && this.projectileType != ProjectileType.UNKNOWN && this.getPlatform().useAmmunition(ammoStack)) {
                    boolean drop = true;
                    if (this.getPlatform().getUpgradeCount(ItPaoTaiUpgrades.TurretUpgradeType.COLLECTOR) > 0 && this.getPlatform().addStackToInventory(ZhuYaoGangShao.bulletShell.func_77946_l())) {
                        drop = false;
                    }
                    if (drop && (double)this.field_70331_k.field_73012_v.nextFloat() < 0.9) {
                        Vector3 spawnPos = this.getMuzzle();
                        EntityItem entityShell = new EntityItem(this.field_70331_k, spawnPos.x, spawnPos.y, spawnPos.z, ZhuYaoGangShao.bulletShell.func_77946_l());
                        entityShell.field_70293_c = 20;
                        this.field_70331_k.func_72838_d((Entity)entityShell);
                    }
                }
                return fired;
            }
        }
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("targetPlayers", this.targetPlayers);
        nbt.func_74757_a("targetAir", this.targetAir);
        nbt.func_74757_a("targetHostile", this.targetHostile);
        nbt.func_74757_a("targetFriendly", this.targetFriendly);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        if (nbt.func_74764_b("targetPlayers")) {
            this.targetPlayers = nbt.func_74767_n("targetPlayers");
        }
        if (nbt.func_74764_b("targetAir")) {
            this.targetAir = nbt.func_74767_n("targetAir");
        }
        if (nbt.func_74764_b("targetHostile")) {
            this.targetHostile = nbt.func_74767_n("targetHostile");
        }
        if (nbt.func_74764_b("targetFriendly")) {
            this.targetFriendly = nbt.func_74767_n("targetFriendly");
        }
    }

    @Override
    public double getDetectRange() {
        if (this.getPlatform() != null) {
            return Math.min((float)this.baseTargetRange + (float)(this.maxTargetRange - this.baseTargetRange) * ((float)this.getPlatform().getUpgradeCount(ItPaoTaiUpgrades.TurretUpgradeType.RANGE) / 64.0f), (float)this.maxTargetRange);
        }
        return this.baseTargetRange;
    }

    @Override
    public boolean canApplyPotion(PotionEffect par1PotionEffect) {
        return false;
    }

    public Vector3 getTargetPosition() {
        if (this.getTarget() != null) {
            return new Vector3(this.getTarget()).add(new Vector3(0.0, this.getTarget().func_70047_e(), 0.0));
        }
        return null;
    }
}

