/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.block.IElectricityStorage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityElectricityStorage
extends TileEntityElectrical
implements IElectricityStorage {
    private double joules = 0.0;
    public double prevJoules = 0.0;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.prevJoules = this.joules;
        if (!this.field_70331_k.field_72995_K) {
            if (!this.isDisabled()) {
                ElectricityPack electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
                this.onReceive(electricityPack);
            } else {
                ElectricityNetworkHelper.consumeFromMultipleSides(this, new ElectricityPack());
            }
        }
    }

    protected EnumSet getConsumingSides() {
        return ElectricityNetworkHelper.getDirections(this);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack((this.getMaxJoules() - this.getJoules()) / this.getVoltage(), this.getVoltage());
    }

    public void onReceive(ElectricityPack electricityPack) {
        if (UniversalElectricity.isVoltageSensitive && electricityPack.voltage > this.getVoltage()) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 1.5f, true);
            return;
        }
        this.setJoules(this.getJoules() + electricityPack.getWatts());
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.joules = par1NBTTagCompound.func_74769_h("joules");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74780_a("joules", this.joules);
    }

    @Override
    public double getJoules() {
        return this.joules;
    }

    @Override
    public void setJoules(double joules) {
        this.joules = Math.max(Math.min(joules, this.getMaxJoules()), 0.0);
    }
}

