/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.CommonUtils;
import codechicken.core.NetworkClosedException;
import codechicken.core.internal.ClientTickHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.Socket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.MemoryConnection;
import net.minecraft.network.TcpConnection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ClientUtils
extends CommonUtils {
    private static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static World getWorld() {
        return ClientUtils.mc().field_71441_e;
    }

    public static EntityPlayer getPlayer(String playername) {
        return playername == ClientUtils.mc().field_71439_g.field_71092_bJ || playername == null ? ClientUtils.mc().field_71439_g : null;
    }

    public static boolean isClient(World world) {
        return world instanceof WorldClient;
    }

    public static boolean inWorld() {
        return ClientUtils.mc().func_71391_r() != null;
    }

    public static void openSMPGui(int windowId, GuiScreen gui) {
        ClientUtils.mc().func_71373_a(gui);
        if (windowId != 0) {
            ClientUtils.mc().field_71439_g.field_71070_bA.field_75152_c = windowId;
        }
    }

    public static float getRenderFrame() {
        return ClientUtils.mc().field_71428_T.field_74281_c;
    }

    public static double getRenderTime() {
        return (float)ClientTickHandler.renderTime + ClientUtils.getRenderFrame();
    }

    public static String getServerIP() {
        try {
            INetworkManager networkManager = ClientUtils.mc().func_71391_r().field_72555_g;
            if (networkManager instanceof MemoryConnection) {
                return "memory";
            }
            Socket socket = ((TcpConnection)networkManager).func_74452_g();
            if (socket == null) {
                throw new NetworkClosedException();
            }
            return socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isLocal() {
        return ClientUtils.getServerIP().equals("memory");
    }

    @SideOnly(value=Side.CLIENT)
    public static String getWorldSaveName(String worldName) {
        if (!ClientUtils.isLocal()) {
            return null;
        }
        return MinecraftServer.func_71276_C().func_71270_I();
    }
}

