/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LangUtil {
    public static LangUtil instance = new LangUtil(null);
    public String prefix;

    public LangUtil(String prefix) {
        this.prefix = prefix;
    }

    public static String translateG(String s, Object ... format) {
        return instance.translate(s, format);
    }

    public String translate(String s, Object ... format) {
        String ret;
        if (this.prefix != null && !s.startsWith(this.prefix + ".")) {
            s = this.prefix + "." + s;
        }
        if ((ret = LanguageRegistry.instance().getStringLocalization(s)).length() == 0) {
            ret = LanguageRegistry.instance().getStringLocalization(s, "en_US");
        }
        if (ret.length() == 0) {
            return s;
        }
        if (format.length > 0) {
            ret = String.format(ret, format);
        }
        return ret;
    }

    public LangUtil addLangDirectory(Class mod) {
        String dir = this.prefix == null ? "lang" : "lang/" + this.prefix;
        return this.addLangDirectory(mod, dir);
    }

    public LangUtil addLangDirectory(Class mod, String dir) {
        this.addLangDirectory(this.hostFile(mod), dir);
        return this;
    }

    public void addLangFile(InputStream resource, String lang) throws IOException {
        String read;
        LanguageRegistry reg = LanguageRegistry.instance();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
        while ((read = reader.readLine()) != null) {
            int equalIndex = read.indexOf(61);
            if (equalIndex == -1) continue;
            String key = read.substring(0, equalIndex);
            String value = read.substring(equalIndex + 1);
            if (this.prefix != null) {
                key = this.prefix + "." + key;
            }
            reg.addStringLocalization(key, lang, value);
        }
        reader.close();
    }

    public void addLangDirectory(File host, String dir) {
        if (host.isFile()) {
            this.addLangDirFromJar(host, dir);
        } else {
            File hostdir = new File(host, dir);
            if (!hostdir.exists()) {
                System.err.println("Lang directory \"" + dir + "\" not found in " + host.getPath());
            } else if (hostdir.isDirectory()) {
                this.addLangDir(hostdir);
            } else if (hostdir.getName().endsWith(".lang")) {
                this.addLangFile(hostdir);
            } else {
                System.err.println("Lang file \"" + hostdir + "\"does not end in .lang");
            }
        }
    }

    public void addLangDir(File dir) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.addLangDir(child);
                continue;
            }
            if (!child.getName().endsWith(".lang")) continue;
            this.addLangFile(child);
        }
    }

    public void addLangFile(File child) {
        try {
            String lang = child.getName().substring(0, child.getName().lastIndexOf(46));
            FileInputStream fin = new FileInputStream(child);
            this.addLangFile(fin, lang);
            fin.close();
        }
        catch (IOException e) {
            System.err.println("Error occured while loading lang file: " + child.getPath());
            e.printStackTrace();
        }
    }

    public void addLangDirFromJar(File jar, String dir) {
        while (dir.startsWith("/")) {
            dir = dir.substring(1);
        }
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(jar));
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(dir) || !name.endsWith(".lang")) continue;
                this.addLangFile(zin, name.substring(name.lastIndexOf(47) + 1, name.lastIndexOf(46)));
            }
            zin.close();
        }
        catch (IOException e) {
            System.err.println("Error while reading lang zipfile: " + jar.getPath());
            e.printStackTrace();
        }
    }

    public File hostFile(Class clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            if (url.getProtocol().equals("jar")) {
                url = new URL(url.getPath().substring(0, url.getPath().indexOf(33)));
            }
            String p = url.getPath();
            p = p.substring(0, p.length() - (clazz.getName().length() + 6));
            return new File(p);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

