/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.alg;

import codechicken.core.vec.BlockCoord;
import net.minecraft.nbt.NBTTagCompound;

public class SquareSpiral {
    private int x = 0;
    private int z = 0;
    private int side = 0;
    private int sidelenth = 1;
    private int iside = 0;
    private int i = 0;
    private int imax;

    public SquareSpiral() {
        this.imax = Integer.MAX_VALUE;
    }

    public SquareSpiral(int squareSize) {
        this.imax = squareSize * squareSize;
    }

    public SquareSpiral(NBTTagCompound tag) {
        this.x = tag.func_74762_e("x");
        this.z = tag.func_74762_e("z");
        this.i = tag.func_74762_e("i");
        this.side = tag.func_74762_e("side");
        this.sidelenth = tag.func_74762_e("sidelenth");
        this.iside = tag.func_74762_e("iside");
        this.imax = tag.func_74762_e("imax");
    }

    public BlockCoord next() {
        BlockCoord r = new BlockCoord(this.x, 0, this.z);
        ++this.i;
        ++this.iside;
        switch (this.side) {
            case 0: {
                ++this.x;
                break;
            }
            case 1: {
                ++this.z;
                break;
            }
            case 2: {
                --this.x;
                break;
            }
            case 3: {
                --this.z;
            }
        }
        if (this.iside == this.sidelenth) {
            this.side = (this.side + 1) % 4;
            if (this.side % 2 == 0) {
                ++this.sidelenth;
            }
            this.iside = 0;
        }
        return r;
    }

    public boolean hasNext() {
        return this.i < this.imax;
    }

    public NBTTagCompound saveTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("z", this.z);
        tag.func_74768_a("i", this.i);
        tag.func_74768_a("side", this.side);
        tag.func_74768_a("sidelenth", this.sidelenth);
        tag.func_74768_a("iside", this.iside);
        tag.func_74768_a("imax", this.imax);
        return tag;
    }
}

