/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ASMHelper;
import cpw.mods.fml.relauncher.IClassTransformer;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.tree.ClassNode;

public class ClassHeirachyManager
implements IClassTransformer {
    public static HashSet knownClasses = new HashSet();
    public static HashMap superclasses = new HashMap();
    private static RelaunchClassLoader cl = (RelaunchClassLoader)ClassHeirachyManager.class.getClassLoader();

    public static boolean classExtends(String clazz, String superclass, byte[] bytes) {
        if (!knownClasses.contains(clazz)) {
            new ClassHeirachyManager().transform(clazz, clazz, bytes);
        }
        return ClassHeirachyManager.classExtends(clazz, superclass);
    }

    public static boolean classExtends(String clazz, String superclass) {
        if (clazz.equals(superclass)) {
            return true;
        }
        if (clazz.equals("java.lang.Object")) {
            return false;
        }
        ClassHeirachyManager.declareClass(clazz);
        if (!superclasses.containsKey(clazz)) {
            return false;
        }
        for (String s : (ArrayList)superclasses.get(clazz)) {
            if (!ClassHeirachyManager.classExtends(s, superclass)) continue;
            return true;
        }
        return false;
    }

    private static void declareClass(String clazz) {
        block9: {
            try {
                if (knownClasses.contains(clazz)) break block9;
                try {
                    byte[] bytes = cl.getClassBytes(clazz);
                    if (bytes != null) {
                        new ClassHeirachyManager().transform(clazz, clazz, bytes);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!knownClasses.contains(clazz)) {
                    Class<?> aclass = Class.forName(clazz);
                    knownClasses.add(clazz);
                    if (aclass.isInterface()) {
                        ClassHeirachyManager.addSuperclass(clazz, "java.lang.Object");
                    } else {
                        ClassHeirachyManager.addSuperclass(clazz, aclass.getSuperclass().getName());
                    }
                    for (Class<?> iclass : aclass.getInterfaces()) {
                        ClassHeirachyManager.addSuperclass(clazz, iclass.getName());
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!knownClasses.contains(name)) {
            ClassNode node = ASMHelper.createClassNode(bytes);
            knownClasses.add(name);
            ClassHeirachyManager.addSuperclass(name, node.superName.replace('/', '.'));
            for (String iclass : node.interfaces) {
                ClassHeirachyManager.addSuperclass(name, iclass.replace('/', '.'));
            }
        }
        return bytes;
    }

    private static void addSuperclass(String name, String superclass) {
        ArrayList<String> supers = (ArrayList<String>)superclasses.get(name);
        if (supers == null) {
            supers = new ArrayList<String>();
            superclasses.put(name, supers);
        }
        supers.add(superclass);
    }

    public static String getSuperClass(String c) {
        ClassHeirachyManager.declareClass(c);
        if (!knownClasses.contains(c)) {
            return "java.lang.Object";
        }
        return (String)((ArrayList)superclasses.get(c)).get(0);
    }
}

