/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ASMHelper;
import codechicken.core.asm.InstructionComparator;
import codechicken.core.asm.ObfuscationMappings;
import codechicken.core.config.ConfigFile;
import codechicken.core.config.ConfigTag;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TweakTransformer
implements IClassTransformer,
Opcodes {
    private static HashMultimap altercators = HashMultimap.create();
    public static ConfigTag tweaks;

    public static void load(ConfigFile config) {
        tweaks = config.getTag("tweaks").setComment("Various tweaks that can be applied to game mechanics.").useBraces();
        if (!tweaks.getTag("persistantLava").setComment("Set to false to make lava fade away like water if all the source blocks are destroyed").getBooleanValue(true)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping("net/minecraft/block/Block", "updateTick", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V").subclass("net/minecraft/block/BlockFlowing")){

                @Override
                public void alter(MethodNode mv) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new VarInsnNode(21, 6));
                    needle.add((AbstractInsnNode)new VarInsnNode(54, -1));
                    needle.add((AbstractInsnNode)new InsnNode(3));
                    needle.add((AbstractInsnNode)new VarInsnNode(54, 8));
                    List lists = InstructionComparator.insnListFindL(mv.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    AbstractInsnNode insn = subsection.first;
                    while (true) {
                        AbstractInsnNode next = insn.getNext();
                        mv.instructions.remove(insn);
                        if (insn == subsection.last) break;
                        insn = next;
                    }
                }
            });
        }
        if (tweaks.getTag("environmentallyFriendlyCreepers").setComment("If set to true, creepers will not destroy landscape. (A version of mobGreifing setting just for creepers)").getBooleanValue(false)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping("net/minecraft/entity/Entity", "onUpdate", "()V").subclass("net/minecraft/entity/monster/EntityCreeper")){

                @Override
                public void alter(MethodNode mv) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    needle.add((AbstractInsnNode)new ObfuscationMappings.DescriptorMapping("net/minecraft/entity/Entity", "worldObj", "Lnet/minecraft/world/World;").subclass("net/minecraft/entity/monster/EntityCreeper").toFieldInsn(180));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", "getGameRules", "()Lnet/minecraft/world/GameRules;"));
                    needle.add((AbstractInsnNode)new LdcInsnNode((Object)"mobGriefing"));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/GameRules", "getGameRuleBooleanValue", "(Ljava/lang/String;)Z"));
                    List lists = InstructionComparator.insnListFindL(mv.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    mv.instructions.insertBefore(subsection.first, (AbstractInsnNode)new InsnNode(3));
                    ASMHelper.removeBlock(mv.instructions, subsection);
                }
            });
        }
        if (!tweaks.getTag("softLeafReplace").setComment("If set to false, leaves will only replace air when growing").getBooleanValue(false)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping("net/minecraft/block/Block", "canBeReplacedByLeaves", "(Lnet/minecraft/world/World;III)Z")){

                @Override
                public void alter(MethodNode mv) {
                    InsnList replacement = new InsnList();
                    replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    replacement.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    replacement.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    replacement.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    replacement.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    replacement.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/Block", "isAirBlock", "(Lnet/minecraft/world/World;III)Z"));
                    replacement.add((AbstractInsnNode)new InsnNode(172));
                    mv.instructions = replacement;
                }
            });
        }
        if (tweaks.getTag("doFireTickOut").setComment("If set to true and doFireTick is disabed in the game rules, fire will still dissipate if it's not over a fire source").getBooleanValue(true)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping("net/minecraft/block/BlockFire", "updateTick", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V")){

                @Override
                public void alter(MethodNode mv) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new LdcInsnNode((Object)"doFireTick"));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/GameRules", "getGameRuleBooleanValue", "(Ljava/lang/String;)Z"));
                    needle.add((AbstractInsnNode)new JumpInsnNode(153, new LabelNode()));
                    List lists = InstructionComparator.insnListFindL(mv.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    LabelNode jlabel = ((JumpInsnNode)subsection.last).label;
                    LabelNode ret = new LabelNode();
                    mv.instructions.insertBefore((AbstractInsnNode)jlabel, (AbstractInsnNode)new JumpInsnNode(167, ret));
                    InsnList inject = new InsnList();
                    inject.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    inject.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    inject.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    inject.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    inject.add((AbstractInsnNode)new VarInsnNode(25, 5));
                    inject.add((AbstractInsnNode)new MethodInsnNode(184, "codechicken/core/featurehack/TweakTransformerHelper", "quenchFireTick", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V"));
                    inject.add((AbstractInsnNode)ret);
                    mv.instructions.insert((AbstractInsnNode)jlabel, inject);
                }
            });
        }
    }

    private static void alterMethod(ASMHelper.MethodAltercator ma) {
        altercators.put((Object)ma.method.javaClass(), (Object)ma);
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        bytes = ASMHelper.alterMethods(name, bytes, altercators);
        return bytes;
    }
}

