/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.config;

import codechicken.core.config.ConfigTagParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class ConfigFile
extends ConfigTagParent {
    public File file;
    private boolean loading;
    public static final byte[] lineend = new byte[]{13, 10};

    public ConfigFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.file = file;
        this.newlinemode = 2;
        this.loadConfig();
    }

    private void loadConfig() {
        this.loading = true;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            while (true) {
                reader.mark(2000);
                String line = reader.readLine();
                if (line == null || !line.startsWith("#")) break;
                if (this.comment == null || this.comment.equals("")) {
                    this.comment = line.substring(1);
                    continue;
                }
                this.comment = this.comment + "\n" + line.substring(1);
            }
            reader.reset();
            this.loadChildren(reader);
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loading = false;
    }

    @Override
    public ConfigFile setComment(String header) {
        super.setComment(header);
        return this;
    }

    @Override
    public ConfigFile setSortMode(int mode) {
        super.setSortMode(mode);
        return this;
    }

    @Override
    public String getNameQualifier() {
        return "";
    }

    public static String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            return line.replace("\t", "");
        }
        return line;
    }

    public static String formatLine(String line) {
        if ((line = line.replace("\t", "")).startsWith("#")) {
            return line;
        }
        if (line.contains("=")) {
            line = line.substring(0, line.indexOf("=")).replace(" ", "") + line.substring(line.indexOf("="));
            return line;
        }
        line = line.replace(" ", "");
        return line;
    }

    public static void writeLine(PrintWriter writer, String line, int tabs) {
        for (int i = 0; i < tabs; ++i) {
            writer.print('\t');
        }
        writer.println(line);
    }

    @Override
    public void saveConfig() {
        PrintWriter writer;
        if (this.loading) {
            return;
        }
        try {
            writer = new PrintWriter(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.writeComment(writer, 0);
        ConfigFile.writeLine(writer, "", 0);
        this.saveTagTree(writer, 0, "");
        writer.flush();
        writer.close();
    }

    public boolean isLoading() {
        return this.loading;
    }
}

