/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.data;

import codechicken.core.data.MCDataInput;
import codechicken.core.data.MCDataOutput;
import codechicken.core.vec.BlockCoord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.liquids.LiquidStack;

public class NBTDataWrapper
implements MCDataInput,
MCDataOutput {
    private NBTTagList readList;
    private int readTag = 0;
    private NBTTagList writeList;

    public NBTDataWrapper(NBTTagList input) {
        this.readList = input;
    }

    public NBTDataWrapper() {
        this.writeList = new NBTTagList();
    }

    public NBTTagList toTag() {
        return this.writeList;
    }

    @Override
    public NBTDataWrapper writeLong(long l) {
        this.writeList.func_74742_a((NBTBase)new NBTTagLong(null, l));
        return this;
    }

    @Override
    public NBTDataWrapper writeInt(int i) {
        this.writeList.func_74742_a((NBTBase)new NBTTagInt(null, i));
        return this;
    }

    @Override
    public NBTDataWrapper writeShort(int s) {
        this.writeList.func_74742_a((NBTBase)new NBTTagShort(null, (short)s));
        return this;
    }

    @Override
    public NBTDataWrapper writeByte(int b) {
        this.writeList.func_74742_a((NBTBase)new NBTTagByte(null, (byte)b));
        return this;
    }

    @Override
    public NBTDataWrapper writeDouble(double d) {
        this.writeList.func_74742_a((NBTBase)new NBTTagDouble(null, d));
        return this;
    }

    @Override
    public NBTDataWrapper writeFloat(float f) {
        this.writeList.func_74742_a((NBTBase)new NBTTagFloat(null, f));
        return this;
    }

    @Override
    public NBTDataWrapper writeBoolean(boolean b) {
        this.writeList.func_74742_a((NBTBase)new NBTTagByte(null, (byte)(b ? 1 : 0)));
        return this;
    }

    @Override
    public NBTDataWrapper writeChar(char c) {
        this.writeList.func_74742_a((NBTBase)new NBTTagShort(null, (short)c));
        return this;
    }

    @Override
    public NBTDataWrapper writeByteArray(byte[] array) {
        this.writeList.func_74742_a((NBTBase)new NBTTagByteArray(null, array));
        return this;
    }

    @Override
    public NBTDataWrapper writeString(String s) {
        this.writeList.func_74742_a((NBTBase)new NBTTagString(null, s));
        return this;
    }

    @Override
    public NBTDataWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public NBTDataWrapper writeCoord(BlockCoord coord) {
        this.writeCoord(coord.x, coord.y, coord.z);
        return this;
    }

    @Override
    public NBTDataWrapper writeNBTTagCompound(NBTTagCompound tag) {
        this.writeList.func_74742_a((NBTBase)tag);
        return this;
    }

    @Override
    public NBTDataWrapper writeItemStack(ItemStack stack) {
        this.writeList.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        return this;
    }

    @Override
    public NBTDataWrapper writeLiquidStack(LiquidStack liquid) {
        this.writeList.func_74742_a((NBTBase)liquid.writeToNBT(new NBTTagCompound()));
        return this;
    }

    @Override
    public long readLong() {
        return ((NBTTagLong)this.readTag()).field_74753_a;
    }

    @Override
    public int readInt() {
        return ((NBTTagInt)this.readTag()).field_74748_a;
    }

    @Override
    public short readShort() {
        return ((NBTTagShort)this.readTag()).field_74752_a;
    }

    @Override
    public int readUnsignedShort() {
        return ((NBTTagShort)this.readTag()).field_74752_a & 0xFFFF;
    }

    @Override
    public byte readByte() {
        return ((NBTTagByte)this.readTag()).field_74756_a;
    }

    @Override
    public int readUnsignedByte() {
        return ((NBTTagByte)this.readTag()).field_74756_a & 0xFF;
    }

    @Override
    public double readDouble() {
        return ((NBTTagDouble)this.readTag()).field_74755_a;
    }

    @Override
    public float readFloat() {
        return ((NBTTagFloat)this.readTag()).field_74750_a;
    }

    @Override
    public boolean readBoolean() {
        return ((NBTTagByte)this.readTag()).field_74756_a != 0;
    }

    @Override
    public char readChar() {
        return (char)((NBTTagShort)this.readTag()).field_74752_a;
    }

    @Override
    public byte[] readByteArray(int length) {
        return ((NBTTagByteArray)this.readTag()).field_74754_a;
    }

    @Override
    public String readString() {
        return ((NBTTagString)this.readTag()).field_74751_a;
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public NBTTagCompound readNBTTagCompound() {
        return (NBTTagCompound)this.readTag();
    }

    @Override
    public ItemStack readItemStack() {
        return ItemStack.func_77949_a((NBTTagCompound)this.readNBTTagCompound());
    }

    @Override
    public LiquidStack readLiquidStack() {
        return LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)this.readNBTTagCompound());
    }

    private NBTBase readTag() {
        return this.readList.func_74743_b(this.readTag++);
    }
}

