/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.gui;

import codechicken.core.alg.MathHelper;
import codechicken.core.gui.GuiWidget;
import net.minecraft.client.gui.GuiButton;

public abstract class GuiScrollSlot
extends GuiWidget {
    protected GuiButton scrollupbutton;
    protected GuiButton scrolldownbutton;
    protected String actionCommand;
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    protected int lastslotclicked = -1;
    protected int lastbuttonclicked = -1;
    protected long lastslotclicktime;
    public boolean focused;
    public int contentx;
    public int contenty;
    public int contentheight;
    public boolean smoothScroll = true;

    public GuiScrollSlot(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setContentSize(x + 3, y + 2, height - 2);
    }

    public GuiScrollSlot setActionCommand(String s) {
        this.actionCommand = s;
        return this;
    }

    public void setSmoothScroll(boolean b) {
        this.smoothScroll = b;
    }

    @Override
    public void setSize(int x, int y, int width, int height) {
        int cx = this.contentx - this.x;
        int cy = this.contenty - this.y;
        int ch = height - this.contentheight;
        super.setSize(x, y, width, height);
        this.setContentSize(x + cx, y + cy, height - ch);
    }

    public void setContentSize(int x, int y, int h) {
        this.contentx = x;
        this.contenty = y;
        this.contentheight = h;
    }

    public void registerButtons(GuiButton up, GuiButton down, String selectionCommand) {
        this.scrollupbutton = up;
        this.scrolldownbutton = down;
        this.actionCommand = selectionCommand;
    }

    public abstract int getSlotHeight();

    protected abstract int getNumSlots();

    public abstract void selectNext();

    public abstract void selectPrev();

    protected abstract void slotClicked(int var1, int var2, int var3, int var4, boolean var5);

    protected abstract boolean isSlotSelected(int var1);

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, boolean var6, float var7);

    protected void unfocus() {
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
        if (!this.focused) {
            this.unfocus();
        }
    }

    public void scrollUp() {
        this.scroll(-5);
    }

    public void scrollDown() {
        this.scroll(5);
    }

    public void scroll(int i) {
        this.percentscrolled += (float)i / (float)this.contentheight * 100.0f;
        this.calculatePercentScrolled();
    }

    public int totalContentHeight() {
        return this.getNumSlots() * this.getSlotHeight();
    }

    public int getSlotY(int slot) {
        int scrolledPixels = (int)((double)((float)(this.totalContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
        if (!this.smoothScroll) {
            scrolledPixels = (int)((double)scrolledPixels / (double)this.getSlotHeight() + 0.5) * this.getSlotHeight();
        }
        return this.contenty - scrolledPixels + slot * this.getSlotHeight();
    }

    public int getClickedSlot(int mousey) {
        if (mousey < this.contenty || mousey >= this.contenty + this.contentheight) {
            return -1;
        }
        for (int slot = 0; slot < this.getNumSlots(); ++slot) {
            int sloty = this.getSlotY(slot);
            if (mousey < sloty || mousey >= sloty + this.getSlotHeight()) continue;
            return slot;
        }
        return -1;
    }

    public int getScrollBarWidth() {
        return 5;
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.contentheight / (float)this.totalContentHeight() * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        this.percentscrolled = (float)MathHelper.clip(this.percentscrolled, 0.0, 1.0);
    }

    public void showSlot(int slot) {
        int sloty = this.getSlotY(slot);
        if (sloty + this.getSlotHeight() > this.contenty + this.contentheight) {
            int diff = sloty - (this.contenty + this.contentheight - this.getSlotHeight());
            this.percentscrolled = (float)((double)this.percentscrolled + (double)diff / (double)(this.totalContentHeight() - this.contentheight));
            this.calculatePercentScrolled();
        } else if (sloty < this.contenty) {
            int diff = this.contenty - sloty;
            this.percentscrolled = (float)((double)this.percentscrolled - (double)diff / (double)(this.totalContentHeight() - this.contentheight));
            this.calculatePercentScrolled();
        }
    }

    public void processMouse(int mousex, int mousey) {
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public void actionPerformed(GuiButton guibutton) {
        if (!guibutton.field_73742_g) {
            return;
        }
        if (this.scrollupbutton != null && guibutton.field_73741_f == this.scrollupbutton.field_73741_f) {
            this.scrollUp();
        } else if (this.scrolldownbutton != null && guibutton.field_73741_f == this.scrolldownbutton.field_73741_f) {
            this.scrollDown();
        }
    }

    @Override
    public void mouseClicked(int mousex, int mousey, int button) {
        boolean needsfocus;
        boolean bl = needsfocus = mousex >= this.x && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height;
        if (needsfocus != this.focused) {
            this.setFocused(needsfocus);
        }
        int barempty = this.height - this.getScrollBarHeight();
        int sbarx = this.x + this.width - this.getScrollBarWidth();
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        if (button == 0 && this.getScrollBarHeight() < this.height && mousex >= sbarx && mousex <= this.x + this.width && mousey >= this.y && mousey <= this.y + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.y - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
        } else if (mousex >= this.contentx && mousex < sbarx && mousey >= this.contenty && mousey <= this.contenty + this.contentheight) {
            int slot = this.getClickedSlot(mousey);
            if (slot >= 0) {
                this.slotClicked(slot, button, mousex - this.contentx, mousey - this.getSlotY(slot), slot == this.lastslotclicked && button == this.lastbuttonclicked && System.currentTimeMillis() - this.lastslotclicktime < 500L);
            }
            this.lastslotclicked = slot;
            this.lastbuttonclicked = button;
            this.lastslotclicktime = System.currentTimeMillis();
        }
    }

    @Override
    public void mouseMovedOrUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
    }

    @Override
    public void keyTyped(char c, int keycode) {
        if (!this.focused) {
            return;
        }
        if (keycode == 200) {
            this.selectPrev();
        }
        if (keycode == 208) {
            this.selectNext();
        }
        if (keycode == 28 && this.actionCommand != null) {
            this.sendAction(this.actionCommand, new Object[0]);
        }
    }

    public void drawSlotBox(float frame) {
        GuiScrollSlot.func_73734_a(this.x, this.y, this.x + this.width, this.y + this.height, -16777216);
    }

    public void drawBackground(float frame) {
    }

    public void drawOverlay(float frame) {
        GuiScrollSlot.func_73734_a(this.x, this.y - 1, this.x + this.width, this.y, -6250336);
        GuiScrollSlot.func_73734_a(this.x, this.y + this.height, this.x + this.width, this.y + this.height + 1, -6250336);
        GuiScrollSlot.func_73734_a(this.x - 1, this.y - 1, this.x, this.y + this.height + 1, -6250336);
        GuiScrollSlot.func_73734_a(this.x + this.width, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, -6250336);
    }

    public void drawScrollBar(float frame) {
        int sbarw = this.getScrollBarWidth();
        int sbarh = this.getScrollBarHeight();
        int sbarx = this.x + this.width - sbarw;
        int sbary = this.y + (int)((double)((float)(this.height - sbarh) * this.percentscrolled) + 0.4999);
        GuiScrollSlot.func_73734_a(sbarx, sbary, sbarx + sbarw, sbary + sbarh, -7631989);
        GuiScrollSlot.func_73734_a(sbarx, sbary, sbarx + sbarw - 1, sbary + sbarh - 1, -986896);
        GuiScrollSlot.func_73734_a(sbarx + 1, sbary + 1, sbarx + sbarw, sbary + sbarh, -11184811);
        GuiScrollSlot.func_73734_a(sbarx + 1, sbary + 1, sbarx + sbarw - 1, sbary + sbarh - 1, -3750202);
        if (this.drawLineGuide()) {
            GuiScrollSlot.func_73734_a(sbarx - 1, this.y, sbarx, this.y + this.height, -8355712);
        }
    }

    public boolean drawLineGuide() {
        return true;
    }

    public void drawSlots(int mousex, int mousey, float frame) {
        for (int slot = 0; slot < this.getNumSlots(); ++slot) {
            int sloty = this.getSlotY(slot);
            if (sloty <= this.contenty - this.getSlotHeight() || sloty >= this.contenty + this.contentheight) continue;
            this.drawSlot(slot, this.contentx, sloty, mousex - this.contentx, mousey - sloty, this.isSlotSelected(slot), frame);
        }
    }

    @Override
    public void mouseDragged(int x, int y, int button, long time) {
        this.processMouse(x, y);
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        this.drawBackground(frame);
        this.drawSlotBox(frame);
        this.drawSlots(mousex, mousey, frame);
        this.drawOverlay(frame);
        this.drawScrollBar(frame);
    }
}

