/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.gui.GuiWidget;
import codechicken.core.gui.IGuiActionListener;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerWidget
extends GuiContainer
implements IGuiActionListener {
    public ArrayList widgets = new ArrayList();

    public GuiContainerWidget(Container inventorySlots) {
        this(inventorySlots, 176, 166);
    }

    public GuiContainerWidget(Container inventorySlots, int xSize, int ySize) {
        super(inventorySlots);
        this.field_74194_b = xSize;
        this.field_74195_c = ySize;
    }

    public void reset() {
        super.refresh();
        this.widgets.clear();
        this.addWidgets();
    }

    @Override
    public void func_73872_a(Minecraft mc, int i, int j) {
        boolean init = this.field_73882_e == null;
        super.func_73872_a(mc, i, j);
        if (init) {
            this.addWidgets();
        }
    }

    public void add(GuiWidget widget) {
        this.widgets.add(widget);
        widget.onAdded(this);
    }

    @Override
    protected void func_74185_a(float f, int mousex, int mousey) {
        GL11.glTranslated((double)this.field_74198_m, (double)this.field_74197_n, (double)0.0);
        this.drawBackground();
        for (GuiWidget widget : this.widgets) {
            widget.draw(mousex - this.field_74198_m, mousey - this.field_74197_n, f);
        }
        GL11.glTranslated((double)(-this.field_74198_m), (double)(-this.field_74197_n), (double)0.0);
    }

    public void drawBackground() {
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseClicked(x - this.field_74198_m, y - this.field_74197_n, button);
        }
    }

    @Override
    protected void func_73879_b(int x, int y, int button) {
        super.func_73879_b(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseMovedOrUp(x - this.field_74198_m, y - this.field_74197_n, button);
        }
    }

    @Override
    protected void func_85041_a(int x, int y, int button, long time) {
        super.func_85041_a(x, y, button, time);
        for (GuiWidget widget : this.widgets) {
            widget.mouseDragged(x - this.field_74198_m, y - this.field_74197_n, button, time);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.field_73882_e.field_71462_r == this) {
            for (GuiWidget widget : this.widgets) {
                widget.update();
            }
        }
    }

    @Override
    public void func_73869_a(char c, int keycode) {
        super.func_73869_a(c, keycode);
        for (GuiWidget widget : this.widgets) {
            widget.keyTyped(c, keycode);
        }
    }

    @Override
    public void func_73867_d() {
        super.func_73867_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            Point p = this.getMousePosition();
            int scroll = i > 0 ? 1 : -1;
            for (GuiWidget widget : this.widgets) {
                widget.mouseScrolled(p.x, p.y, scroll);
            }
        }
    }

    public Point getMousePosition() {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_73882_e.field_71474_y, this.field_73882_e.field_71443_c, this.field_73882_e.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        return new Point(Mouse.getX() * w / this.field_73882_e.field_71443_c, h - Mouse.getY() * h / this.field_73882_e.field_71440_d - 1);
    }

    @Override
    public void actionPerformed(String ident, Object ... params) {
    }

    public void addWidgets() {
    }
}

