/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.InventoryRange;
import codechicken.core.vec.Vector3;
import com.google.common.base.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class InventoryUtils {
    public static final ForgeDirection[] chestSides = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    public static ItemStack decrStackSize(IInventory inv, int slot, int size) {
        ItemStack item = inv.func_70301_a(slot);
        if (item != null) {
            if (item.field_77994_a <= size) {
                ItemStack itemstack = item;
                inv.func_70299_a(slot, null);
                inv.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = item.func_77979_a(size);
            if (item.field_77994_a == 0) {
                inv.func_70299_a(slot, null);
            }
            inv.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public static ItemStack getStackInSlotOnClosing(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        inv.func_70299_a(slot, null);
        return stack;
    }

    public static int incrStackSize(ItemStack base, ItemStack addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.field_77994_a);
        }
        return 0;
    }

    public static int incrStackSize(ItemStack base, int addition) {
        int totalSize = base.field_77994_a + addition;
        if (totalSize <= base.func_77976_d()) {
            return addition;
        }
        if (base.field_77994_a < base.func_77976_d()) {
            return base.func_77976_d() - base.field_77994_a;
        }
        return 0;
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", items[i].field_77994_a);
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)items[i].field_77994_a);
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!tag.func_74764_b("Quantity")) continue;
            NBTBase qtag = tag.func_74781_a("Quantity");
            if (qtag instanceof NBTTagInt) {
                items[b].field_77994_a = ((NBTTagInt)qtag).field_74748_a;
                continue;
            }
            if (!(qtag instanceof NBTTagShort)) continue;
            items[b].field_77994_a = ((NBTTagShort)qtag).field_74752_a;
        }
    }

    public static void dropItem(ItemStack stack, World world, Vector3 dropLocation) {
        EntityItem item = new EntityItem(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + (double)0.2f;
        item.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
        world.func_72838_d((Entity)item);
    }

    public static ItemStack copyStack(ItemStack stack, int quantity) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = quantity;
        return stack;
    }

    public static boolean areStacksSameTypeCrafting(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.field_77993_c == stack2.field_77993_c && (stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == -1 || stack2.func_77960_j() == -1 || stack1.func_77973_b().func_77645_m());
    }

    public static int getInsertableQuantity(InventoryRange inv, ItemStack stack) {
        int quantity = 0;
        stack = InventoryUtils.copyStack(stack, Integer.MAX_VALUE);
        for (int slot : inv.slots) {
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
        }
        return quantity;
    }

    public static int fitStackInSlot(InventoryRange inv, int slot, ItemStack stack) {
        ItemStack base = inv.inv.func_70301_a(slot);
        if (!InventoryUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = base != null ? InventoryUtils.incrStackSize(base, inv.inv.func_70297_j_() - base.field_77994_a) : inv.inv.func_70297_j_();
        return Math.min(fit, stack.field_77994_a);
    }

    public static boolean mergeItemStack(InventoryRange inv, ItemStack stack, boolean doMerge) {
        if (doMerge && !InventoryUtils.mergeItemStack(inv, stack, false)) {
            return false;
        }
        stack = stack.func_77946_l();
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot : inv.slots) {
                ItemStack base = inv.inv.func_70301_a(slot);
                int fit = InventoryUtils.fitStackInSlot(inv, slot, stack);
                if (fit == 0) continue;
                if (base != null) {
                    stack.field_77994_a -= fit;
                    if (doMerge) {
                        base.field_77994_a += fit;
                        inv.inv.func_70299_a(slot, base);
                    }
                } else if (pass == 1) {
                    if (doMerge) {
                        inv.inv.func_70299_a(slot, InventoryUtils.copyStack(stack, fit));
                    }
                    stack.field_77994_a -= fit;
                }
                if (stack.field_77994_a != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areStacksIdentical(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.field_77993_c == stack2.field_77993_c && stack1.func_77960_j() == stack2.func_77960_j() && stack1.field_77994_a == stack2.field_77994_a && Objects.equal((Object)stack1.func_77978_p(), (Object)stack2.func_77978_p());
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            return InventoryUtils.getChest((TileEntityChest)tile);
        }
        return (IInventory)tile;
    }

    public static IInventory getChest(TileEntityChest chest) {
        for (ForgeDirection fside : chestSides) {
            if (chest.field_70331_k.func_72798_a(chest.field_70329_l + fside.offsetX, chest.field_70330_m + fside.offsetY, chest.field_70327_n + fside.offsetZ) != chest.func_70311_o().field_71990_ca) continue;
            return new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)chest.field_70331_k.func_72796_p(chest.field_70329_l + fside.offsetX, chest.field_70330_m + fside.offsetY, chest.field_70327_n + fside.offsetZ)), (IInventory)chest);
        }
        return chest;
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1 == null || stack2 == null || stack1.field_77993_c == stack2.field_77993_c && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && stack1.func_77985_e();
    }

    public static void consumeItem(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        Item item = stack.func_77973_b();
        if (item.func_77634_r()) {
            ItemStack container = item.getContainerItemStack(stack);
            inv.func_70299_a(slot, container);
        } else {
            inv.func_70298_a(slot, 1);
        }
    }

    public static int stackSize(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        return stack == null ? 0 : stack.field_77994_a;
    }

    public static ItemStack getRemovableStack(InventoryRange inv, int slot) {
        ItemStack stack = inv.inv.func_70301_a(slot);
        if (stack == null || !inv.canExtractItem(slot, stack)) {
            return null;
        }
        return stack;
    }

    public static void dropOnClose(EntityPlayer player, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70304_b(i);
            if (stack == null) continue;
            player.func_71021_b(stack);
        }
    }

    public static int actualDamage(ItemStack stack) {
        return Item.field_77702_n.getDamage(stack);
    }
}

