/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;

public class CCRenderState {
    private static boolean useNormals;
    private static boolean hasBrightness;
    private static int brightness;
    private static boolean useModelColours;
    private static int colour;
    private static boolean hasColour;
    private static int alpha;
    private static boolean alphaOverride;

    public static void useNormals(boolean b) {
        useNormals = b;
    }

    public static boolean useNormals() {
        return useNormals;
    }

    public static void useModelColours(boolean b) {
        useModelColours = b;
    }

    public static boolean useModelColours() {
        return useModelColours;
    }

    public static void setAlpha(int a) {
        alpha = a;
        alphaOverride = true;
    }

    public static void clearAlphaOverride() {
        alphaOverride = false;
    }

    public static void vertexColour(int c) {
        if (alphaOverride) {
            CCRenderState.setColour(c & 0xFFFFFF00 | alpha);
        } else {
            CCRenderState.setColour(c);
        }
    }

    public static void vertexColour(int r, int g, int b, int a) {
        if (alphaOverride) {
            Tessellator.field_78398_a.func_78370_a(r, g, b, alpha);
        } else {
            Tessellator.field_78398_a.func_78370_a(r, g, b, a);
        }
    }

    public static void setBrightness(IBlockAccess world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        CCRenderState.setBrightness(block == null ? world.func_72802_i(x, y, z, 0) : block.func_71874_e(world, x, y, z));
        CCRenderState.setColour(-1);
    }

    public static void setBrightness(int b) {
        hasBrightness = true;
        brightness = b;
        Tessellator.field_78398_a.func_78380_c(brightness);
    }

    public static void setColourOpaque(int c) {
        CCRenderState.setColour(c << 8 | 0xFF);
    }

    public static void setColour(int c) {
        hasColour = true;
        colour = c;
        Tessellator.field_78398_a.func_78370_a(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public static void changeTexture(String texture) {
        Minecraft.func_71410_x().field_71446_o.func_98187_b(texture);
        if (Tessellator.field_78398_a.field_78415_z) {
            CCRenderState.apply();
        }
    }

    public static void apply() {
        if (hasBrightness) {
            Tessellator.field_78398_a.func_78380_c(brightness);
        }
        if (hasColour) {
            Tessellator.field_78398_a.func_78370_a(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
        }
    }

    public static void reset() {
        hasBrightness = false;
        useModelColours = false;
        hasColour = false;
        alphaOverride = false;
    }

    public static void startDrawing(int i) {
        Tessellator.field_78398_a.func_78371_b(i);
        CCRenderState.apply();
    }

    public static void draw() {
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void pullLightmap() {
        CCRenderState.setBrightness((int)OpenGlHelper.lastBrightnessY << 16 | (int)OpenGlHelper.lastBrightnessX);
    }

    public static void applyBrightnessTexCoords() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(brightness & 0xFFFF), (float)(brightness >>> 16));
    }
}

