/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.CCRenderState;
import codechicken.core.render.IFaceRenderer;
import codechicken.core.render.IUVTransformation;
import codechicken.core.render.IVertexModifier;
import codechicken.core.render.TextureUtils;
import codechicken.core.render.UV;
import codechicken.core.render.Vertex5;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Rotation;
import codechicken.core.vec.Transformation;
import codechicken.core.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static RenderItem uniformRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };
    static EntityItem entityItem;
    private static Vertex5[] face;

    public static Icon bindLiquidTexture(int liquidID, int liquidMeta) {
        if (liquidID < Block.field_71973_m.length && Block.field_71973_m[liquidID] != null) {
            Block liquidBlock = Block.field_71973_m[liquidID];
            return liquidBlock.func_71858_a(0, liquidMeta);
        }
        Item liquidItem = Item.field_77698_e[liquidID];
        if (liquidItem == null) {
            return null;
        }
        return liquidItem.func_77617_a(liquidMeta);
    }

    public static void renderLiquidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, Icon icon, double res) {
        double rx;
        double u1 = icon.func_94209_e();
        double du = icon.func_94212_f() - icon.func_94209_e();
        double v2 = icon.func_94210_h();
        double dv = icon.func_94210_h() - icon.func_94206_g();
        Vector3 wide = vectors[0].set(point4).subtract(point1);
        Vector3 high = vectors[1].set(point1).subtract(point2);
        Tessellator t = Tessellator.field_78398_a;
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                t.func_78374_a(point2.x + dx1.x + dy2.x, point2.y + dx1.y + dy2.y, point2.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                t.func_78374_a(point2.x + dx1.x + dy1.x, point2.y + dx1.y + dy1.y, point2.z + dx1.z + dy1.z, u1, v2);
                t.func_78374_a(point2.x + dx2.x + dy1.x, point2.y + dx2.y + dy1.y, point2.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                t.func_78374_a(point2.x + dx2.x + dy2.x, point2.y + dx2.y + dy2.y, point2.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator var2 = Tessellator.field_78398_a;
        var2.func_78371_b(3);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78381_a();
        var2.func_78371_b(3);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78381_a();
        var2.func_78371_b(1);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78381_a();
    }

    public static void renderLiquidCuboid(Cuboid6 bound, Icon tex, double res) {
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z - 0.009, (double)z + 1.009};
        Tessellator tessellator = Tessellator.field_78398_a;
        switch (side) {
            case 0: {
                tessellator.func_78374_a(points[0], points[2], points[4], tx1, ty1);
                tessellator.func_78374_a(points[1], points[2], points[4], tx2, ty1);
                tessellator.func_78374_a(points[1], points[2], points[5], tx2, ty2);
                tessellator.func_78374_a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.func_78374_a(points[1], points[3], points[4], tx2, ty1);
                tessellator.func_78374_a(points[0], points[3], points[4], tx1, ty1);
                tessellator.func_78374_a(points[0], points[3], points[5], tx1, ty2);
                tessellator.func_78374_a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.func_78374_a(points[0], points[3], points[4], tx2, ty1);
                tessellator.func_78374_a(points[1], points[3], points[4], tx1, ty1);
                tessellator.func_78374_a(points[1], points[2], points[4], tx1, ty2);
                tessellator.func_78374_a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.func_78374_a(points[1], points[3], points[5], tx2, ty1);
                tessellator.func_78374_a(points[0], points[3], points[5], tx1, ty1);
                tessellator.func_78374_a(points[0], points[2], points[5], tx1, ty2);
                tessellator.func_78374_a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.func_78374_a(points[0], points[3], points[5], tx2, ty1);
                tessellator.func_78374_a(points[0], points[3], points[4], tx1, ty1);
                tessellator.func_78374_a(points[0], points[2], points[4], tx1, ty2);
                tessellator.func_78374_a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.func_78374_a(points[1], points[3], points[4], tx2, ty1);
                tessellator.func_78374_a(points[1], points[3], points[5], tx1, ty1);
                tessellator.func_78374_a(points[1], points[2], points[5], tx1, ty2);
                tessellator.func_78374_a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderLiquid(LiquidStack liquid) {
        return liquid.amount > 0 && liquid.asItemStack().func_77973_b() != null;
    }

    public static void renderLiquidCuboid(LiquidStack liquid, Cuboid6 bound, double res) {
        if (!RenderUtils.shouldRenderLiquid(liquid)) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.setColourOpaque(liquid.asItemStack().func_77973_b().func_82790_a(liquid.asItemStack(), 0));
        TextureUtils.bindItemTexture(liquid.asItemStack());
        Icon tex = RenderUtils.bindLiquidTexture(liquid.itemID, liquid.itemMeta);
        CCRenderState.startDrawing(7);
        RenderUtils.renderLiquidCuboid(bound, tex, res);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static void renderItemUniform(ItemStack item) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (item.func_77973_b() instanceof ItemBlock && RenderBlocks.func_78597_b((int)Block.field_71973_m[item.field_77993_c].func_71857_b())) {
            int renderType = Block.field_71973_m[item.field_77993_c].func_71857_b();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        } else if (is3D) {
            larger = true;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.func_92058_a(item);
        uniformRenderItem.func_77014_a(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, 0.0f);
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    public static void addVertexWithTransform(double x, double y, double z, double u, double v, Transformation t, IUVTransformation ut) {
        UV uv = new UV(u, v).apply(ut);
        Vector3 vec = new Vector3(x, y, z).apply(t);
        Tessellator.field_78398_a.func_78374_a(vec.x, vec.y, vec.z, uv.u, uv.v);
    }

    public static void renderBlock(Cuboid6 c, int sideMask, IFaceRenderer r) {
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        double u1 = 0.0;
        double u2 = 0.0;
        double v1 = 0.0;
        double v2 = 0.0;
        if ((sideMask & 1) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            face[0].set(x1, y1, z2, u1, v2);
            face[1].set(x1, y1, z1, u1, v1);
            face[2].set(x2, y1, z1, u2, v1);
            face[3].set(x2, y1, z2, u2, v2);
            r.renderFace(face, c.min.y > 0.0 ? 6 : 0);
        }
        if ((sideMask & 2) == 0) {
            u1 = x1 + 2.0;
            v1 = z1;
            u2 = x2 + 2.0;
            v2 = z2;
            face[0].set(x2, y2, z2, u2, v2);
            face[1].set(x2, y2, z1, u2, v1);
            face[2].set(x1, y2, z1, u1, v1);
            face[3].set(x1, y2, z2, u1, v2);
            r.renderFace(face, c.max.y < 1.0 ? 7 : 1);
        }
        if ((sideMask & 4) == 0) {
            u1 = 1.0 - x1 + 4.0;
            v1 = 1.0 - y2;
            u2 = 1.0 - x2 + 4.0;
            v2 = 1.0 - y1;
            face[0].set(x1, y1, z1, u1, v2);
            face[1].set(x1, y2, z1, u1, v1);
            face[2].set(x2, y2, z1, u2, v1);
            face[3].set(x2, y1, z1, u2, v2);
            r.renderFace(face, c.min.z > 0.0 ? 8 : 2);
        }
        if ((sideMask & 8) == 0) {
            u1 = x1 + 6.0;
            v1 = 1.0 - y2;
            u2 = x2 + 6.0;
            v2 = 1.0 - y1;
            face[0].set(x2, y1, z2, u2, v2);
            face[1].set(x2, y2, z2, u2, v1);
            face[2].set(x1, y2, z2, u1, v1);
            face[3].set(x1, y1, z2, u1, v2);
            r.renderFace(face, c.max.z < 1.0 ? 9 : 3);
        }
        if ((sideMask & 0x10) == 0) {
            u1 = z1 + 8.0;
            v1 = 1.0 - y2;
            u2 = z2 + 8.0;
            v2 = 1.0 - y1;
            face[0].set(x1, y1, z2, u2, v2);
            face[1].set(x1, y2, z2, u2, v1);
            face[2].set(x1, y2, z1, u1, v1);
            face[3].set(x1, y1, z1, u1, v2);
            r.renderFace(face, c.min.x > 0.0 ? 10 : 4);
        }
        if ((sideMask & 0x20) == 0) {
            u1 = 1.0 - z1 + 10.0;
            v1 = 1.0 - y2;
            u2 = 1.0 - z2 + 10.0;
            v2 = 1.0 - y1;
            face[0].set(x2, y1, z1, u1, v2);
            face[1].set(x2, y2, z1, u1, v1);
            face[2].set(x2, y2, z2, u2, v1);
            face[3].set(x2, y1, z2, u2, v2);
            r.renderFace(face, c.max.x < 1.0 ? 11 : 5);
        }
    }

    public static void renderBlock(Cuboid6 bounds, int sideMask, final Transformation t, final IUVTransformation u, final IVertexModifier m) {
        RenderUtils.renderBlock(bounds, sideMask, new IFaceRenderer(){
            boolean drawNormal = CCRenderState.useNormals();
            boolean computeNormal = this.drawNormal || m != null && m.needsNormals();
            Vector3 normal = new Vector3();
            Vertex5 vert;
            Vector3 vec = new Vector3();
            UV uv = new UV();

            @Override
            public void renderFace(Vertex5[] face, int side) {
                Tessellator tess = Tessellator.field_78398_a;
                for (int i = 0; i < face.length; ++i) {
                    if (this.computeNormal) {
                        if (t != null) {
                            t.applyN(this.normal.set(Rotation.axes[side % 6]));
                        } else {
                            this.normal = Rotation.axes[side % 6];
                        }
                        if (this.drawNormal) {
                            tess.func_78375_b((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                        }
                    }
                    this.vert = face[i];
                    if (t != null) {
                        t.apply(this.vec.set(this.vert.vec));
                    } else {
                        this.vec = this.vert.vec;
                    }
                    if (u != null) {
                        u.transform(this.uv.set(this.vert.uv));
                    } else {
                        this.uv = this.vert.uv;
                    }
                    if (m != null) {
                        m.applyModifiers(null, tess, this.vec, this.uv, this.normal, i);
                    }
                    tess.func_78374_a(this.vec.x, this.vec.y, this.vec.z, this.uv.u, this.uv.v);
                }
            }
        });
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        uniformRenderItem.func_76976_a(RenderManager.field_78727_a);
        entityItem = new EntityItem(null);
        RenderUtils.entityItem.field_70290_d = 0.0f;
        face = new Vertex5[]{new Vertex5(), new Vertex5(), new Vertex5(), new Vertex5()};
    }
}

