/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.world;

import codechicken.core.world.WorldExtension;
import codechicken.core.world.WorldExtensionInstantiator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldExtensionManager {
    private static boolean initialised;
    private static ArrayList extensionIntialisers;
    private static HashMap worldMap;

    public static void registerWorldExtension(WorldExtensionInstantiator init) {
        if (!initialised) {
            WorldExtensionManager.init();
        }
        init.instantiatorID = extensionIntialisers.size();
        extensionIntialisers.add(init);
    }

    private static void init() {
        initialised = true;
        MinecraftForge.EVENT_BUS.register((Object)new WorldExtensionEventHandler());
        TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionServerTickHandler(), (Side)Side.SERVER);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionClientTickHandler(), (Side)Side.CLIENT);
        }
    }

    private static void onWorldLoad(World world) {
        WorldExtension[] extensions = new WorldExtension[extensionIntialisers.size()];
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = ((WorldExtensionInstantiator)extensionIntialisers.get(i)).createWorldExtension(world);
        }
        worldMap.put(world, extensions);
        for (WorldExtension extension : extensions) {
            extension.load();
        }
    }

    public static void onWorldUnload(World world) {
        for (WorldExtension extension : (WorldExtension[])worldMap.remove(world)) {
            extension.unload();
        }
    }

    private static void createChunkExtension(World world, Chunk chunk) {
        WorldExtension[] extensions = (WorldExtension[])worldMap.get(world);
        for (int i = 0; i < extensionIntialisers.size(); ++i) {
            if (extensions[i].containsChunk(chunk)) continue;
            extensions[i].addChunk(((WorldExtensionInstantiator)extensionIntialisers.get(i)).createChunkExtension(chunk, extensions[i]));
        }
    }

    private static void removeChunk(World world, Chunk chunk) {
        for (WorldExtension extension : (WorldExtension[])worldMap.get(world)) {
            extension.remChunk(chunk);
        }
    }

    private static void preTick(World world) {
        for (WorldExtension extension : (WorldExtension[])worldMap.get(world)) {
            extension.preTick();
        }
    }

    private static void postTick(World world) {
        for (WorldExtension extension : (WorldExtension[])worldMap.get(world)) {
            extension.postTick();
        }
    }

    public static WorldExtension getWorldExtension(World world, int instantiatorID) {
        return ((WorldExtension[])worldMap.get(world))[instantiatorID];
    }

    static {
        extensionIntialisers = new ArrayList();
        worldMap = new HashMap();
    }

    public static class WorldExtensionServerTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.preTick((World)tickData[0]);
            }
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.postTick((World)tickData[0]);
            }
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.WORLD, TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }

    public static class WorldExtensionClientTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.preTick((World)world);
                }
            }
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.postTick((World)world);
                }
            }
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }

    public static class WorldExtensionEventHandler {
        @ForgeSubscribe
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.loadChunkData(event.getChunk(), event.getData());
            }
        }

        @ForgeSubscribe
        public void onChunkDataSave(ChunkDataEvent.Save event) {
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.saveChunkData(event.getChunk(), event.getData());
            }
            if (!event.getChunk().field_76636_d) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.loadChunk(event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onChunkUnLoad(ChunkEvent.Unload event) {
            if (event.getChunk() instanceof EmptyChunk) {
                return;
            }
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.unloadChunk(event.getChunk());
            }
            if (event.world.field_72995_K) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onWorldSave(WorldEvent.Save event) {
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.save();
            }
        }

        @ForgeSubscribe
        public void onWorldLoad(WorldEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
        }

        @ForgeSubscribe
        public void onWorldUnLoad(WorldEvent.Unload event) {
            WorldExtensionManager.onWorldUnload(event.world);
        }

        @ForgeSubscribe
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.player.field_70170_p)) {
                extension.watchChunk(chunk, event.player);
            }
        }

        @ForgeSubscribe
        public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
            Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.player.field_70170_p)) {
                extension.unwatchChunk(chunk, event.player);
            }
        }
    }
}

