/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.HUDAugmenter;
import codechicken.nei.HUDAugmenterDefault;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.TMIUninstaller;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemInfo;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ClientHandler
implements ITickHandler {
    private static ClientHandler instance;
    private ArrayList SMPmagneticItems = new ArrayList();
    private World lastworld;
    private boolean firstTick = true;
    private boolean mobOverlayHeld = false;
    public int mobSpawnOverlay = 0;
    private boolean overlayKeyHeld = false;
    public int chunkOverlay = 0;

    public void addSMPMagneticItem(int i, World world) {
        WorldClient cworld = (WorldClient)world;
        Entity e = cworld.func_73045_a(i);
        if (e == null || !(e instanceof EntityItem)) {
            return;
        }
        this.SMPmagneticItems.add((EntityItem)e);
    }

    private void updateMagnetMode(World world, EntityPlayerSP player) {
        if (!NEIClientConfig.getMagnetMode()) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = world.field_72995_K ? this.SMPmagneticItems : world.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b((double)distancexz, (double)distancey, (double)distancexz));
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = (EntityItem)iterator.next();
            if (item.field_70293_c > 0) continue;
            if (item.field_70128_L && world.field_72995_K) {
                iterator.remove();
            }
            if (!NEIClientUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + speedxz * dx;
            double vy = item.field_70181_x + speedy * dy;
            double vz = item.field_70179_y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2 && world.field_72995_K) {
                item.func_70106_y();
            }
            item.func_70016_h(vx, vy, vz);
        }
    }

    public static void load() {
        try {
            TMIUninstaller.deleteTMIUninstaller();
            if (TMIUninstaller.TMIInstalled()) {
                TMIUninstaller.runTMIUninstaller();
                NEIClientUtils.mc().func_71405_e();
            }
        }
        catch (Exception e) {
            System.err.println("Error with TMI Uninstaller");
            e.printStackTrace();
        }
        instance = new ClientHandler();
        PacketCustom.assignHandler("NEI", 0, 255, new NEICPH());
        TickRegistry.registerTickHandler((ITickHandler)instance, (Side)Side.CLIENT);
        LanguageRegistry.instance().addStringLocalization("entity.SnowMan.name", "Snow Golem");
        API.registerHighlightHandler(new HUDAugmenterDefault(), ItemInfo.Layout.HEADER);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        GuiScreen gui;
        Minecraft mc = Minecraft.func_71410_x();
        if (type.contains(TickType.CLIENT) && mc.field_71441_e != null) {
            if (mc.field_71441_e != this.lastworld) {
                this.onWorldChange((World)mc.field_71441_e);
            }
            NEIController.updateUnlimitedItems(mc.field_71439_g.field_71071_by);
            NEIController.processCreativeCycling(mc.field_71439_g.field_71071_by);
            this.toggleChunkOverlay();
            this.toggleMobOverlay();
            this.updateMagnetMode((World)mc.field_71441_e, (EntityPlayerSP)mc.field_71439_g);
        }
        if (type.contains(TickType.CLIENT) && (gui = mc.field_71462_r) instanceof GuiMainMenu) {
            if (this.firstTick) {
                this.firstTick = false;
                this.onMainMenuInit();
            }
            if (this.lastworld != null) {
                this.lastworld = null;
            }
        }
    }

    private void toggleMobOverlay() {
        if (Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding("moboverlay"))) {
            if (!this.mobOverlayHeld) {
                this.mobSpawnOverlay = (this.mobSpawnOverlay + 1) % 2;
            }
            this.mobOverlayHeld = true;
        } else {
            this.mobOverlayHeld = false;
        }
    }

    private void toggleChunkOverlay() {
        if (Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding("chunkoverlay"))) {
            if (!this.overlayKeyHeld) {
                this.chunkOverlay = (this.chunkOverlay + 1) % 3;
            }
            this.overlayKeyHeld = true;
        } else {
            this.overlayKeyHeld = false;
        }
    }

    private void onWorldChange(World world) {
        NEIClientConfig.setHasSMPCounterPart(false);
        this.SMPmagneticItems.clear();
        this.chunkOverlay = 0;
        NEIClientConfig.setInternalEnabled(false);
        if (ClientUtils.isLocal()) {
            return;
        }
        NEIClientConfig.loadWorld("remote/" + ClientUtils.getServerIP().replace(':', '~'));
    }

    private void onMainMenuInit() {
        if (NEIClientConfig.getBooleanSetting("ID dump.dump on load")) {
            NEIClientUtils.dumpIDs();
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.RENDER)) {
            HUDAugmenter.renderOverlay();
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.CLIENT, TickType.RENDER);
    }

    public String getLabel() {
        return "NEI Client";
    }

    public static ClientHandler instance() {
        return instance;
    }

    public void setWorld(World world) {
        this.lastworld = world;
    }
}

