/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ContainerEnchantmentModifier
extends ContainerEnchantment {
    public ArrayList slotEnchantment = new ArrayList();
    int level = 5;
    public int scrollclicky = -1;
    public float scrollpercent;
    public int scrollmousey;
    public float percentscrolled;
    public int relx = 60;
    public int rely = 14;
    public int height = 57;
    public int cwidth = 101;
    public int slotheight = 19;
    public GuiEnchantmentModifier parentscreen;

    public ContainerEnchantmentModifier(InventoryPlayer inventoryplayer, World world, int i, int j, int k) {
        super(inventoryplayer, world, i, j, k);
    }

    public int getNumSlots() {
        return this.slotEnchantment.size();
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.height / (float)this.getContentHeight() * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public int getScrollBarWidth() {
        return 7;
    }

    public int getContentHeight() {
        return this.slotheight * this.getNumSlots();
    }

    public int getScrolledSlots() {
        int slots = this.getNumSlots();
        int shownslots = this.height / this.slotheight;
        return (int)(this.percentscrolled * (float)(slots - shownslots) + 0.5f);
    }

    private int getClickedSlot(int mousey) {
        return (mousey - this.rely) / this.slotheight + this.getScrolledSlots();
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        }
        int sbary = this.rely + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        this.percentscrolled = (float)(sbary - this.rely) / (float)barempty;
    }

    public boolean clickScrollBar(int mousex, int mousey, int button) {
        int barempty = this.height - this.getScrollBarHeight();
        int sbary = this.rely + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        if (button == 0 && this.getScrollBarHeight() < this.height && (mousex -= this.parentscreen.field_74198_m) >= this.relx + this.cwidth && mousex < this.relx + this.cwidth + this.getScrollBarWidth() && (mousey -= this.parentscreen.field_74197_n) >= this.rely && mousey < this.rely + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.rely) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.rely - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
            return true;
        }
        return false;
    }

    public void mouseUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
    }

    public boolean clickButton(int mousex, int mousey, int button) {
        if ((mousex -= this.parentscreen.field_74198_m) >= this.relx && mousex < this.relx + this.cwidth && (mousey -= this.parentscreen.field_74197_n) >= this.rely && mousey <= this.rely + this.height) {
            int slot = this.getClickedSlot(mousey);
            if (slot >= this.getNumSlots()) {
                return false;
            }
            this.toggleSlotEnchantment(slot);
            return true;
        }
        return false;
    }

    private void toggleSlotEnchantment(int slot) {
        EnchantmentHash e = (EnchantmentHash)this.slotEnchantment.get(slot);
        if (e.state == 2) {
            NEICPH.sendModifyEnchantment(e.enchantment.field_77352_x, 0, false);
            e.state = 0;
        } else {
            if (e.state == 1) {
                return;
            }
            NEICPH.sendModifyEnchantment(e.enchantment.field_77352_x, this.level, true);
            e.state = 2;
        }
        this.updateEnchantmentOptions();
    }

    public boolean addEnchantment(int e, int level) {
        if (e < Enchantment.field_77331_b.length && Enchantment.field_77331_b[e] != null) {
            ((Slot)this.field_75151_b.get(0)).func_75211_c().func_77966_a(Enchantment.field_77331_b[e], level);
            return true;
        }
        return false;
    }

    public void removeEnchantment(int e) {
        ItemStack stack = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        NBTTagList nbttaglist = stack.func_77986_q();
        if (nbttaglist != null) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short ID = ((NBTTagCompound)nbttaglist.func_74743_b(i)).func_74765_d("id");
                if (ID != e) continue;
                nbttaglist.func_74744_a(i);
                if (nbttaglist.func_74745_c() == 0) {
                    stack.func_77978_p().func_82580_o("ench");
                }
                if (stack.func_77978_p().func_82582_d()) {
                    stack.func_77982_d(null);
                }
                return;
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75130_a(IInventory iinventory) {
        if (this.parentscreen != null) {
            this.updateEnchantmentOptions();
        }
    }

    public void updateEnchantmentOptions() {
        int numoptions = this.slotEnchantment.size();
        this.slotEnchantment.clear();
        ItemStack toolstack = this.func_75139_a(0).func_75211_c();
        if (toolstack == null) {
            this.percentscrolled = 0.0f;
            return;
        }
        boolean validate = NEIClientConfig.validateEnchantments();
        Item item = toolstack.func_77973_b();
        int enchantablity = item.func_77619_b();
        if (enchantablity == 0 && validate) {
            this.percentscrolled = 0.0f;
            return;
        }
        for (Enchantment e : Enchantment.field_77331_b) {
            if (e == null || e.field_77351_y == null || !e.field_77351_y.func_77557_a(item) && validate) continue;
            int state = 0;
            int level = -1;
            if (NEIServerUtils.stackHasEnchantment(toolstack, e.field_77352_x)) {
                state = 2;
                level = NEIServerUtils.getEnchantmentLevel(toolstack, e.field_77352_x);
            } else if (NEIServerUtils.doesEnchantmentConflict(NEIServerUtils.getEnchantments(toolstack), e) && validate) {
                state = 1;
            }
            this.slotEnchantment.add(new EnchantmentHash(e, state, level));
        }
        if (numoptions != this.slotEnchantment.size()) {
            this.percentscrolled = 0.0f;
        }
    }

    public void drawSlots(GuiEnchantmentModifier gui) {
        for (int slot = 0; slot < 3; ++slot) {
            int shade = 0;
            String text = "";
            int containerslot = slot + this.getScrolledSlots();
            if (containerslot + 1 > this.slotEnchantment.size()) {
                shade = 1;
            } else {
                EnchantmentHash e = (EnchantmentHash)this.slotEnchantment.get(containerslot);
                shade = e.state;
                text = e.enchantment.func_77316_c(e.level == -1 ? this.level : e.level);
                if (gui.field_73882_e.field_71466_p.func_78256_a(text) > 95 && text.contains("Projectile")) {
                    text = text.replace("Projectile", "Proj");
                }
                if (gui.field_73882_e.field_71466_p.func_78256_a(text) > 95 && text.contains("Protection")) {
                    text = text.replace("Protection", "Protect");
                }
                if (gui.field_73882_e.field_71466_p.func_78256_a(text) > 95 && text.contains("Bane of")) {
                    text = text.replace("Bane of ", "");
                }
            }
            gui.field_73882_e.field_71446_o.func_98187_b("/gui/enchant.png");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hasScrollBar()) {
                gui.func_73729_b(this.relx, this.rely + slot * this.slotheight, 0, gui.field_74195_c + this.slotheight * shade, this.cwidth - 30, this.slotheight);
                gui.func_73729_b(this.relx + this.cwidth - 30, this.rely + slot * this.slotheight, this.cwidth - 23, gui.field_74195_c + this.slotheight * shade, 30, this.slotheight);
            } else {
                gui.func_73729_b(this.relx, this.rely + slot * this.slotheight, 0, gui.field_74195_c + this.slotheight * shade, this.cwidth + 7, this.slotheight);
            }
            gui.field_73886_k.func_78276_b(text, this.relx + 4, this.rely + slot * this.slotheight + 5, this.textColourFromState(shade));
        }
    }

    private boolean hasScrollBar() {
        return this.getNumSlots() > 3;
    }

    public void drawScrollBar(GuiEnchantmentModifier gui) {
        if (!this.hasScrollBar()) {
            return;
        }
        int sbary = this.rely + (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.percentscrolled) + 0.5);
        int sbarx = this.relx + this.cwidth;
        Gui.func_73734_a(sbarx, this.rely, sbarx + this.getScrollBarWidth(), this.rely + this.height, -14671840);
        Gui.func_73734_a(sbarx, sbary, sbarx + this.getScrollBarWidth(), sbary + this.getScrollBarHeight(), -7631989);
        Gui.func_73734_a(sbarx, sbary, sbarx + this.getScrollBarWidth() - 1, sbary + this.getScrollBarHeight() - 1, -986896);
        Gui.func_73734_a(sbarx + 1, sbary + 1, sbarx + this.getScrollBarWidth() - 1, sbary + this.getScrollBarHeight() - 1, -11184811);
        Gui.func_73734_a(sbarx + 1, sbary + 1, sbarx + this.getScrollBarWidth() - 2, sbary + this.getScrollBarHeight() - 2, -3750202);
    }

    private int textColourFromState(int shade) {
        if (shade == 0) {
            return 6839882;
        }
        if (shade == 1) {
            return 4226832;
        }
        return 0xFFFF80;
    }

    public void onUpdate(int mousex, int mousey) {
        this.processScrollMouse(mousex, mousey);
    }

    public void processScrollMouse(int mousex, int mousey) {
        mousex -= this.parentscreen.field_74198_m;
        mousey -= this.parentscreen.field_74197_n;
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public static class EnchantmentHash {
        Enchantment enchantment;
        int state;
        int level;

        public EnchantmentHash(Enchantment e, int i, int l) {
            this.enchantment = e;
            this.state = i;
            this.level = l;
        }
    }
}

