/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.InventoryNBT;
import codechicken.core.inventory.InventoryUtils;
import codechicken.core.inventory.SlotHandleClicks;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;

public class ContainerPotionCreator
extends ContainerExtended {
    InventoryPlayer playerInv;
    InventoryBasic potionInv;
    IInventory potionStoreInv;

    public ContainerPotionCreator(InventoryPlayer inventoryPlayer, IInventory potionStoreInv) {
        this.playerInv = inventoryPlayer;
        this.potionInv = new InventoryBasic("Potion", true, 1);
        this.potionStoreInv = potionStoreInv;
        this.func_75146_a(new SlotPotion((IInventory)this.potionInv, 0, 25, 102));
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotPotionStore(potionStoreInv, i, 8 + i * 18, 14));
        }
        this.bindPlayerInventory(inventoryPlayer, 8, 125);
    }

    @Override
    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        if (slotIndex < 10) {
            return this.func_75135_a(stack, 10, 46, true);
        }
        return this.func_75135_a(stack, 0, 1, false);
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            InventoryUtils.dropOnClose(player, (IInventory)this.potionInv);
        }
    }

    @Override
    public void handleInputPacket(PacketCustom packet) {
        ItemStack potion = this.potionInv.func_70301_a(0);
        if (potion == null) {
            return;
        }
        NBTTagList potionTagList = potion.func_77978_p().func_74761_m("CustomPotionEffects");
        if (packet.readBoolean()) {
            PotionEffect e = new PotionEffect(packet.readUnsignedByte(), packet.readInt(), packet.readUnsignedByte());
            for (int i = 0; i < potionTagList.func_74745_c(); ++i) {
                PotionEffect pe = PotionEffect.func_82722_b((NBTTagCompound)((NBTTagCompound)potionTagList.func_74743_b(i)));
                if (pe.func_76456_a() != e.func_76456_a()) continue;
                potionTagList.field_74747_a.set(i, e.func_82719_a(new NBTTagCompound()));
                return;
            }
            potionTagList.func_74742_a((NBTBase)e.func_82719_a(new NBTTagCompound()));
        } else {
            int rmID = packet.readUnsignedByte();
            int i = 0;
            while (i < potionTagList.func_74745_c()) {
                PotionEffect pe = PotionEffect.func_82722_b((NBTTagCompound)((NBTTagCompound)potionTagList.func_74743_b(i)));
                if (pe.func_76456_a() == rmID) {
                    potionTagList.func_74744_a(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public void setPotionEffect(int effectID, int duration, int amplifier) {
        PacketCustom packet = NEICPH.createContainerPacket();
        packet.writeBoolean(true);
        packet.writeByte(effectID);
        packet.writeInt(duration);
        packet.writeByte(amplifier);
        packet.sendToServer();
    }

    public void removePotionEffect(int effectID) {
        PacketCustom packet = NEICPH.createContainerPacket();
        packet.writeBoolean(false);
        packet.writeByte(effectID);
        packet.sendToServer();
    }

    public static class InventoryPotionStore
    extends InventoryNBT {
        public InventoryPotionStore() {
            super(9, NEIClientConfig.saveCompound.func_74775_l("potionStore"));
        }

        @Override
        public void func_70296_d() {
            super.func_70296_d();
            NEIClientConfig.saveCompound.func_74766_a("potionStore", this.tag);
            NEIClientConfig.saveConfig();
        }
    }

    public class SlotPotionStore
    extends SlotHandleClicks {
        public SlotPotionStore(IInventory inv, int slotIndex, int x, int y) {
            super(inv, slotIndex, x, y);
        }

        @Override
        public ItemStack slotClick(ContainerExtended container, EntityPlayer player, int button, int modifier) {
            ItemStack held = player.field_71071_by.func_70445_o();
            if (button == 0 && modifier == 1) {
                NEIClientUtils.cheatItem(this.func_75211_c(), button, -1);
            } else if (button == 1) {
                this.func_75215_d(null);
            } else if (held != null) {
                if (this.func_75214_a(held)) {
                    this.func_75215_d(InventoryUtils.copyStack(held, 1));
                    player.field_71071_by.func_70437_b(null);
                }
            } else if (this.func_75216_d()) {
                player.field_71071_by.func_70437_b(this.func_75211_c());
            }
            return null;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemPotion;
        }
    }

    public class SlotPotion
    extends Slot {
        public SlotPotion(IInventory inv, int slotIndex, int x, int y) {
            super(inv, slotIndex, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemPotion;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.func_75216_d()) {
                ItemStack stack = this.func_75211_c();
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound("tag"));
                }
                if (!stack.func_77978_p().func_74764_b("CustomPotionEffects")) {
                    stack.func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
                }
            }
        }
    }
}

