/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.Button;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemList;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SaveLoadButton;
import codechicken.nei.Widget;
import codechicken.nei.forge.GuiContainerManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DropDownWidget
extends Widget {
    public DropDownFile file = DropDownFile.dropDownInstance;
    private int dropDowna;
    private long lastclicktime;
    private ArrayList mouseovernamestack = new ArrayList();
    private boolean mouseoverTickRecorded;
    public boolean canChangeMouseOver = true;
    public ItemStack hoverItem;
    public SaveLoadButton[] stateButtons = new SaveLoadButton[7];
    public Button[] deleteButtons = new Button[7];
    public int maxheight;
    public int droppedwidth;
    private int relx;
    private int hiddenlevel;
    private LinkedList hiddenstack = new LinkedList();
    public static boolean texturedButtons;
    private static final int stacklatency = 4;

    public DropDownWidget() {
        for (int i = 0; i < 7; ++i) {
            final int savestate = i;
            this.stateButtons[i] = new SaveLoadButton("VIS"){

                @Override
                public void onTextChange() {
                    NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
                    NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
                    NBTTagCompound statelist = hashSave.func_74775_l("statename");
                    hashSave.func_74782_a("statename", (NBTBase)statelist);
                    statelist.func_74778_a("" + savestate, this.label.substring(5));
                    NEIClientConfig.saveConfig();
                }

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (rightclick) {
                        return false;
                    }
                    if (ItemVisibilityHash.isStateSaved(savestate)) {
                        NEIClientConfig.vishash.loadState(savestate);
                    } else {
                        NEIClientConfig.vishash.saveState(savestate);
                    }
                    return true;
                }
            };
            this.deleteButtons[i] = new Button("x"){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (!rightclick) {
                        NEIClientConfig.vishash.clearState(savestate);
                        return true;
                    }
                    return false;
                }
            };
            this.stateButtons[i].height = 20;
            this.deleteButtons[i].width = 16;
            this.deleteButtons[i].height = 16;
        }
    }

    @Override
    public void draw(GuiContainerManager gui, int mousex, int mousey) {
        this.hoverItem = null;
        boolean mouseover = super.contains(mousex, mousey);
        boolean bl = texturedButtons = NEIClientConfig.getLayoutStyle() == 0;
        if (!texturedButtons) {
            gui.drawRect(this.x, this.y, this.width, this.height, mouseover ? -297791480 : -301989888);
            gui.drawTextCentered(this.x, this.y, this.width, this.height, "Item SubSets", -1);
        } else {
            GL11.glDisable((int)2896);
            gui.bindTexture("/gui/gui.png");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tex = mouseover ? 2 : 1;
            LayoutManager.drawButtonBackground(gui, this.x - 1, this.y, this.width + 2, this.height, true, tex);
            if (mouseover) {
                gui.drawTextCentered("Item SubSets", this.x + this.width / 2, this.y + (this.height - 8) / 2, 0xFFFFA0);
            } else {
                gui.drawTextCentered("Item SubSets", this.x + this.width / 2, this.y + (this.height - 8) / 2, 0xE0E0E0);
            }
        }
        if (this.getDropDown() == 1) {
            if (this.mouseovernamestack.size() == 0) {
                this.setDropDown(0);
                return;
            }
            this.updateMouseOver(mousex, mousey);
            this.updatePosition(gui, mousex, mousey);
            this.file.draw(gui, mousex, mousey);
        } else if (this.getDropDown() == 2) {
            this.updateStatePosition(gui);
            this.drawStateButtons(gui, mousex, mousey);
        }
    }

    private void drawStateButtons(GuiContainerManager gui, int mousex, int mousey) {
        for (int i = 0; i < 7; ++i) {
            this.stateButtons[i].draw(gui, mousex, mousey);
            this.deleteButtons[i].draw(gui, mousex, mousey);
        }
    }

    private void updateStatePosition(GuiContainerManager gui) {
        int maxWidth = 0;
        for (int i = 0; i < 7; ++i) {
            this.deleteButtons[i].x = -1000;
            this.stateButtons[i].y = this.height + 2 + 22 * i;
            NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
            NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
            NBTTagCompound statelist = hashSave.func_74775_l("statename");
            hashSave.func_74782_a("statename", (NBTBase)statelist);
            String name = statelist.func_74779_i("" + i);
            if (statelist.func_74781_a("" + i) == null) {
                name = "" + (i + 1);
                statelist.func_74778_a("" + i, name);
            }
            this.stateButtons[i].label = (ItemVisibilityHash.isStateSaved(i) ? "Load " : "Save ") + name;
            int buttonw = gui.getStringWidth(this.stateButtons[i].label) + 26;
            if (buttonw + 22 > this.width) {
                buttonw = this.width - 22;
            }
            if (buttonw <= maxWidth) continue;
            maxWidth = buttonw;
        }
        int buttonx = this.x + (this.width - (maxWidth + 20)) / 2;
        for (int i = 0; i < 7; ++i) {
            this.stateButtons[i].width = maxWidth;
            this.stateButtons[i].x = buttonx;
            if (!ItemVisibilityHash.isStateSaved(i)) continue;
            this.deleteButtons[i].x = this.stateButtons[i].x + maxWidth + 2;
            this.deleteButtons[i].y = this.stateButtons[i].y + 2;
        }
    }

    private void updateMouseOver(int mousex, int mousey) {
        String newmouseover = this.file.updateMouseOver(mousex, mousey, (String)this.mouseovernamestack.get(0));
        if (!this.mouseoverTickRecorded) {
            if (this.canChangeMouseOver) {
                String prevmouseover = (String)this.mouseovernamestack.get(this.mouseovernamestack.size() - 1);
                String currentmouseover = (String)this.mouseovernamestack.get(0);
                if (!newmouseover.equals(prevmouseover)) {
                    for (int i = 0; i < this.mouseovernamestack.size(); ++i) {
                        this.mouseovernamestack.set(i, currentmouseover);
                    }
                }
                this.mouseovernamestack.add(newmouseover);
            } else {
                this.mouseovernamestack.add(this.mouseovernamestack.get(this.mouseovernamestack.size() - 1));
            }
            this.mouseoverTickRecorded = true;
        }
        if (((String)this.mouseovernamestack.get(0)).equals("") && !LayoutManager.dropDown.contains(mousex, mousey)) {
            this.setDropDown(0);
        }
    }

    private void updatePosition(GuiContainerManager gui, int mousex, int mousey) {
        this.rehashMaxHeight(gui);
        while (true) {
            int levelwidth;
            this.droppedwidth = 0;
            this.file.position(this.x + this.relx, this.y + this.height);
            if (this.droppedwidth > this.width) {
                levelwidth = this.file.getWidthAtLevel(this.hiddenlevel);
                if (mousex - levelwidth < this.x) {
                    levelwidth = this.droppedwidth - this.width;
                }
                DropDownWidget.moveMouse(gui.window.field_73882_e, -levelwidth, 0);
                mousex -= levelwidth;
                this.relx -= levelwidth;
                this.hiddenstack.addLast(levelwidth);
                ++this.hiddenlevel;
                continue;
            }
            if (this.relx >= 0 || this.width - this.droppedwidth <= (Integer)this.hiddenstack.getLast()) break;
            levelwidth = (Integer)this.hiddenstack.getLast();
            if (!((String)this.mouseovernamestack.get(0)).equals("")) {
                DropDownWidget.moveMouse(gui.window.field_73882_e, levelwidth, 0);
                mousex += levelwidth;
            }
            this.relx += levelwidth;
            this.hiddenstack.removeLast();
            --this.hiddenlevel;
        }
    }

    public static void moveMouse(Minecraft mc, int relx, int rely) {
        ScaledResolution sres = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
        Mouse.setCursorPosition((int)(Mouse.getX() + relx * mc.field_71443_c / sres.func_78326_a()), (int)(Mouse.getY() + rely * mc.field_71440_d / sres.func_78328_b()));
    }

    private void rehashMaxHeight(GuiContainerManager gui) {
        this.maxheight = gui.window.field_73881_g - this.height - this.y - 25;
        this.maxheight = this.maxheight / 18 * 18;
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (super.contains(mousex, mousey)) {
            if (button == 0) {
                if (System.currentTimeMillis() - this.lastclicktime < 300L) {
                    this.file.showAllItems();
                    this.file.updateState();
                    ItemList.updateSearch();
                    NEIClientConfig.vishash.save();
                }
                this.setDropDown(1);
                this.lastclicktime = System.currentTimeMillis();
            } else if (button == 1) {
                if (this.getDropDown() == 2) {
                    this.setDropDown(0);
                } else {
                    this.setDropDown(2);
                }
            }
            return true;
        }
        if (this.getDropDown() == 1) {
            return this.file.click(mousex, mousey, button);
        }
        if (this.getDropDown() == 2) {
            return this.processStateClick(mousex, mousey, button);
        }
        return false;
    }

    private boolean processStateClick(int mousex, int mousey, int button) {
        for (int i = 0; i < 7; ++i) {
            if ((!this.stateButtons[i].contains(mousex, mousey) || !this.stateButtons[i].handleClick(mousex, mousey, button)) && (!this.deleteButtons[i].contains(mousex, mousey) || !this.deleteButtons[i].handleClick(mousex, mousey, button))) continue;
            return true;
        }
        this.setDropDown(0);
        return false;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        for (int i = 0; i < 7; ++i) {
            if (!this.stateButtons[i].handleKeyPress(keyID, keyChar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onGuiClick(int mousex, int mousey) {
        if (this.getDropDown() == 2) {
            for (int i = 0; i < 7; ++i) {
                this.stateButtons[i].onGuiClick(mousex, mousey);
            }
            if (!this.contains(mousex, mousey)) {
                this.setDropDown(0);
            }
        }
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.getDropDown() == 1) {
            this.file.mouseUp(mousex, mousey, button);
        }
    }

    @Override
    public boolean contains(int mousex, int mousey) {
        return super.contains(mousex, mousey) || this.getDropDown() == 1 && this.file.contains(mousex, mousey) || this.getDropDown() == 2 && this.statesContain(mousex, mousey);
    }

    private boolean statesContain(int mousex, int mousey) {
        for (int i = 0; i < 7; ++i) {
            if (!this.stateButtons[i].contains(mousex, mousey) && !this.deleteButtons[i].contains(mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (this.getDropDown() == 1) {
            this.file.onMouseWheel(-i);
            return true;
        }
        return false;
    }

    public void setHoverItem(ItemStack item) {
        this.hoverItem = item;
    }

    @Override
    public void update(GuiContainerManager gui) {
        if (this.getDropDown() == 1) {
            if (this.mouseovernamestack.size() == 0) {
                this.setDropDown(0);
                return;
            }
            this.mouseovernamestack.remove(0);
            if (!this.mouseoverTickRecorded) {
                this.mouseovernamestack.add(this.mouseovernamestack.get(this.mouseovernamestack.size() - 1));
            }
            this.mouseoverTickRecorded = false;
        } else if (this.getDropDown() == 2) {
            for (int i = 0; i < 7; ++i) {
                this.stateButtons[i].update(gui);
            }
        }
    }

    public void setDropDown(int drop) {
        if (drop == 1) {
            this.mouseoverTickRecorded = false;
            this.mouseovernamestack.clear();
            for (int i = 0; i < 4; ++i) {
                this.mouseovernamestack.add("");
            }
        }
        this.dropDowna = drop;
    }

    public int getDropDown() {
        return this.dropDowna;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        return this.hoverItem;
    }

    @Override
    public List handleTooltip(int mx, int my, List tooltip) {
        return tooltip;
    }
}

