/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiCCTextField;
import codechicken.core.gui.GuiScrollSlot;
import codechicken.core.inventory.GuiContainerWidget;
import codechicken.core.render.FontUtils;
import codechicken.nei.ContainerPotionCreator;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiPotionCreator
extends GuiContainerWidget {
    int amplifier = 0;
    GuiCCButton ampDown;
    GuiCCButton ampUp;
    GuiSlotPotionEffects slotPotionEffects;
    GuiDurationField durationField;
    ContainerPotionCreator container = (ContainerPotionCreator)this.field_74193_d;

    public GuiPotionCreator(InventoryPlayer inventoryplayer) {
        super(new ContainerPotionCreator(inventoryplayer, new ContainerPotionCreator.InventoryPotionStore()), 176, 208);
    }

    public void applyEffect() {
        if (this.slotPotionEffects.selectedslot >= 0) {
            this.container.setPotionEffect(this.slotPotionEffects.selectedPotion(), this.durationField.getDurationTicks(), this.amplifier);
        }
    }

    public String translateAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
        }
        return Integer.toString(amplifier);
    }

    public void validateInputButtons() {
        this.ampDown.setEnabled(this.amplifier > 0);
        this.ampUp.setEnabled(this.amplifier < 3);
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
    }

    @Override
    public void drawBackground() {
        this.field_73882_e.field_71446_o.func_98187_b("/codechicken/nei/potion.png");
        this.func_73729_b(0, 0, 0, 0, this.field_74194_b, this.field_74195_c);
        FontUtils.drawCenteredString("Favourite Potions", this.field_74194_b / 2, 4, 0x404040);
        this.field_73886_k.func_78276_b("Duration", 12, 40, 0x404040);
        this.field_73886_k.func_78276_b("Level", 19, 73, 0x404040);
        FontUtils.drawCenteredString(this.translateAmplifier(this.amplifier), 33, 86, -10461088);
    }

    @Override
    public void addWidgets() {
        this.ampDown = new GuiCCButton(10, 84, 12, 12, "<").setActionCommand("ampDown");
        this.add(this.ampDown);
        this.ampUp = new GuiCCButton(44, 84, 12, 12, ">").setActionCommand("ampUp");
        this.add(this.ampUp);
        this.durationField = new GuiDurationField(15, 53, 35, 12);
        this.add(this.durationField);
        this.slotPotionEffects = new GuiSlotPotionEffects(60, 38);
        this.add(this.slotPotionEffects);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.slotPotionEffects.setEnabled(this.container.potionInv.func_70301_a(0) != null);
    }

    @Override
    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("ampDown")) {
            --this.amplifier;
        } else if (ident.equals("ampUp")) {
            ++this.amplifier;
        }
        this.applyEffect();
        this.validateInputButtons();
    }

    public class GuiDurationField
    extends GuiCCTextField {
        private String baseValue;

        public GuiDurationField(int x, int y, int width, int height) {
            super(x, y, width, height, "100");
            this.setMaxStringLength(4);
            this.setAllowedCharacters("0123456789");
            this.baseValue = this.getText();
        }

        public void setDurationTicks(int i) {
            String minutes = Integer.toString((i /= 20) / 60);
            String seconds = Integer.toString(i % 60);
            if (seconds.length() == 1) {
                seconds = '0' + seconds;
            }
            this.setText(minutes + seconds);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!this.isEnabled()) {
                this.setText("100");
            }
        }

        @Override
        public void onFocusChanged() {
            if (this.isFocused()) {
                this.baseValue = this.getText();
            } else if (!this.validateValue()) {
                this.setText(this.baseValue);
            } else {
                GuiPotionCreator.this.applyEffect();
            }
        }

        @Override
        public void onTextChanged(String oldText) {
            GuiPotionCreator.this.validateInputButtons();
        }

        private boolean validateValue() {
            try {
                int i = Integer.parseInt(this.getText());
                return i > 1 && this.getDurationTicks() < Short.MAX_VALUE && i / 100 <= 60 && i % 100 < 60;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        @Override
        public void drawText() {
            String s = this.getText();
            String seconds = s.substring(Math.max(0, s.length() - 2), Math.max(0, s.length() - 2) + Math.min(s.length(), 2));
            String minutes = s.length() < 3 ? "" : s.substring(0, s.length() - 2);
            int ty = this.y + this.height / 2 - 4;
            int tcolour = this.getTextColour();
            FontUtils.drawCenteredString(":", this.x + this.width / 2 + 1, ty, tcolour);
            FontUtils.drawRightString(seconds, this.x + this.width - 3, ty, tcolour);
            FontUtils.drawRightString(minutes, this.x + this.width / 2 - 1, ty, tcolour);
        }

        @Override
        public int getTextColour() {
            return this.isFocused() ? 0xCCCCCC : 0x909090;
        }

        public int getDurationTicks() {
            int i = Integer.parseInt(this.getText());
            return (i / 100 * 60 + i % 100) * 20;
        }
    }

    public class GuiSlotPotionEffects
    extends GuiScrollSlot {
        public int selectedslot;
        public boolean enabled;
        private ArrayList validPotions;

        public GuiSlotPotionEffects(int x, int y) {
            super(x, y, 108, 76);
            this.selectedslot = -1;
            this.enabled = true;
            this.validPotions = new ArrayList();
            for (Potion p : Potion.field_76425_a) {
                if (p == null) continue;
                this.validPotions.add(p);
            }
            this.setSmoothScroll(false);
            this.setContentSize(x, y, this.height);
        }

        @Override
        public int getSlotHeight() {
            return 19;
        }

        @Override
        public void drawSlotBox(float frame) {
            GuiSlotPotionEffects.func_73734_a(this.x, this.y, this.x + this.width, this.y + this.height, -16777216);
        }

        @Override
        public void drawOverlay(float frame) {
        }

        @Override
        public boolean drawLineGuide() {
            return false;
        }

        @Override
        public int getScrollBarWidth() {
            return 7;
        }

        @Override
        protected void drawSlot(int slot, int x, int y, int mx, int my, boolean selected, float frame) {
            int textColour;
            String amp;
            boolean blank;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Potion potion = (Potion)this.validPotions.get(slot);
            PotionEffect effect = this.getEffect(potion.field_76415_H);
            boolean bl = blank = effect == null;
            if (effect == null) {
                effect = new PotionEffect(potion.field_76415_H, 1200, 0);
            }
            int shade = this.selectedslot == slot ? 2 : (blank ? 1 : 0);
            GuiPotionCreator.this.field_73882_e.field_71446_o.func_98187_b("/gui/enchant.png");
            this.func_73729_b(x, y, 0, 166 + this.getSlotHeight() * shade, this.width - 30, this.getSlotHeight());
            this.func_73729_b(x + this.width - 30, y, this.width - 23, 166 + this.getSlotHeight() * shade, 30, this.getSlotHeight());
            if (potion.func_76400_d()) {
                GuiPotionCreator.this.field_73882_e.field_71446_o.func_98187_b("/gui/inventory.png");
                int icon = potion.func_76392_e();
                this.func_73729_b(x + 1, y + 1, 0 + icon % 8 * 18, 198 + icon / 8 * 18, 18, 18);
            }
            String name = StatCollector.func_74838_a((String)potion.func_76393_a());
            String string = amp = effect.func_76458_c() > 0 ? " " + GuiPotionCreator.this.translateAmplifier(effect.func_76458_c()) : "";
            int n = shade == 0 ? 6839882 : (textColour = shade == 1 ? 4226832 : 0xFFFF80);
            if (this.fontRenderer.func_78256_a(name + amp) < this.width - 20) {
                this.fontRenderer.func_78276_b(name + amp, x + 20, y + 1, textColour);
            } else {
                this.fontRenderer.func_78276_b(name, x + 20, y + 1, textColour);
                FontUtils.drawRightString(amp, x + this.width - 10, y + 10, textColour);
            }
            String duration = Potion.func_76389_a((PotionEffect)effect);
            textColour = shade == 0 ? 0xA0A0A0 : (shade == 1 ? 0x808080 : 0xCCCCCC);
            this.fontRenderer.func_78261_a(duration, x + 20, y + 10, textColour);
        }

        private PotionEffect getEffect(int id) {
            ItemStack potion = GuiPotionCreator.this.container.potionInv.func_70301_a(0);
            if (potion != null && potion.func_77942_o() && potion.func_77978_p().func_74764_b("CustomPotionEffects")) {
                NBTTagList potionTagList = potion.func_77978_p().func_74761_m("CustomPotionEffects");
                for (int i = 0; i < potionTagList.func_74745_c(); ++i) {
                    PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)((NBTTagCompound)potionTagList.func_74743_b(i)));
                    if (effect.func_76456_a() != id) continue;
                    return effect;
                }
            }
            return null;
        }

        @Override
        protected int getNumSlots() {
            return this.validPotions.size();
        }

        @Override
        protected boolean isSlotSelected(int slot) {
            return slot == this.selectedslot;
        }

        @Override
        protected void slotClicked(int slot, int button, int mx, int my, boolean doubleclick) {
            if (!this.enabled) {
                return;
            }
            if (button == 0) {
                this.select(slot);
                GuiPotionCreator.this.applyEffect();
            } else if (button == 1) {
                this.deselect();
                GuiPotionCreator.this.container.removePotionEffect(((Potion)this.validPotions.get((int)slot)).field_76415_H);
            }
        }

        @Override
        public void selectNext() {
            if (this.selectedslot >= 0 && this.selectedslot + 1 < this.getNumSlots()) {
                this.select(this.selectedslot + 1);
                this.showSlot(this.selectedslot);
            }
        }

        @Override
        public void selectPrev() {
            if (this.selectedslot > 0) {
                this.select(this.selectedslot - 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void setEnabled(boolean b) {
            if (b == this.enabled) {
                return;
            }
            this.enabled = b;
            if (!this.enabled) {
                this.deselect();
            }
        }

        private void select(int slot) {
            this.selectedslot = slot;
            GuiPotionCreator.this.durationField.setEnabled(true);
            PotionEffect effect = this.getEffect(((Potion)this.validPotions.get((int)slot)).field_76415_H);
            if (effect == null) {
                effect = new PotionEffect(((Potion)this.validPotions.get((int)slot)).field_76415_H, 1200, 0);
            }
            GuiPotionCreator.this.durationField.setDurationTicks(effect.func_76459_b());
            GuiPotionCreator.this.amplifier = effect.func_76458_c();
            GuiPotionCreator.this.validateInputButtons();
        }

        private void deselect() {
            this.selectedslot = -1;
            GuiPotionCreator.this.durationField.setEnabled(false);
            GuiPotionCreator.this.ampDown.setEnabled(false);
            GuiPotionCreator.this.ampUp.setEnabled(false);
        }

        public int selectedPotion() {
            return ((Potion)this.validPotions.get((int)this.selectedslot)).field_76415_H;
        }
    }
}

