/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SubSetRangeTag;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.forge.GuiContainerManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemList {
    public static ArrayList items = new ArrayList();
    private static boolean matching = false;
    private static boolean loading = false;
    private static boolean research = false;
    private static boolean reload = false;
    private static HashSet erroredIDs = new HashSet();
    private static HashSet stackTraces = new HashSet();

    public static ItemMatcher getSearchMatcher() {
        Pattern pattern;
        String matchstring = NEIClientConfig.getSearchExpression().toLowerCase();
        if (matchstring.startsWith("@") && matchstring.length() > 1) {
            LinkedList<SubSetRangeTag> tags = new LinkedList<SubSetRangeTag>();
            try {
                String pattern2 = matchstring.substring(1);
                for (SubSetRangeTag tag : DropDownFile.dropDownInstance.allTags()) {
                    if (!CommonUtils.filterText(tag.qualifiedname).toLowerCase().contains(pattern2)) continue;
                    tags.add(tag);
                }
                if (tags.isEmpty()) {
                    return new NothingItemMatcher();
                }
                return new SubsetItemMatcher(tags);
            }
            catch (PatternSyntaxException e) {
                return new NothingItemMatcher();
            }
        }
        matchstring = matchstring.replace(".", "");
        matchstring = matchstring.replace("?", ".");
        matchstring = matchstring.replace("*", ".+?");
        try {
            pattern = Pattern.compile(matchstring);
        }
        catch (PatternSyntaxException e) {
            return new EverythingItemMatcher();
        }
        if (pattern == null || pattern.toString().equals("")) {
            return new EverythingItemMatcher();
        }
        return new PatternItemMatcher(pattern);
    }

    public static boolean itemMatchesSearch(ItemStack item) {
        return ItemList.getSearchMatcher().matches(item);
    }

    public static boolean isMatching() {
        return matching;
    }

    public static void updateSearch() {
        if (matching) {
            research = true;
        } else {
            new ThreadMatchSearch().start();
        }
    }

    public static void loadItems() {
        if (loading) {
            reload = true;
        } else {
            new ThreadLoadItems().start();
        }
    }

    public static class ThreadLoadItems
    extends Thread
    implements IItemCounter {
        private int itemID = 0;

        public ThreadLoadItems() {
            super("NEI Item Loading Thread");
            loading = true;
        }

        @Override
        public int getItem() {
            return this.itemID;
        }

        @Override
        public Thread getThread() {
            return this;
        }

        @Override
        public void run() {
            new ThreadLoadMonitor(this).start();
            block4: while (loading) {
                try {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    ArrayList sublist = new ArrayList();
                    this.itemID = 0;
                    while (this.itemID < Item.field_77698_e.length) {
                        if (reload) {
                            reload = false;
                            continue block4;
                        }
                        Item item = Item.field_77698_e[this.itemID];
                        if (item != null && !ItemInfo.isHidden(item.field_77779_bT)) {
                            sublist.clear();
                            item.func_77633_a(this.itemID, null, sublist);
                            ArrayList damageranges = ItemInfo.getItemDamageVariants(item.field_77779_bT);
                            if (sublist.size() > 0) {
                                ArrayList<Integer> discreteDamages = new ArrayList<Integer>();
                                for (ItemStack stack : sublist) {
                                    if (stack.func_77942_o()) {
                                        stack = stack.func_77946_l();
                                        items.add(stack);
                                        continue;
                                    }
                                    discreteDamages.add(stack.func_77960_j());
                                }
                                damageranges = damageranges == ItemInfo.defaultDamageRange ? NEIClientUtils.concatIntegersToRanges(discreteDamages) : NEIClientUtils.addIntegersToRanges(damageranges, discreteDamages);
                            }
                            boolean skipDamage0 = false;
                            ArrayList datalist = ItemInfo.getItemCompounds(this.itemID);
                            if (datalist != null && datalist.size() > 0 && NEIClientConfig.isActionPermissable("nbt")) {
                                skipDamage0 = true;
                                for (ItemStack stack : datalist) {
                                    stack = stack.func_77946_l();
                                    items.add(stack);
                                }
                            }
                            HashSet<String> damageIconSet = new HashSet<String>();
                            for (int[] damagerange : damageranges) {
                                for (int damage = damagerange[0]; damage <= damagerange[1]; ++damage) {
                                    ItemStack itemstack = new ItemStack(item, 1, damage);
                                    try {
                                        Icon icon = item.func_77650_f(itemstack);
                                        String name = GuiContainerManager.concatenatedDisplayName(itemstack, false);
                                        String s = name + "@" + (icon == null ? 0 : icon.hashCode());
                                        if (damageIconSet.contains(s)) continue;
                                        damageIconSet.add(s);
                                        if (damage == 0 && skipDamage0) continue;
                                        items.add(itemstack);
                                        continue;
                                    }
                                    catch (Throwable t) {
                                        StringWriter sw = new StringWriter();
                                        t.printStackTrace(new PrintWriter(sw));
                                        String stackTrace = itemstack + sw.toString();
                                        if (stackTraces.contains(stackTrace)) continue;
                                        System.err.println("NEI: Omitting #" + this.itemID + ":" + damage + " " + item.getClass().getSimpleName());
                                        t.printStackTrace();
                                        stackTraces.add(stackTrace);
                                    }
                                }
                            }
                        }
                        ++this.itemID;
                    }
                    this.itemID = -1;
                    DropDownFile dropDownInstance = DropDownFile.dropDownInstance;
                    dropDownInstance.resetHashes();
                    for (ItemStack stack : items) {
                        if (reload) {
                            reload = false;
                            continue block4;
                        }
                        dropDownInstance.addItemIfInRange(stack.field_77993_c, stack.func_77960_j(), stack.field_77990_d);
                    }
                    dropDownInstance.updateState();
                    ItemList.items = items;
                    if (reload) {
                        reload = false;
                        continue;
                    }
                    loading = false;
                }
                catch (TimeoutException e) {
                    System.err.println("Removing itemID: " + e.itemID + " from list.");
                    erroredIDs.add(e.itemID);
                }
            }
            ItemList.updateSearch();
        }
    }

    public static class ThreadMatchSearch
    extends Thread
    implements IItemCounter {
        private int itemID;

        public ThreadMatchSearch() {
            super("NEI Item Searching Thread");
            matching = true;
        }

        @Override
        public int getItem() {
            return this.itemID;
        }

        @Override
        public Thread getThread() {
            return this;
        }

        @Override
        public void run() {
            block2: while (matching) {
                try {
                    ArrayList<ItemPanelStack> visibleitems = new ArrayList<ItemPanelStack>();
                    ItemMatcher matcher = ItemList.getSearchMatcher();
                    for (ItemStack item : items) {
                        this.itemID = item.field_77993_c;
                        if (research) {
                            research = false;
                            continue block2;
                        }
                        if (!item.func_77942_o() ? NEIClientConfig.vishash.isItemHidden(item.field_77993_c, item.func_77960_j()) : NEIClientConfig.vishash.isItemHidden(item.field_77993_c, item.field_77990_d)) continue;
                        if (!NEIClientConfig.canGetItem(new ItemKey(item)) || !matcher.matches(item)) continue;
                        visibleitems.add(new ItemPanelStack(item));
                    }
                    ItemPanel.visibleitems = visibleitems;
                }
                catch (TimeoutException e) {
                    System.err.println("Removing itemID: " + e.itemID + " from list.");
                    e.printStackTrace();
                    erroredIDs.add(e.itemID);
                    ItemList.loadItems();
                }
                matching = false;
            }
        }
    }

    public static class ThreadLoadMonitor
    extends Thread {
        IItemCounter loadingThread;

        public ThreadLoadMonitor(IItemCounter handle) {
            super("NEI Load Monitor");
            this.loadingThread = handle;
        }

        @Override
        public void run() {
            int lastItem = 0;
            long lastTime = System.currentTimeMillis();
            while (this.loadingThread.getThread().isAlive()) {
                if (lastItem != this.loadingThread.getItem()) {
                    lastTime = System.currentTimeMillis();
                    lastItem = this.loadingThread.getItem();
                } else if (System.currentTimeMillis() - lastTime > 2000L && lastItem >= 0) {
                    this.loadingThread.getThread().stop(new TimeoutException("Took to long to advance item", lastItem));
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        public final int itemID;

        public TimeoutException(String msg, int lastItem) {
            super(msg);
            this.itemID = lastItem;
        }
    }

    public static interface IItemCounter {
        public int getItem();

        public Thread getThread();
    }

    private static class NothingItemMatcher
    implements ItemMatcher {
        private NothingItemMatcher() {
        }

        @Override
        public boolean matches(ItemStack item) {
            return false;
        }
    }

    private static class EverythingItemMatcher
    implements ItemMatcher {
        private EverythingItemMatcher() {
        }

        @Override
        public boolean matches(ItemStack item) {
            return true;
        }
    }

    private static class PatternItemMatcher
    implements ItemMatcher {
        Pattern pattern;

        public PatternItemMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(ItemStack item) {
            return this.pattern.matcher(CommonUtils.filterText(GuiContainerManager.concatenatedDisplayName(item, true).toLowerCase())).find();
        }
    }

    private static class SubsetItemMatcher
    implements ItemMatcher {
        final List tags;

        public SubsetItemMatcher(List tags) {
            this.tags = tags;
        }

        @Override
        public boolean matches(ItemStack item) {
            for (SubSetRangeTag tag : this.tags) {
                if (!tag.isItemInRange(item.field_77993_c, item.func_77960_j())) continue;
                return true;
            }
            return false;
        }
    }

    private static interface ItemMatcher {
        public boolean matches(ItemStack var1);
    }
}

