/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.InterActionMap;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends Widget {
    public static ArrayList visibleitems = new ArrayList();
    public ItemStack draggedStack;
    public int mouseDownSlot = -1;
    private int marginLeft;
    private int marginTop;
    private int columns;
    private int rows;
    private int itemsPerPage;
    private int page;
    private int numPages;

    @Override
    public void resize() {
        this.marginLeft = this.x + this.width % 18 / 2;
        this.marginTop = this.y + this.height % 18 / 2;
        this.columns = this.width / 18;
        this.rows = this.height / 18;
        this.itemsPerPage = this.rows * this.columns;
        this.numPages = (int)Math.ceil((float)visibleitems.size() / (float)this.itemsPerPage);
        this.setPage(this.page);
    }

    @Override
    public void draw(GuiContainerManager gui, int mousex, int mousey) {
        if (visibleitems.size() == 0) {
            return;
        }
        int itemIndex = this.page * this.itemsPerPage;
        int lastIndex = this.itemsPerPage * (this.page + 1);
        int colIndex = 0;
        int rowIndex = 0;
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            int relIndex = hoverSlot.slotIndex - itemIndex;
            gui.drawRect(this.marginLeft + relIndex % this.columns * 18 - 1, this.marginTop + relIndex / this.columns * 18 - 1, 18, 18, -296397483);
        }
        while (itemIndex < lastIndex && itemIndex < visibleitems.size()) {
            ItemPanelObject item = (ItemPanelObject)visibleitems.get(itemIndex);
            int posX = this.marginLeft + colIndex * 18;
            int posY = this.marginTop + rowIndex * 18;
            item.draw(gui, posX, posY);
            ++itemIndex;
            if (++colIndex != this.columns) continue;
            colIndex = 0;
            ++rowIndex;
        }
    }

    @Override
    public void postDraw(GuiContainerManager gui, int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            gui.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null) {
            ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            ItemStack stack = new ItemPanelSlot(this.mouseDownSlot).getItemStack();
            if (stack != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
                int amount = NEIClientConfig.getItemQuantity();
                if (amount == 0) {
                    amount = stack.func_77976_d();
                }
                this.draggedStack = NEIServerUtils.copyStack(stack, amount);
            }
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleDraggedClick(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            if (NEIClientConfig.isActionPermissable(InterActionMap.DELETE) && NEIClientConfig.isActionPermissable(InterActionMap.ITEM)) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ItemStack stack = hoverSlot.getItemStack();
                if (stack != null) {
                    int amount = NEIClientConfig.getItemQuantity();
                    if (amount == 0) {
                        amount = stack.func_77976_d();
                    }
                    this.draggedStack = NEIServerUtils.copyStack(stack, amount);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    private boolean handleDraggedClick(int mousex, int mousey, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.handleDragNDrop(gui, mousex, mousey, this.draggedStack, button)) continue;
            handled = true;
            if (this.draggedStack.field_77994_a != 0) continue;
            this.draggedStack = null;
            return true;
        }
        if (handled) {
            return true;
        }
        Slot overSlot = gui.func_74187_b(mousex, mousey);
        if (overSlot != null && overSlot.func_75214_a(this.draggedStack)) {
            if (NEIClientConfig.isActionPermissable(InterActionMap.ITEM)) {
                int total;
                int add;
                int contents = overSlot.func_75216_d() ? overSlot.func_75211_c().field_77994_a : 0;
                int n = add = button == 0 ? this.draggedStack.field_77994_a : 1;
                if (overSlot.func_75216_d() && !NEIServerUtils.areStacksSameType(this.draggedStack, overSlot.func_75211_c())) {
                    contents = 0;
                }
                if ((total = Math.min(contents + add, Math.min(overSlot.func_75219_a(), this.draggedStack.func_77976_d()))) > contents) {
                    NEIClientUtils.setSlotContents(overSlot.field_75222_d, NEIServerUtils.copyStack(this.draggedStack, total), true);
                    NEICPH.sendSpawnItem(NEIServerUtils.copyStack(this.draggedStack, total), false, false);
                    this.draggedStack.field_77994_a -= total - contents;
                }
                if (this.draggedStack.field_77994_a == 0) {
                    this.draggedStack = null;
                }
            } else {
                this.draggedStack = null;
            }
        } else if (mousex < gui.field_74198_m || mousey < gui.field_74197_n || mousex >= gui.field_74198_m + gui.field_74194_b || mousey >= gui.field_74197_n + gui.field_74195_c) {
            this.draggedStack = null;
        }
        return true;
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        return this.handleDraggedClick(mousex, mousey, button);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && hoverSlot.getItemStack() != null && this.draggedStack == null) {
            ItemStack item = hoverSlot.getItemStack();
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.isActionPermissable(InterActionMap.ITEM)) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.draggedStack = null;
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(item, button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.scroll(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("next")) {
            this.scroll(1);
            return true;
        }
        if (keyID == NEIClientConfig.getKeyBinding("prev")) {
            this.scroll(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.getItemStack();
    }

    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        int relX = mousex - this.marginLeft + 1;
        int relY = mousey - this.marginTop + 1;
        if (relX < 0 || relY < 0) {
            return null;
        }
        int row = relY / 18;
        int col = relX / 18;
        int index = this.itemsPerPage * this.page + row * this.columns + col;
        if (index >= 0 && index < visibleitems.size() && index < this.itemsPerPage * (this.page + 1)) {
            return new ItemPanelSlot(index);
        }
        return null;
    }

    @Override
    public List handleTooltip(int mx, int my, List tooltip) {
        if (this.getSlotMouseOver(mx, my) == null) {
            return tooltip;
        }
        return this.getSlotMouseOver((int)mx, (int)my).contents.handleTooltip(tooltip);
    }

    public void scroll(int i) {
        this.setPage(this.page + i);
    }

    public void setPage(int i) {
        this.page = this.numPages == 0 ? 0 : (i + this.numPages) % this.numPages;
    }

    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public static interface ItemPanelObject {
        public void draw(GuiContainerManager var1, int var2, int var3);

        public List handleTooltip(List var1);
    }

    public class ItemPanelSlot {
        public ItemPanelObject contents;
        public int slotIndex;

        public ItemPanelSlot(int index) {
            this.contents = (ItemPanelObject)visibleitems.get(index);
            this.slotIndex = index;
        }

        public ItemStack getItemStack() {
            return this.contents instanceof ItemPanelStack ? ((ItemPanelStack)this.contents).item : null;
        }
    }
}

