/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemVisibilityHash {
    private static boolean[] statesSaved = new boolean[7];
    public TreeMap hiddenitems;

    public ItemVisibilityHash() {
        try {
            this.loadFromCompound(this.getCurrentSaveCompound());
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public NBTTagCompound getCurrentSaveCompound() {
        NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
        NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
        NBTTagCompound currentSave = hashSave.func_74775_l("current");
        hashSave.func_74766_a("current", currentSave);
        return currentSave;
    }

    public void hideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add(-1);
    }

    public void hideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add(damage);
    }

    public void hideItem(int item, NBTTagCompound stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        if (!info.compounds.contains(stackTagCompound)) {
            info.compounds.add(stackTagCompound);
        }
    }

    public void hideItem(ItemKey item) {
        if (item.item.func_77942_o()) {
            this.hideItem(item.item.field_77993_c, item.item.func_77978_p());
        } else {
            this.hideItem(item.item.field_77993_c, item.item.func_77960_j());
        }
    }

    public void unhideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        this.hiddenitems.remove(item);
    }

    public void unhideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        if (damage == -1) {
            this.hiddenitems.remove(item);
        } else {
            info.damages.remove(damage);
        }
    }

    public void unhideItem(int item, NBTTagCompound stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        info.compounds.remove(stackTagCompound);
    }

    public void unhideItem(ItemKey item) {
        if (item.item.func_77942_o()) {
            this.unhideItem(item.item.field_77993_c, item.item.func_77978_p());
        } else {
            this.unhideItem(item.item.field_77993_c, item.item.func_77960_j());
        }
    }

    public boolean isItemHidden(int itemID, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.damages.contains(damage) || info.damages.contains(-1);
    }

    public boolean isItemHidden(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return false;
        }
        return info.damages.contains((short)-1);
    }

    public boolean isItemHidden(int itemID, NBTTagCompound stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.compounds.contains(stackTagCompound);
    }

    public boolean isItemHidden(ItemKey item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item.item.field_77993_c);
        if (info == null) {
            return false;
        }
        if (info.damages.contains(item.item.func_77960_j()) || info.damages.contains(-1)) {
            return true;
        }
        if (item.item.func_77942_o()) {
            return info.compounds.contains(item.item.func_77978_p());
        }
        return false;
    }

    private void loadFromCompound(NBTTagCompound readTag) {
        this.hiddenitems = new TreeMap();
        for (Object obj : readTag.func_74758_c()) {
            int i;
            IDInfo info;
            int itemID;
            if (obj instanceof NBTTagList) {
                NBTTagList compoundlist = (NBTTagList)((Object)obj);
                itemID = Integer.parseInt(compoundlist.func_74740_e().substring(1));
                info = (IDInfo)this.hiddenitems.get(itemID);
                if (info == null) {
                    info = new IDInfo();
                    this.hiddenitems.put(itemID, info);
                }
                for (i = 0; i < compoundlist.func_74745_c(); ++i) {
                    info.compounds.add((NBTTagCompound)compoundlist.func_74743_b(i));
                }
                continue;
            }
            if (!(obj instanceof NBTTagByteArray)) continue;
            NBTTagByteArray damagearray = (NBTTagByteArray)obj;
            itemID = Integer.parseInt(damagearray.func_74740_e().substring(1));
            info = (IDInfo)this.hiddenitems.get(itemID);
            if (info == null) {
                info = new IDInfo();
                this.hiddenitems.put(itemID, info);
            }
            for (i = 0; i < damagearray.field_74754_a.length / 2; ++i) {
                info.damages.add((damagearray.field_74754_a[i * 2] << 8) + damagearray.field_74754_a[i * 2 + 1]);
            }
        }
    }

    public void save() {
        try {
            NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
            NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
            hashSave.func_74766_a("current", this.constructSaveCompound());
            NEIClientConfig.saveConfig();
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    private NBTTagCompound constructSaveCompound() {
        NBTTagCompound savecompound = new NBTTagCompound();
        for (Map.Entry itemEntry : this.hiddenitems.entrySet()) {
            int id = (Integer)itemEntry.getKey();
            IDInfo info = (IDInfo)itemEntry.getValue();
            if (info.compounds.size() > 0) {
                NBTTagList compoundlist = new NBTTagList();
                for (NBTTagCompound compound : info.compounds) {
                    compoundlist.func_74742_a((NBTBase)compound);
                }
                savecompound.func_74782_a("c" + id, (NBTBase)compoundlist);
            }
            if (info.damages.size() <= 0) continue;
            byte[] damagearray = new byte[info.damages.size() * 2];
            int i = 0;
            Iterator i$ = info.damages.iterator();
            while (i$.hasNext()) {
                int damage = (Integer)i$.next();
                damagearray[i * 2] = (byte)(damage >> 8);
                damagearray[i * 2 + 1] = (byte)damage;
                ++i;
            }
            savecompound.func_74773_a("d" + id, damagearray);
        }
        return savecompound;
    }

    public static void loadStates() {
        NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
        NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
        for (int i = 0; i < 7; ++i) {
            NBTTagCompound statesave = hashSave.func_74775_l("save" + i);
            if (statesave.func_74758_c().size() <= 0) continue;
            ItemVisibilityHash.statesSaved[i] = true;
        }
    }

    public void loadState(int i) {
        NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
        NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
        this.loadFromCompound(hashSave.func_74775_l("save" + i));
        DropDownFile.dropDownInstance.updateState();
        ItemList.updateSearch();
        NEIClientConfig.vishash.save();
    }

    public void saveState(int i) {
        NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
        NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
        NBTTagCompound saveCompound = this.getCurrentSaveCompound();
        saveCompound.func_74757_a("saved", true);
        hashSave.func_74766_a("save" + i, saveCompound);
        ItemVisibilityHash.statesSaved[i] = true;
        NEIClientConfig.saveConfig();
    }

    public void clearState(int i) {
        NBTTagCompound hashSave = NEIClientConfig.saveCompound.func_74775_l("vis");
        NEIClientConfig.saveCompound.func_74782_a("vis", (NBTBase)hashSave);
        hashSave.func_74766_a("save" + i, new NBTTagCompound("save" + i));
        ItemVisibilityHash.statesSaved[i] = false;
        NEIClientConfig.saveConfig();
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static class IDInfo {
        public TreeSet damages = new TreeSet();
        public ArrayList compounds = new ArrayList();
    }
}

