/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.Button;
import codechicken.nei.Button2ActiveState;
import codechicken.nei.DropDownWidget;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.GuiNEISettings;
import codechicken.nei.Image;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.Label;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.LayoutStyleTMIOld;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.SaveLoadButton;
import codechicken.nei.SearchField;
import codechicken.nei.TextField;
import codechicken.nei.VisiblityData;
import codechicken.nei.Widget;
import codechicken.nei.WidgetZOrder;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerDrawHandler;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerObjectHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class LayoutManager
implements IContainerInputHandler,
IContainerTooltipHandler,
IContainerDrawHandler,
IContainerObjectHandler {
    private static LayoutManager instance;
    private static Widget inputFocused;
    private static TreeSet drawWidgets;
    private static TreeSet controlWidgets;
    public static ItemPanel itemPanel;
    public static DropDownWidget dropDown;
    public static TextField searchField;
    public static Button options;
    public static Button prev;
    public static Button next;
    public static Label pageLabel;
    public static Button more;
    public static Button less;
    public static ItemQuantityField quantity;
    public static SaveLoadButton[] stateButtons;
    public static Button[] deleteButtons;
    public static Button delete;
    public static Button2ActiveState creative;
    public static Button rain;
    public static Button magnet;
    public static Button[] timeButtons;
    public static final String[] timeZones;
    public static Button heal;
    public static IRecipeOverlayRenderer overlayRenderer;
    public static HashMap layoutStyles;

    public static void load() {
        API.addLayoutStyle(0, new LayoutStyleMinecraft());
        API.addLayoutStyle(1, new LayoutStyleTMIOld());
        instance = new LayoutManager();
        GuiContainerManager.addInputHandler(instance);
        GuiContainerManager.addTooltipHandler(instance);
        GuiContainerManager.addDrawHandler(instance);
        GuiContainerManager.addObjectHandler(instance);
        LayoutManager.init();
    }

    @Override
    public void onPreDraw(GuiContainer gui) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && gui instanceof InventoryEffectRenderer) {
            gui.field_74198_m = (gui.field_73880_f - gui.field_74194_b) / 2;
            gui.field_74197_n = (gui.field_73881_g - gui.field_74195_c) / 2;
            if (gui instanceof GuiContainerCreative && gui.field_73887_h.size() >= 2) {
                GuiButton button1 = (GuiButton)gui.field_73887_h.get(0);
                GuiButton button2 = (GuiButton)gui.field_73887_h.get(1);
                button1.field_73746_c = gui.field_74198_m;
                button2.field_73746_c = gui.field_74198_m + gui.field_74194_b - 20;
            }
        }
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mousex, mousey);
        }
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        if (NEIClientConfig.isHidden()) {
            return false;
        }
        if (!NEIClientConfig.isEnabled()) {
            return options.contains(mousex, mousey) && options.handleClick(mousex, mousey, button);
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mousex, mousey);
            if (!(widget.contains(mousex, mousey) ? widget.handleClick(mousex, mousey, button) : widget.handleClickExt(mousex, mousey, button))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean objectUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isEnabled() || NEIClientConfig.isHidden()) {
            return false;
        }
        for (Widget widget : controlWidgets) {
            if (!widget.contains(mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyID) {
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            if (inputFocused != null) {
                return inputFocused.handleKeyPress(keyID, keyChar);
            }
            for (Widget widget : controlWidgets) {
                if (!widget.handleKeyPress(keyID, keyChar)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        if (keyID == NEIClientConfig.getKeyBinding("hide")) {
            NEIClientConfig.toggleBooleanSetting("options.hidden");
            return true;
        }
        return false;
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mx, int my, int button) {
        try {
            if (!NEIClientConfig.isEnabled() || NEIClientConfig.isHidden()) {
                return;
            }
            for (Widget widget : controlWidgets) {
                widget.mouseUp(mx, my, button);
            }
        }
        catch (Exception exception) {
            NEIClientUtils.reportException(exception);
            NEIClientConfig.setEnabled(false);
        }
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mx, int my, int button, long heldTime) {
        try {
            if (!NEIClientConfig.isEnabled() || NEIClientConfig.isHidden()) {
                return;
            }
            for (Widget widget : controlWidgets) {
                widget.mouseDragged(mx, my, button, heldTime);
            }
        }
        catch (Exception exception) {
            NEIClientUtils.reportException(exception);
            NEIClientConfig.setEnabled(false);
        }
    }

    @Override
    public ItemStack getStackUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isEnabled() || NEIClientConfig.isHidden()) {
            return null;
        }
        for (Widget widget : controlWidgets) {
            ItemStack stack = widget.getStackMouseOver(mousex, mousey);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void renderObjects(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden()) {
            LayoutManager.layout(gui);
            if (NEIClientConfig.isEnabled()) {
                LayoutManager.getLayoutStyle().drawBackground(gui.manager);
                for (Widget widget : drawWidgets) {
                    widget.draw(gui.manager, mousex, mousey);
                }
            } else {
                options.draw(gui.manager, mousex, mousey);
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
    }

    @Override
    public void postRenderObjects(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : drawWidgets) {
                widget.postDraw(gui.manager, mousex, mousey);
            }
        }
    }

    @Override
    public List handleTooltipFirst(GuiContainer gui, int mousex, int mousey, List currenttip) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && gui.manager.shouldShowTooltip()) {
            for (Widget widget : controlWidgets) {
                currenttip = widget.handleTooltip(mousex, mousey, currenttip);
            }
        }
        return currenttip;
    }

    @Override
    public List handleItemTooltip(GuiContainer gui, ItemStack itemstack, List currenttip) {
        String overridename = ItemInfo.getOverrideName(itemstack.field_77993_c, itemstack.func_77960_j());
        if (overridename != null) {
            currenttip.set(0, overridename);
        }
        String mainname = (String)currenttip.get(0);
        if (NEIClientConfig.showIDs()) {
            mainname = mainname + " " + itemstack.field_77993_c;
            if (itemstack.func_77960_j() != 0) {
                mainname = mainname + ":" + itemstack.func_77960_j();
            }
            currenttip.set(0, mainname);
        }
        return currenttip;
    }

    public static void layout(GuiContainer gui) {
        VisiblityData visiblity = new VisiblityData();
        if (NEIClientConfig.isHidden()) {
            visiblity.showNEI = false;
        }
        if (gui.field_73881_g - gui.field_74195_c <= 40) {
            visiblity.showSearchSection = false;
        }
        if (gui.field_74198_m - 4 < 76) {
            visiblity.showWidgets = false;
        }
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            handler.modifyVisiblity(gui, visiblity);
        }
        visiblity.translateDependancies();
        LayoutManager.getLayoutStyle().layout(gui, visiblity);
        LayoutManager.updateWidgetVisiblities(gui, visiblity);
    }

    private static void init() {
        int i;
        itemPanel = new ItemPanel();
        dropDown = new DropDownWidget();
        searchField = new SearchField("search");
        options = new Button("Options"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.overlayScreen(new GuiNEISettings(NEIClientUtils.getGuiContainer()));
                    return true;
                }
                return false;
            }
        };
        prev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    itemPanel.scroll(-1);
                    return true;
                }
                return false;
            }
        };
        next = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    itemPanel.scroll(1);
                    return true;
                }
                return false;
            }
        };
        pageLabel = new Label("(0/0)", true);
        more = new Button("+"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? 64 : (NEIClientUtils.shiftKey() ? 10 : 1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                NEIClientUtils.setItemQuantity(quantity);
                return true;
            }
        };
        less = new Button("-"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? -64 : (NEIClientUtils.shiftKey() ? -10 : -1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                NEIClientUtils.setItemQuantity(quantity);
                return true;
            }
        };
        quantity = new ItemQuantityField("quantity");
        stateButtons = new SaveLoadButton[7];
        deleteButtons = new Button[7];
        for (i = 0; i < 7; ++i) {
            final int savestate = i;
            LayoutManager.stateButtons[i] = new SaveLoadButton(""){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (NEIClientConfig.isStateSaved(savestate)) {
                        NEIClientConfig.loadState(savestate);
                    } else {
                        NEIClientConfig.saveState(savestate);
                    }
                    return true;
                }

                @Override
                public void onTextChange() {
                    NBTTagCompound statelist = NEIClientConfig.saveCompound.func_74775_l("statename");
                    NEIClientConfig.saveCompound.func_74782_a("statename", (NBTBase)statelist);
                    statelist.func_74778_a("" + savestate, this.label.substring(5));
                    NEIClientConfig.saveConfig();
                }
            };
            LayoutManager.deleteButtons[i] = new Button("x"){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (!rightclick) {
                        NEIClientConfig.clearState(savestate);
                        return true;
                    }
                    return false;
                }
            };
        }
        delete = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if ((this.state & 3) == 2) {
                    return false;
                }
                ItemStack held = NEIClientUtils.getHeldItem();
                if (held != null) {
                    if (NEIClientUtils.shiftKey()) {
                        NEIClientUtils.deleteHeldItem();
                        NEIClientUtils.deleteItemsOfType(held);
                    } else if (rightclick) {
                        NEIClientUtils.decreaseSlotStack(-999);
                    } else {
                        NEIClientUtils.deleteHeldItem();
                    }
                } else if (NEIClientUtils.shiftKey()) {
                    NEIClientUtils.deleteEverything();
                } else {
                    NEIController.deleteMode = !NEIController.deleteMode;
                }
                return true;
            }

            @Override
            public String getButtonTip() {
                if ((this.state & 3) == 2) {
                    return null;
                }
                ItemStack itemstack = NEIClientUtils.getHeldItem();
                if (itemstack == null) {
                    if (NEIClientUtils.shiftKey()) {
                        return "DELETE ALL ITEMS from current inventory screen";
                    }
                    return LayoutManager.getStateTip("Delete Mode", this.state);
                }
                if (NEIClientUtils.shiftKey()) {
                    return "DELETE ALL " + GuiContainerManager.itemDisplayNameShort(itemstack);
                }
                return "DELETE " + GuiContainerManager.itemDisplayNameShort(itemstack);
            }
        };
        creative = new Button2ActiveState(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.cycleCreativeMode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("Creative Mode", this.state);
            }
        };
        rain = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (LayoutManager.handleDisabledButtonPress("rain", rightclick)) {
                    return true;
                }
                if (!rightclick) {
                    NEIClientUtils.toggleRaining();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("Rain", this.state);
            }
        };
        magnet = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.toggleMagnetMode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("Magnet Mode", this.state);
            }
        };
        for (i = 0; i < 4; ++i) {
            final int zone = i;
            LayoutManager.timeButtons[i] = new Button(){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (LayoutManager.handleDisabledButtonPress(timeZones[zone], rightclick)) {
                        return true;
                    }
                    if (!rightclick) {
                        NEIClientUtils.setHourForward(zone * 6);
                        return true;
                    }
                    return false;
                }

                @Override
                public String getButtonTip() {
                    return LayoutManager.getTimeTip(timeZones[zone], timeZones[(zone + 1) % 4], this.state);
                }
            };
        }
        heal = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.healPlayer();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return "Heal the player";
            }
        };
        LayoutManager.delete.state |= 4;
        LayoutManager.creative.state |= 4;
        LayoutManager.rain.state |= 4;
        LayoutManager.magnet.state |= 4;
    }

    private static String getStateTip(String name, int state) {
        if ((state & 3) == 2) {
            return "Enable " + name;
        }
        return "Turn " + name + ((state & 3) == 1 ? " OFF" : " ON");
    }

    private static String getTimeTip(String zone, String next, int state) {
        return (state & 3) == 2 ? "Enable " + zone + "-" + next : "Set time to " + zone;
    }

    private static boolean handleDisabledButtonPress(String ident, boolean rightclick) {
        if (!AllowedPropertyMap.nameSet.contains(ident)) {
            return false;
        }
        if (rightclick && !NEIClientConfig.isPropertyDisabled(ident)) {
            return LayoutManager.setPropertyDisabled(ident, true);
        }
        if (!rightclick && NEIClientConfig.isPropertyDisabled(ident)) {
            return LayoutManager.setPropertyDisabled(ident, false);
        }
        return false;
    }

    private static boolean setPropertyDisabled(String ident, boolean disable) {
        if (disable && (Integer)AllowedPropertyMap.nameToIDMap.get(ident) < 4) {
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                if (!NEIClientConfig.isPropertyDisabled((String)AllowedPropertyMap.idToNameMap.get(i))) continue;
                ++count;
            }
            if (count == 3) {
                return false;
            }
        }
        NEIClientConfig.setPropertyDisabled(ident, disable);
        return true;
    }

    @Override
    public void load(GuiContainer gui) {
        if (NEIClientConfig.isEnabled()) {
            LayoutManager.setInputFocused(null);
            ItemList.loadItems();
            overlayRenderer = null;
            LayoutManager.getLayoutStyle().init();
            LayoutManager.layout(gui);
        }
        NEIController.load(gui);
        if (this.checkCreativeInv(gui)) {
            if (gui.field_73882_e.field_71462_r instanceof GuiContainerCreative) {
                gui.field_73882_e.func_71373_a(null);
            }
            return;
        }
    }

    @Override
    public void refresh(GuiContainer gui) {
    }

    public boolean checkCreativeInv(GuiContainer gui) {
        if (gui instanceof GuiContainerCreative && NEIClientConfig.invCreativeMode()) {
            NEICPH.sendCreativeInv(true);
            return true;
        }
        if (gui instanceof GuiExtendedCreativeInv && !NEIClientConfig.invCreativeMode()) {
            NEICPH.sendCreativeInv(false);
            return true;
        }
        return false;
    }

    public static void updateWidgetVisiblities(GuiContainer gui, VisiblityData visiblity) {
        int i;
        drawWidgets = new TreeSet(new WidgetZOrder(false));
        controlWidgets = new TreeSet(new WidgetZOrder(true));
        if (!visiblity.showNEI) {
            return;
        }
        LayoutManager.addWidget(options);
        if (visiblity.showItemPanel) {
            LayoutManager.addWidget(itemPanel);
            LayoutManager.addWidget(prev);
            LayoutManager.addWidget(next);
            LayoutManager.addWidget(pageLabel);
            if (NEIClientConfig.isActionPermissable(InterActionMap.ITEM)) {
                LayoutManager.addWidget(more);
                LayoutManager.addWidget(less);
                LayoutManager.addWidget(quantity);
            }
        }
        if (visiblity.showSearchSection) {
            LayoutManager.addWidget(dropDown);
            LayoutManager.addWidget(searchField);
        }
        if (NEIClientConfig.isActionPermissable(InterActionMap.ITEM) && visiblity.showStateButtons) {
            for (i = 0; i < 7; ++i) {
                LayoutManager.addWidget(stateButtons[i]);
                if (!NEIClientConfig.isStateSaved(i)) continue;
                LayoutManager.addWidget(deleteButtons[i]);
            }
        }
        if (visiblity.showUtilityButtons) {
            if (NEIClientConfig.isActionPermissable(InterActionMap.TIME)) {
                for (i = 0; i < 4; ++i) {
                    LayoutManager.addWidget(timeButtons[i]);
                }
            }
            if (NEIClientConfig.isActionPermissable(InterActionMap.RAIN)) {
                LayoutManager.addWidget(rain);
            }
            if (NEIClientConfig.isActionPermissable(InterActionMap.HEAL)) {
                LayoutManager.addWidget(heal);
            }
            if (NEIClientConfig.isActionPermissable(InterActionMap.MAGNET)) {
                LayoutManager.addWidget(magnet);
            }
            if (NEIClientConfig.isActionPermissable(InterActionMap.CREATIVE)) {
                LayoutManager.addWidget(creative);
            }
            if (NEIClientConfig.isActionPermissable(InterActionMap.DELETE)) {
                LayoutManager.addWidget(delete);
            }
        }
    }

    public static LayoutStyle getLayoutStyle() {
        LayoutStyle style = (LayoutStyle)layoutStyles.get(NEIClientConfig.getLayoutStyle());
        if (style == null) {
            style = (LayoutStyle)layoutStyles.get(0);
        }
        return style;
    }

    private static void addWidget(Widget widget) {
        drawWidgets.add(widget);
        controlWidgets.add(widget);
    }

    @Override
    public void guiTick(GuiContainer gui) {
        if (this.checkCreativeInv(gui)) {
            return;
        }
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        for (Widget widget : controlWidgets) {
            widget.update(gui.manager);
        }
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        if (NEIClientConfig.isHidden() || !NEIClientConfig.isEnabled()) {
            return false;
        }
        for (Widget widget : controlWidgets) {
            if (!widget.onMouseWheel(scrolled, mousex, mousey)) continue;
            return true;
        }
        return NEIController.mouseScrolled(scrolled);
    }

    @Override
    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    @Override
    public boolean shouldShowTooltip(GuiContainer gui) {
        return LayoutManager.itemPanel.draggedStack == null;
    }

    public static Widget getInputFocused() {
        return inputFocused;
    }

    public static void setInputFocused(Widget widget) {
        if (inputFocused != null) {
            inputFocused.loseFocus();
        }
        if ((inputFocused = widget) != null) {
            inputFocused.gainFocus();
        }
    }

    @Override
    public void renderSlotUnderlay(GuiContainer gui, Slot slot) {
        if (overlayRenderer != null) {
            overlayRenderer.renderOverlay(gui.manager, slot);
        }
    }

    @Override
    public void renderSlotOverlay(GuiContainer window, Slot slot) {
        ItemStack item = slot.func_75211_c();
        if (NEIClientConfig.getBooleanSetting("options.searchinventories") && (item == null ? !NEIClientConfig.getSearchExpression().equals("") : !ItemList.itemMatchesSearch(item))) {
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
            window.manager.drawRect(slot.field_75223_e, slot.field_75221_f, 16, 16, Integer.MIN_VALUE);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-150.0f);
            GL11.glEnable((int)2896);
        }
    }

    public static void drawIcon(GuiContainer window, int x, int y, Image image) {
        window.manager.bindTexture("/codechicken/nei/nei_sprites.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        window.func_73729_b(x, y, image.x, image.y, image.width, image.height);
        GL11.glDisable((int)3042);
    }

    public static void drawButtonBackground(GuiContainerManager manager, int x, int y, int w, int h, boolean edges, int type) {
        int wtiles = 0;
        int ew = w;
        if (w / 2 > 100) {
            wtiles = (w - 200) / 50 + 1;
            ew = 200;
        }
        int w1 = ew / 2;
        int h1 = h / 2;
        int w2 = (ew + 1) / 2;
        int h2 = (h + 1) / 2;
        int x2 = x + w - w2;
        int y2 = y + h - h2;
        int ty = 46 + type * 20;
        int te = edges ? 0 : 1;
        int ty1 = ty + te;
        int tx1 = te;
        int tx3 = 75;
        int ty2 = ty + 20 - h2 - te;
        int tx2 = 200 - w2 - te;
        manager.bindTexture("/gui/gui.png");
        manager.drawTexturedModalRect(x, y, tx1, ty1, w1, h1);
        manager.drawTexturedModalRect(x, y2, tx1, ty2, w1, h2);
        for (int tile = 0; tile < wtiles; ++tile) {
            int tilex = x + w1 + 50 * tile;
            manager.drawTexturedModalRect(tilex, y, tx3, ty1, 50, h1);
            manager.drawTexturedModalRect(tilex, y2, tx3, ty2, 50, h2);
        }
        manager.drawTexturedModalRect(x2, y, tx2, ty1, w2, h1);
        manager.drawTexturedModalRect(x2, y2, tx2, ty2, w2, h2);
    }

    public static LayoutManager instance() {
        return instance;
    }

    static {
        timeButtons = new Button[4];
        timeZones = new String[]{"dawn", "noon", "dusk", "midnight"};
        layoutStyles = new HashMap();
    }
}

