/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ReflectionManager;
import codechicken.nei.ItemRange;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.NEIClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiItemRange {
    public ArrayList ranges = new ArrayList();
    public byte state;
    protected int lastslotclicked = -1;
    protected long lastslotclicktime;

    public boolean isItemInRange(int itemid, int damage) {
        for (ItemRange range : this.ranges) {
            if (!range.isItemInRange(itemid, damage)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder rangestring = new StringBuilder();
        boolean addcomma = false;
        for (ItemRange range : this.ranges) {
            if (addcomma) {
                rangestring.append(',');
            } else {
                addcomma = true;
            }
            rangestring.append(range.toString());
        }
        return rangestring.toString();
    }

    public MultiItemRange(String rangestring) {
        String[] separatedpairs;
        for (String pairstring : separatedpairs = rangestring.split(",")) {
            this.ranges.add(new ItemRange(pairstring));
        }
    }

    public MultiItemRange() {
    }

    public MultiItemRange add(ItemRange range) {
        this.ranges.add(range);
        return this;
    }

    public MultiItemRange add(Collection ranges) {
        for (Object o : ranges) {
            try {
                ReflectionManager.callMethod(this.getClass(), (Object)this, "add", o);
            }
            catch (Exception e) {
                NEIClientUtils.reportException(e);
            }
        }
        return this;
    }

    public MultiItemRange add(MultiItemRange range) {
        return this.add(range.ranges);
    }

    public MultiItemRange add(int itemID) {
        return this.add(new ItemRange(itemID));
    }

    public MultiItemRange add(int itemID, int damageStart, int damageEnd) {
        return this.add(new ItemRange(itemID, damageStart, damageEnd));
    }

    public MultiItemRange add(int itemIDFirst, int itemIDLast) {
        return this.add(new ItemRange(itemIDFirst, itemIDLast));
    }

    public MultiItemRange add(Item item, int damageStart, int damageEnd) {
        return this.add(item.field_77779_bT, damageStart, damageEnd);
    }

    public MultiItemRange add(Block block, int damageStart, int damageEnd) {
        return this.add(block.field_71990_ca, damageStart, damageEnd);
    }

    public MultiItemRange add(Item item) {
        return this.add(item.field_77779_bT);
    }

    public MultiItemRange add(Block block) {
        return this.add(block.field_71990_ca);
    }

    public MultiItemRange add(ItemStack item) {
        if (item.func_77973_b().func_77645_m()) {
            return this.add(item.field_77993_c);
        }
        return this.add(item.field_77993_c, item.func_77960_j(), item.func_77960_j());
    }

    public int getNumSlots() {
        int slots = 0;
        for (ItemRange range : this.ranges) {
            slots += range.encompasseditems.size();
        }
        return slots;
    }

    public void slotClicked(int slot, int button, boolean doubleclick) {
        int i = 0;
        for (ItemRange range : this.ranges) {
            if (i + range.encompasseditems.size() <= slot) {
                i += range.encompasseditems.size();
                continue;
            }
            for (int item = 0; item < range.encompasseditems.size(); ++item) {
                if (slot == i) {
                    range.onClick(item, button, doubleclick);
                    return;
                }
                ++i;
            }
        }
    }

    public void hideAllItems() {
        for (ItemRange range : this.ranges) {
            range.hideAllItems();
        }
    }

    public void showAllItems() {
        for (ItemRange range : this.ranges) {
            range.showAllItems();
        }
    }

    public int getWidth() {
        return 18;
    }

    public void resetHashes() {
        for (ItemRange range : this.ranges) {
            range.resetHashes();
        }
    }

    public void updateState(ItemVisibilityHash vis) {
        boolean allshown = false;
        boolean allhidden = false;
        for (ItemRange range : this.ranges) {
            if (range.encompasseditems.size() == 0) continue;
            range.updateState(vis);
            byte rstate = range.state;
            if (rstate == 1) {
                this.state = 1;
                return;
            }
            if (rstate == 0) {
                if (allshown) {
                    this.state = 1;
                    return;
                }
                allhidden = true;
                continue;
            }
            if (allhidden) {
                this.state = 1;
                return;
            }
            allshown = true;
        }
        this.state = allshown ? (byte)2 : (byte)0;
    }

    public void addItemIfInRange(int item, int damage, NBTTagCompound compound) {
        ItemRange range;
        Iterator i$ = this.ranges.iterator();
        while (i$.hasNext() && !(range = (ItemRange)i$.next()).addItemIfInRange(item, damage, compound)) {
        }
    }
}

