/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.core.inventory.ItemKey;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ClientHandler;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.GuiPotionCreator;
import codechicken.nei.InterActionMap;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.forge.GuiContainerManager;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class NEICPH
implements PacketCustom.IClientPacketHandler {
    public static final String channel = "NEI";

    @Override
    public void handlePacket(PacketCustom packet, NetClientHandler nethandler, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                this.handleSMPCheck(packet.readUnsignedByte(), packet.readString(), (World)mc.field_71441_e);
                break;
            }
            case 6: {
                NEIClientConfig.setMagnetMode(packet.readBoolean());
                break;
            }
            case 7: {
                NEIClientConfig.setCreativeMode(packet.readUnsignedByte());
                break;
            }
            case 10: {
                this.handlePermissableActions(packet);
                break;
            }
            case 11: {
                this.handleBannedBlocks(packet);
                break;
            }
            case 12: {
                this.handleDisabledProperties(packet);
                break;
            }
            case 13: {
                ClientHandler.instance().addSMPMagneticItem(packet.readInt(), (World)mc.field_71441_e);
                break;
            }
            case 21: {
                ClientUtils.openSMPGui(packet.readUnsignedByte(), new GuiEnchantmentModifier(mc.field_71439_g.field_71071_by, (World)mc.field_71441_e, 0, 0, 0));
                break;
            }
            case 23: {
                if (packet.readBoolean()) {
                    ClientUtils.openSMPGui(packet.readUnsignedByte(), new GuiExtendedCreativeInv(new ContainerCreativeInv((EntityPlayer)mc.field_71439_g, new ExtendedCreativeInv(null, Side.CLIENT))));
                    break;
                }
                mc.func_71373_a((GuiScreen)new GuiInventory((EntityPlayer)mc.field_71439_g));
                break;
            }
            case 24: {
                ClientUtils.openSMPGui(packet.readUnsignedByte(), new GuiPotionCreator(mc.field_71439_g.field_71071_by));
            }
        }
    }

    private void handleDisabledProperties(PacketCustom packet) {
        NEIClientConfig.resetDisabledProperties();
        int num = packet.readUnsignedByte();
        for (int i = 0; i < num; ++i) {
            NEIClientConfig.setPropertyDisabled(packet.readUnsignedByte());
        }
    }

    private void handleBannedBlocks(PacketCustom packet) {
        int num = packet.readInt();
        ArrayList<ItemKey> items = new ArrayList<ItemKey>(num);
        for (int i = 0; i < num; ++i) {
            items.add(new ItemKey(packet.readUnsignedShort(), packet.readUnsignedShort()));
        }
        NEIClientConfig.setBannedBlocks(items);
        if (NEIClientUtils.getGuiContainer() != null) {
            LayoutManager.instance().refresh(NEIClientUtils.getGuiContainer());
        }
    }

    private void handlePermissableActions(PacketCustom packet) {
        NEIClientConfig.resetPermissableActions();
        int num = packet.readUnsignedByte();
        for (int i = 0; i < num; ++i) {
            NEIClientConfig.addPermissableAction(InterActionMap.values()[packet.readUnsignedByte()]);
        }
    }

    private void handleSMPCheck(int serverprotocol, String worldName, World world) {
        if (serverprotocol > 5) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Client");
        } else if (serverprotocol < 5) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Server");
        } else {
            try {
                String prefx;
                if (ClientUtils.isLocal()) {
                    prefx = "local";
                    worldName = ClientUtils.getWorldSaveName(worldName);
                } else {
                    prefx = "remote/" + ClientUtils.getServerIP().replace(':', '~');
                }
                NEIClientConfig.loadWorld(prefx + '/' + worldName);
                NEIClientConfig.setHasSMPCounterPart(true);
                NEICPH.sendRequestLoginInfo();
            }
            catch (Exception nce) {
                nce.printStackTrace();
            }
        }
    }

    public static void sendSpawnItem(ItemStack spawnstack, boolean infinite, boolean doSpawn) {
        PacketCustom packet = new PacketCustom(channel, 1);
        packet.writeBoolean(infinite);
        packet.writeBoolean(doSpawn);
        List name = GuiContainerManager.itemDisplayNameMultiline(spawnstack, null, false);
        packet.writeByte(name.size());
        for (String s : name) {
            packet.writeString(s);
        }
        packet.writeItemStack(spawnstack);
        packet.writeInt(spawnstack.field_77994_a);
        packet.sendToServer();
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom(channel, 4);
        packet.sendToServer();
    }

    public static void sendStateLoad(ItemStack[] state) {
        NEICPH.sendDeleteAllItems();
        for (int slot = 0; slot < state.length; ++slot) {
            ItemStack item = state[slot];
            if (item == null) continue;
            NEICPH.sendSetSlot(slot, item, false);
        }
        PacketCustom packet = new PacketCustom(channel, 11);
        packet.sendToServer();
    }

    public static void sendSetSlot(int slot, ItemStack stack, boolean container) {
        PacketCustom packet = new PacketCustom(channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        packet.sendToServer();
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom(channel, 10);
        packet.sendToServer();
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom(channel, 6);
        packet.sendToServer();
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom(channel, 7);
        packet.writeByte(hour);
        packet.sendToServer();
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom(channel, 8);
        packet.sendToServer();
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom(channel, 9);
        packet.sendToServer();
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom(channel, 21);
        packet.sendToServer();
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom(channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        packet.sendToServer();
    }

    public static void sendSetPropertyDisabled(String name, boolean enable) {
        PacketCustom packet = new PacketCustom(channel, 12);
        packet.writeByte((Integer)AllowedPropertyMap.nameToIDMap.get(name));
        packet.writeBoolean(enable);
        packet.sendToServer();
    }

    public static void sendCycleCreativeMode() {
        PacketCustom packet = new PacketCustom(channel, 13);
        packet.sendToServer();
    }

    public static void sendCreativeInv(boolean open) {
        PacketCustom packet = new PacketCustom(channel, 23);
        packet.writeBoolean(open);
        packet.sendToServer();
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom(channel, 14);
        packet.writeInt(steps);
        packet.sendToServer();
    }

    public static void sendMobSpawnerID(int x, int y, int z, String mobtype) {
        PacketCustom packet = new PacketCustom(channel, 15);
        packet.writeCoord(x, y, z);
        packet.writeString(mobtype);
        packet.sendToServer();
    }

    public static PacketCustom createContainerPacket() {
        return new PacketCustom(channel, 20);
    }

    public static void sendOpenPotionWindow() {
        ItemStack[] potionStore = new ItemStack[9];
        InventoryUtils.readItemStacksFromTag(potionStore, NEIClientConfig.saveCompound.func_74775_l("potionStore").func_74761_m("items"));
        PacketCustom packet = new PacketCustom(channel, 24);
        for (int i = 0; i < potionStore.length; ++i) {
            packet.writeItemStack(potionStore[i]);
        }
        packet.sendToServer();
    }

    public static void sendDummySlotSet(int slotNumber, ItemStack stack) {
        PacketCustom packet = new PacketCustom(channel, 25);
        packet.writeShort(slotNumber);
        packet.writeItemStack(stack, true);
        packet.sendToServer();
    }
}

