/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClassDiscoverer;
import codechicken.core.ClientUtils;
import codechicken.core.CommonUtils;
import codechicken.core.IStringMatcher;
import codechicken.core.config.ConfigFile;
import codechicken.core.config.ConfigTag;
import codechicken.core.inventory.ItemKey;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ClientHandler;
import codechicken.nei.GuiNEIBlockIDs;
import codechicken.nei.GuiNEISettings;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEICompatibility;
import codechicken.nei.NEIController;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.asm.NEIModContainer;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.weakDependancy_Forge;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;

public class NEIClientConfig {
    public static ItemVisibilityHash vishash;
    private static boolean[] statesSaved;
    private static boolean configLoaded;
    private static boolean internalEnabled;
    private static boolean SMPMagnetMode;
    private static boolean SMPCreativeInv;
    private static boolean hasSMPCounterpart;
    private static HashSet permissableActions;
    private static HashSet bannedBlocks;
    private static HashSet disabledProperties;
    public static NBTTagCompound saveCompound;
    public static File saveFile;
    public static ConfigFile globalConfig;
    public static NBTTagCompound localCompound;
    public static File localSave;
    public static ConfigFile worldConfig;
    public static ItemStack[] creativeInv;
    public static boolean global;

    private static void setDefaults() {
        globalConfig.setComment("Main configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        globalConfig.getTag("KeyBinding").useBraces();
        globalConfig.getTag("options").useBraces();
        globalConfig.getTag("command").useBraces().setComment("Change these options if you have a different mod installed on the server that handles the commands differently, Eg. Bukkit Essentials");
        globalConfig.setNewLineMode(1);
        globalConfig.getTag("options.enable").setPosition(0).getBooleanValue(true);
        API.addSetting(new GuiNEISettings.NEIOption("options.enable"){

            @Override
            public String updateText() {
                return "NEI " + (this.enabled() ? "Enabled" : "Disabled");
            }
        });
        globalConfig.getTag("options.hidden").setPosition(2).getBooleanValue(false);
        globalConfig.getTag("options.cheatmode").setPosition(3).setNewLine(true).getIntValue(2);
        API.addSetting(new GuiNEISettings.NEIOption("options.cheatmode"){

            @Override
            public String updateText() {
                return (new String[]{"Recipe", "Utility", "Cheat"})[this.intValue()] + " Mode";
            }

            @Override
            public void onClick() {
                NEIClientConfig.cycleCheatMode();
            }
        });
        globalConfig.getTag("options.lockmode").setPosition(4).setComment("For those who can't help themselves:Set this to a mode and you will be unable to change it ingame").getIntValue(-1);
        globalConfig.getTag("options.utility actions").setPosition(5).setDefaultValue("delete, magnet");
        StringBuilder actionlist = new StringBuilder();
        InterActionMap[] actions = InterActionMap.values();
        for (int i = 0; i < actions.length; ++i) {
            if (i != 0) {
                actionlist.append(", ");
            }
            actionlist.append(actions[i].getName());
        }
        globalConfig.getTag("options.utility actions").setComment("list the actions that are considered 'utilities' rather than cheats:Choose from " + actionlist.toString());
        globalConfig.getTag("options.layout style").setPosition(6).setNewLine(true).getIntValue(0);
        API.addSetting(new GuiNEISettings.NEIOption("options.layout style"){

            @Override
            public String updateText() {
                return LayoutManager.getLayoutStyle().getName();
            }

            @Override
            public void onClick() {
                NEIClientConfig.cycleLayoutStyle();
            }
        });
        globalConfig.getTag("options.edge-align buttons").setPosition(7).getBooleanValue(false);
        globalConfig.getTag("options.show ids").setPosition(8).setNewLine(true).getIntValue(1);
        API.addSetting(new GuiNEISettings.NEIOption("options.show ids"){

            @Override
            public String updateText() {
                return "ItemID's: " + (new String[]{"Hidden", "Auto", "Shown"})[this.intValue()];
            }

            @Override
            public void onClick() {
                NEIClientConfig.cycleIDVisibility();
            }
        });
        globalConfig.getTag("options.searchinventories").setPosition(10).getBooleanValue(false);
        globalConfig.getTag("options.inworld tooltips").setPosition(11).getBooleanValue(false);
        API.addSetting(new GuiNEISettings.NEIOption("options.inworld tooltips"){

            @Override
            public String updateText() {
                return "Highlight tips " + (this.enabled() ? "shown" : "hidden");
            }
        });
        globalConfig.getTag("command.creative").setComment("{0} = 1 for creative, 0 for survival, {1} = player").setDefaultValue("/gamemode {0} {1}");
        globalConfig.getTag("command.give").setNewLine(true).setComment("{0} = player, {1} = itemID, {2} = quantity, {3} = itemDamage").setDefaultValue("/give {0} {1} {2} {3}");
        globalConfig.getTag("command.time").setNewLine(true).setComment("{0} = worldtime").setDefaultValue("/time set {0}");
        globalConfig.getTag("command.rain").setNewLine(true).setComment("{0} = 1 for on, 0 for off").setDefaultValue("/toggledownfall");
        globalConfig.getTag("command.heal").setNewLine(true).setComment("The vanilla server doesn't have a heal command, however others may:{0} = player").setDefaultValue("null");
        NEIClientConfig.checkCheatMode();
        NEIClientConfig.addBlockIDSettings();
        NEIClientConfig.setDefaultKeyBindings();
        globalConfig.saveConfig();
    }

    private static void addBlockIDSettings() {
        API.addSetting(new GuiNEISettings.NEIOption(""){

            @Override
            public String updateText() {
                return "Block/Item ID Settings";
            }

            @Override
            public void onClick() {
                NEIClientUtils.mc().func_71373_a(new GuiNEIBlockIDs(((GuiNEISettings)NEIClientUtils.mc().field_71462_r).parentScreen));
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump").useBraces().setComment("Block/Item ID settings, configured via the options menu ingame.");
        globalConfig.getTag("ID dump.show empty blockIDs").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.show empty blockIDs"){

            @Override
            public String updateText() {
                return (this.enabled() ? "Show" : "Hide") + " Unused BlockIDs";
            }
        });
        globalConfig.getTag("ID dump.dump on load").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.dump on load"){

            @Override
            public String updateText() {
                return (this.enabled() ? "Dump ID Map" : "Do Nothing") + " on Load";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.blockIDs").getBooleanValue(true);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.blockIDs"){

            @Override
            public String updateText() {
                return (this.enabled() ? "Dump" : "Ignore") + " BlockIDs";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.itemIDs").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.itemIDs"){

            @Override
            public String updateText() {
                return (this.enabled() ? "Dump" : "Ignore") + " ItemIDs";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.unused blockIDs").getBooleanValue(true);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.unused blockIDs"){

            @Override
            public String updateText() {
                return (this.enabled() ? "Dump" : "Ignore") + " Unused BlockIDs";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.unused itemIDs").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.unused itemIDs"){

            @Override
            public String updateText() {
                return (this.enabled() ? "Dump" : "Ignore") + " Unused ItemIDs";
            }
        }.setGlobalOnly());
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption(""){

            @Override
            public String updateText() {
                return NEIClientConfig.canDump() ? "Dump ID Map Now" : "Nothing To Dump";
            }

            @Override
            public void onClick() {
                if (NEIClientConfig.canDump()) {
                    NEIClientUtils.dumpIDs();
                }
            }
        }.setGlobalOnly());
        if (!NEIClientConfig.canDump()) {
            globalConfig.getTag("ID dump.dump on load").setBooleanValue(false);
        }
    }

    public static boolean canDump() {
        return NEIClientConfig.getBooleanSetting("ID dump.itemIDs") || NEIClientConfig.getBooleanSetting("ID dump.blockIDs") || NEIClientConfig.getBooleanSetting("ID dump.unused itemIDs") || NEIClientConfig.getBooleanSetting("ID dump.unused blockIDs");
    }

    private static void setDefaultKeyBindings() {
        API.addKeyBind("recipe", "Recipe", 19);
        API.addKeyBind("usage", "Usage", 22);
        API.addKeyBind("back", "Previous Recipe", 14);
        API.addKeyBind("enchant", "Enchantment", 45);
        API.addKeyBind("potion", "Potion", 25);
        API.addKeyBind("prev", "Prev Page", 201);
        API.addKeyBind("next", "Next Page", 209);
        API.addKeyBind("hide", "Hide\\Show", 24);
        API.addKeyBind("chunkoverlay", "Chunk Overlay", 67);
        API.addKeyBind("moboverlay", "Mob Spawn Overlay", 65);
    }

    public static void loadWorld(String saveName) {
        ClientHandler.instance().setWorld(ClientUtils.getWorld());
        NEIClientConfig.setInternalEnabled(true);
        System.out.println("Loading World: " + saveName);
        NEIClientConfig.loadConfig(ClientUtils.getWorld());
        File saveDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + saveName);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        worldConfig = new ConfigFile(new File(saveDir, "NEI.cfg"));
        localSave = new File(saveDir, "NEI.dat");
        try {
            if (!localSave.exists()) {
                localSave.createNewFile();
            }
            if (localSave.length() == 0L) {
                localCompound = new NBTTagCompound();
            } else {
                DataInputStream din = new DataInputStream(new FileInputStream(localSave));
                localCompound = (NBTTagCompound)NBTBase.func_74739_b((DataInput)din);
                din.close();
            }
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
        worldConfig.setComment("World based configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        worldConfig.getTag("options").useBraces();
        worldConfig.getTag("options.searchinventories").getBooleanValue(false);
        worldConfig.removeTag("saved");
        NEIClientConfig.setDefaultBoolean("magnetmode", false);
        NEIClientConfig.setDefaultBoolean("creativeinv", false);
        for (String s : AllowedPropertyMap.nameSet) {
            NEIClientConfig.setDefaultBoolean("disabled-" + s, false);
        }
        if (!localCompound.func_74764_b("search")) {
            localCompound.func_74778_a("search", "");
        }
        if (!localCompound.func_74764_b("quantity")) {
            localCompound.func_74768_a("quantity", 0);
        }
        creativeInv = new ItemStack[54];
        NBTTagList itemList = localCompound.func_74761_m("creativeitems");
        if (itemList != null) {
            for (int tagPos = 0; tagPos < itemList.func_74745_c(); ++tagPos) {
                NBTTagCompound stacksave = (NBTTagCompound)itemList.func_74743_b(tagPos);
                NEIClientConfig.creativeInv[stacksave.func_74771_c((String)"Slot") & 0xFF] = ItemStack.func_77949_a((NBTTagCompound)stacksave);
            }
        }
        NEIClientConfig.saveLocalConfig();
        LayoutManager.searchField.setText(NEIClientConfig.getSearchExpression());
        LayoutManager.quantity.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
    }

    public static int getItemQuantity() {
        return localCompound.func_74762_e("quantity");
    }

    private static void setDefaultBoolean(String setting, boolean value) {
        if (!localCompound.func_74764_b(setting)) {
            localCompound.func_74757_a(setting, value);
        }
    }

    public static boolean isWorldSpecific(String setting) {
        return worldConfig != null && worldConfig.containsTag(setting);
    }

    public static void copyWorldSetting(String setting) {
        if (worldConfig != null) {
            worldConfig.getTag(setting).setValue(globalConfig.getTag(setting).getValue());
        }
    }

    public static void removeWorldSetting(String setting) {
        if (worldConfig != null) {
            worldConfig.removeTag(setting);
        }
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static ConfigTag getSetting(String s) {
        if (worldConfig == null || global || !worldConfig.containsTag(s)) {
            return globalConfig.getTag(s);
        }
        return worldConfig.getTag(s);
    }

    public static boolean getBooleanSetting(String s) {
        return NEIClientConfig.getSetting(s).getBooleanValue();
    }

    public static boolean isEnabled() {
        return internalEnabled && NEIClientConfig.getBooleanSetting("options.enable");
    }

    public static void setEnabled(boolean flag) {
        NEIClientConfig.getSetting("options.enable").setBooleanValue(flag);
    }

    public static int getKeyBinding(String string) {
        return NEIClientConfig.getSetting("KeyBinding." + string).getIntValue();
    }

    public static void setKeyBinding(String string, int key) {
        NEIClientConfig.getSetting("KeyBinding." + string).setIntValue(key);
    }

    public static void setDefaultKeyBinding(String string, int key) {
        globalConfig.getTag("KeyBinding." + string).getIntValue(key);
    }

    public static int getCheatMode() {
        return NEIClientConfig.getIntSetting("options.cheatmode");
    }

    public static void cycleCheatMode() {
        NEIClientConfig.cycleSetting("options.cheatmode", 3);
        NEIClientConfig.checkCheatMode();
    }

    private static void checkCheatMode() {
        if (NEIClientConfig.getLockedMode() != -1) {
            NEIClientConfig.setIntSetting("options.cheatmode", NEIClientConfig.getLockedMode());
        }
    }

    public static int getLockedMode() {
        return NEIClientConfig.getIntSetting("options.lockmode");
    }

    public static int getLayoutStyle() {
        return NEIClientConfig.getIntSetting("options.layout style");
    }

    protected static void cycleLayoutStyle() {
        int currentLayout;
        LinkedList list = new LinkedList();
        for (Map.Entry entry : LayoutManager.layoutStyles.entrySet()) {
            list.add(entry.getKey());
        }
        Collections.sort(list);
        int nextLayout = currentLayout = NEIClientConfig.getLayoutStyle();
        if (nextLayout == (Integer)list.getLast()) {
            nextLayout = -1;
        }
        for (Integer i : list) {
            if (i <= nextLayout) continue;
            nextLayout = i;
            break;
        }
        NEIClientConfig.setIntSetting("options.layout style", nextLayout);
    }

    public static String getStringSetting(String s) {
        return NEIClientConfig.getSetting(s).getValue();
    }

    public static boolean isHidden() {
        return !internalEnabled || NEIClientConfig.getBooleanSetting("options.hidden");
    }

    public static boolean showIDs() {
        int i = NEIClientConfig.getIntSetting("options.show ids");
        return i == 2 || i == 1 && NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden();
    }

    public static int getIDVisibility() {
        return NEIClientConfig.getIntSetting("options.show ids");
    }

    public static void cycleIDVisibility() {
        NEIClientConfig.cycleSetting("options.show ids", 3);
    }

    public static void toggleBooleanSetting(String setting) {
        ConfigTag tag;
        tag.setBooleanValue(!(tag = NEIClientConfig.getSetting(setting)).getBooleanValue());
    }

    public static void cycleSetting(String setting, int max) {
        ConfigTag tag = NEIClientConfig.getSetting(setting);
        tag.setIntValue((tag.getIntValue() + 1) % max);
    }

    public static int getIntSetting(String setting) {
        return NEIClientConfig.getSetting(setting).getIntValue();
    }

    public static void setIntSetting(String setting, int val) {
        NEIClientConfig.getSetting(setting).setIntValue(val);
    }

    public static String getSearchExpression() {
        return localCompound.func_74779_i("search");
    }

    public static void setSearchExpression(String expression) {
        localCompound.func_74778_a("search", expression);
        NEIClientConfig.saveLocalConfig();
    }

    public static boolean getMagnetMode() {
        return SMPMagnetMode;
    }

    public static boolean invCreativeMode() {
        if (SMPCreativeInv && !NEIClientConfig.isActionPermissable(InterActionMap.CREATIVE)) {
            SMPCreativeInv = false;
        }
        return SMPCreativeInv;
    }

    public static void setInvCreative(boolean b) {
        SMPCreativeInv = b;
    }

    public static void setMagnetMode(boolean b) {
        SMPMagnetMode = b;
    }

    public static boolean areDamageVariantsShown() {
        return NEIClientConfig.hasSMPCounterPart() || NEIClientConfig.getSetting("command.give").getValue().contains("{3}");
    }

    public static void clearState(int state) {
        NEIClientConfig.statesSaved[state] = false;
        saveCompound.func_74782_a("save" + state, (NBTBase)new NBTTagCompound());
        NEIClientConfig.saveConfig();
    }

    public static void loadState(int state) {
        if (!statesSaved[state]) {
            return;
        }
        NBTTagCompound statesave = saveCompound.func_74775_l("save" + state);
        GuiContainer currentContainer = NEIClientUtils.getGuiContainer();
        LinkedList<TaggedInventoryArea> saveAreas = new LinkedList<TaggedInventoryArea>();
        saveAreas.add(new TaggedInventoryArea(NEIClientUtils.mc().field_71439_g.field_71071_by));
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            List areaList = handler.getInventoryAreas(currentContainer);
            if (areaList == null) continue;
            saveAreas.addAll(areaList);
        }
        for (TaggedInventoryArea area : saveAreas) {
            if (!statesave.func_74764_b(area.tag)) continue;
            Iterator i$ = area.slots.iterator();
            while (i$.hasNext()) {
                int slot = (Integer)i$.next();
                NEIClientUtils.setSlotContents(slot, null, area.isContainer());
            }
            NBTTagList areaTag = statesave.func_74761_m(area.tag);
            for (int i = 0; i < areaTag.func_74745_c(); ++i) {
                NBTTagCompound stacksave = (NBTTagCompound)areaTag.func_74743_b(i);
                int slot = stacksave.func_74771_c("Slot") & 0xFF;
                if (!area.slots.contains(slot)) continue;
                NEIClientUtils.setSlotContents(slot, ItemStack.func_77949_a((NBTTagCompound)stacksave), area.isContainer());
            }
        }
    }

    public static void saveState(int state) {
        NBTTagCompound statesave = saveCompound.func_74775_l("save" + state);
        GuiContainer currentContainer = NEIClientUtils.getGuiContainer();
        LinkedList<TaggedInventoryArea> saveAreas = new LinkedList<TaggedInventoryArea>();
        saveAreas.add(new TaggedInventoryArea(NEIClientUtils.mc().field_71439_g.field_71071_by));
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            List areaList = handler.getInventoryAreas(currentContainer);
            if (areaList == null) continue;
            saveAreas.addAll(areaList);
        }
        for (TaggedInventoryArea area : saveAreas) {
            NBTTagList areaTag = new NBTTagList(area.tag);
            Iterator i$ = area.slots.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                ItemStack stack = area.getStackInSlot(i);
                if (stack == null) continue;
                NBTTagCompound stacksave = new NBTTagCompound();
                stacksave.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(stacksave);
                areaTag.func_74742_a((NBTBase)stacksave);
            }
            statesave.func_74782_a(area.tag, (NBTBase)areaTag);
        }
        saveCompound.func_74782_a("save" + state, (NBTBase)statesave);
        NEIClientConfig.statesSaved[state] = true;
        NEIClientConfig.saveConfig();
    }

    public static void loadStates() {
        for (int state = 0; state < 7; ++state) {
            if (saveCompound.func_74764_b("save" + state) && saveCompound.func_74781_a("save" + state) instanceof NBTTagList) {
                saveCompound.func_82580_o("save" + state);
            }
            NEIClientConfig.statesSaved[state] = !saveCompound.func_74775_l("save" + state).func_82582_d();
        }
    }

    public static void loadConfig(World world) {
        if (configLoaded) {
            return;
        }
        NEIClientConfig.loadSavedConfig();
        vishash = new ItemVisibilityHash();
        ItemInfo.load(world);
        GuiInfo.load();
        RecipeInfo.load();
        LayoutManager.load();
        NEIController.load();
        if (NEICompatibility.hasForge) {
            weakDependancy_Forge.load();
        }
        configLoaded = true;
        ClassDiscoverer classDiscoverer = new ClassDiscoverer(new IStringMatcher(){

            @Override
            public boolean matches(String test) {
                return test.startsWith("NEI") && test.endsWith("Config.class");
            }
        }, IConfigureNEI.class);
        classDiscoverer.findClasses();
        for (Class class1 : classDiscoverer.classes) {
            try {
                IConfigureNEI config = (IConfigureNEI)class1.newInstance();
                config.loadConfig();
                NEIModContainer.plugins.add(config);
                System.out.println("Loaded " + class1.getName());
            }
            catch (Exception e) {
                System.out.println("Failed to Load " + class1.getName());
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        try {
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(saveFile);
            DataOutputStream dout = new DataOutputStream(fout);
            NBTBase.func_74731_a((NBTBase)saveCompound, (DataOutput)dout);
            dout.close();
            fout.close();
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public static void saveLocalConfig() {
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(localSave));
            NBTBase.func_74731_a((NBTBase)localCompound, (DataOutput)dout);
            dout.close();
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    private static void loadSavedConfig() {
        try {
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            if (saveFile.length() == 0L) {
                return;
            }
            FileInputStream fin = new FileInputStream(saveFile);
            DataInputStream din = new DataInputStream(fin);
            saveCompound = (NBTTagCompound)NBTBase.func_74739_b((DataInput)din);
            din.close();
            fin.close();
            NEIClientConfig.loadStates();
            ItemVisibilityHash.loadStates();
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public static boolean hasSMPCounterPart() {
        return hasSMPCounterpart;
    }

    public static void setHasSMPCounterPart(boolean flag) {
        hasSMPCounterpart = flag;
        permissableActions.clear();
        bannedBlocks.clear();
        disabledProperties.clear();
    }

    public static void resetPermissableActions() {
        permissableActions.clear();
    }

    public static void addPermissableAction(InterActionMap action) {
        permissableActions.add(action);
    }

    public static boolean isActionPermissable(InterActionMap action) {
        return NEIClientConfig.isActionPermissable(action.getName());
    }

    public static boolean isActionPermissable(String actionname) {
        if (!NEIClientConfig.isEnabled() || NEIClientConfig.isHidden()) {
            return false;
        }
        if (actionname.equals("nbt")) {
            return NEIClientConfig.hasSMPCounterPart();
        }
        InterActionMap action = InterActionMap.getAction(actionname);
        if (!NEIClientConfig.isActionPermissableInMode(actionname)) {
            return false;
        }
        if (action == InterActionMap.HEAL && !hasSMPCounterpart) {
            return !NEIClientConfig.getStringSetting("command.heal").equals("null");
        }
        if (hasSMPCounterpart) {
            return permissableActions.contains((Object)action);
        }
        return !hasSMPCounterpart && !action.requiresSMPCounterpart;
    }

    private static boolean isActionPermissableInMode(String actionmode) {
        String[] actions;
        if (NEIClientConfig.getCheatMode() == 0) {
            return false;
        }
        if (NEIClientConfig.getCheatMode() == 2) {
            return true;
        }
        for (String action : actions = NEIClientConfig.getUtilityDefinition()) {
            if (!action.equalsIgnoreCase(actionmode)) continue;
            return true;
        }
        return false;
    }

    private static String[] getUtilityDefinition() {
        return NEIClientConfig.getStringSetting("options.utility actions").replace(" ", "").split(",");
    }

    public static void setBannedBlocks(ArrayList ahash) {
        bannedBlocks.clear();
        for (ItemKey hash : ahash) {
            bannedBlocks.add(hash);
        }
    }

    public static void resetDisabledProperties() {
        disabledProperties.clear();
    }

    public static boolean canGetItem(ItemKey item) {
        return !bannedBlocks.contains(item);
    }

    public static boolean isPropertyDisabled(String name) {
        return disabledProperties.contains(AllowedPropertyMap.nameToIDMap.get(name));
    }

    public static void setPropertyDisabled(int ID) {
        disabledProperties.add(ID);
    }

    public static void setPropertyDisabled(String name, boolean disable) {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetPropertyDisabled(name, disable);
        }
    }

    public static void setItemQuantity(int i) {
        localCompound.func_74768_a("quantity", i);
        NEIClientConfig.saveLocalConfig();
    }

    public static void setInternalEnabled(boolean b) {
        internalEnabled = b;
    }

    public static void setCreativeMode(int mode) {
        NEIClientConfig.setInvCreative(mode == 2);
        Minecraft.func_71410_x().field_71442_b.func_78746_a(mode != 0 ? EnumGameType.CREATIVE : EnumGameType.SURVIVAL);
    }

    public static boolean validateEnchantments() {
        return worldConfig.getTag("saved.validateenchantments").getBooleanValue(true);
    }

    public static void toggleEnchantmentValidation() {
        worldConfig.getTag("saved.validateenchantments").setBooleanValue(!NEIClientConfig.validateEnchantments());
    }

    static {
        statesSaved = new boolean[7];
        internalEnabled = false;
        permissableActions = new HashSet();
        bannedBlocks = new HashSet();
        disabledProperties = new HashSet();
        saveCompound = new NBTTagCompound();
        saveFile = new File(Minecraft.func_71380_b(), "saves/NEI.dat");
        globalConfig = new ConfigFile(new File(Minecraft.func_71380_b(), "config/NEI.cfg"));
        global = false;
        NEIClientConfig.setDefaults();
    }
}

