/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.InventoryRange;
import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.FastTransferManger;
import codechicken.nei.ItemList;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.asm.NEIModContainer;
import codechicken.packager.Packager;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class NEIClientUtils
extends NEIServerUtils {
    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void reportException(Exception exception) {
        try {
            exception.printStackTrace();
            String s = "nei " + new SimpleDateFormat("d-M-y").format(new Date()) + " at " + new SimpleDateFormat("H.m.s.S").format(new Date()) + ".txt";
            File file = new File(Minecraft.func_71380_b(), s);
            PrintWriter printwriter = new PrintWriter(new FileWriter(file));
            printwriter.print("[code]NEI Version: " + NEIModContainer.class.getAnnotation(Packager.class).getVersion() + "\n");
            exception.printStackTrace(printwriter);
            printwriter.println("[/code]");
            printwriter.close();
            NEIClientUtils.addChatMessage("Error written to " + s);
        }
        catch (Exception exception1) {
            System.out.println("Error during safeReportException:");
            exception1.printStackTrace();
        }
    }

    public static void addChatMessage(String s) {
        if (NEIClientUtils.mc().field_71456_v != null) {
            NEIClientUtils.mc().field_71456_v.func_73827_b().func_73765_a(s);
        }
    }

    public static void deleteHeldItem() {
        NEIClientUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIClientUtils.mc().field_71442_b.func_78753_a(((GuiContainer)NEIClientUtils.mc().field_71462_r).field_74193_d.field_75152_c, -999, 0, 0, (EntityPlayer)NEIClientUtils.mc().field_71439_g);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIClientUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        ItemStack stack;
        ItemStack itemStack = stack = slotNumber == -999 ? NEIClientUtils.getHeldItem() : NEIClientUtils.mc().field_71439_g.field_71070_bA.func_75139_a(slotNumber).func_75211_c();
        if (stack == null) {
            return;
        }
        if (stack.field_77994_a == 1) {
            NEIClientUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.func_77946_l();
            --stack.field_77994_a;
            NEIClientUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        NEICPH.sendDeleteAllItems();
    }

    public static void deleteItemsOfType(ItemStack itemstack) {
        Container c = NEIClientUtils.getGuiContainer().field_74193_d;
        for (int i = 0; i < c.field_75151_b.size(); ++i) {
            ItemStack itemstack1;
            Slot slot = c.func_75139_a(i);
            if (slot == null || (itemstack1 = slot.func_75211_c()) == null || itemstack1.field_77993_c != itemstack.field_77993_c || itemstack1.func_77960_j() != itemstack.func_77960_j()) continue;
            NEIClientUtils.setSlotContents(i, null, true);
            slot.func_75215_d((ItemStack)null);
        }
    }

    public static ItemStack getHeldItem() {
        return NEIClientUtils.mc().field_71439_g.field_71071_by.func_70445_o();
    }

    public static void setSlotContents(int slot, ItemStack item, boolean containerInv) {
        NEICPH.sendSetSlot(slot, item, containerInv);
        if (slot == -999) {
            NEIClientUtils.mc().field_71439_g.field_71071_by.func_70437_b(item);
        }
    }

    public static void cheatItem(ItemStack typeStack, int button, int mode) {
        if (!NEIClientConfig.isActionPermissable("item")) {
            return;
        }
        if (mode == -1 && button == 0 && NEIClientUtils.shiftKey()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                ItemStack stack;
                if (!handler.canHandleItem(typeStack) || (stack = handler.getInfiniteItem(typeStack)) == null) continue;
                NEIClientUtils.giveStack(stack, stack.field_77994_a, true);
                return;
            }
            NEIClientUtils.cheatItem(typeStack, button, 0);
        } else if (button == 1) {
            NEIClientUtils.giveStack(typeStack, 1);
        } else if (mode == 1 && typeStack.field_77994_a < typeStack.func_77976_d()) {
            NEIClientUtils.giveStack(typeStack, typeStack.func_77976_d() - typeStack.field_77994_a);
        } else {
            int amount = NEIClientConfig.getItemQuantity();
            if (amount == 0) {
                amount = typeStack.func_77976_d();
            }
            NEIClientUtils.giveStack(typeStack, amount);
        }
    }

    public static void giveStack(ItemStack itemstack) {
        NEIClientUtils.giveStack(itemstack, itemstack.field_77994_a);
    }

    public static void giveStack(ItemStack itemstack, int i) {
        NEIClientUtils.giveStack(itemstack, i, false);
    }

    public static void giveStack(ItemStack itemstack, int i, boolean infinite) {
        ItemStack itemstack1 = NEIClientUtils.copyStack(itemstack, i);
        if (NEIClientConfig.hasSMPCounterPart()) {
            ItemStack typestack = NEIClientUtils.copyStack(itemstack1, 1);
            if (!infinite && !NEIClientUtils.canItemFitInInventory((EntityPlayer)NEIClientUtils.mc().field_71439_g, itemstack1) && NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
                int given;
                int qty;
                GuiContainer gui = NEIClientUtils.getGuiContainer();
                int increment = typestack.func_77976_d();
                for (given = 0; given < itemstack1.field_77994_a; given += qty) {
                    INEIGuiHandler handler;
                    qty = Math.min(itemstack1.field_77994_a - given, increment);
                    int slotNo = -1;
                    Iterator i$ = GuiInfo.guiHandlers.iterator();
                    while (i$.hasNext() && (slotNo = (handler = (INEIGuiHandler)i$.next()).getItemSpawnSlot(gui, typestack)) < 0) {
                    }
                    if (slotNo == -1) break;
                    Slot slot = gui.field_74193_d.func_75139_a(slotNo);
                    int current = slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
                    qty = Math.min(qty, slot.func_75219_a() - current);
                    ItemStack newStack = NEIClientUtils.copyStack(typestack, qty + current);
                    slot.func_75215_d(newStack);
                    NEIClientUtils.setSlotContents(slotNo, newStack, true);
                }
                NEICPH.sendSpawnItem(NEIClientUtils.copyStack(typestack, given), infinite, false);
            } else {
                NEICPH.sendSpawnItem(itemstack1, infinite, true);
            }
        } else {
            int qty;
            for (int given = 0; given < itemstack1.field_77994_a; given += qty) {
                qty = Math.min(itemstack1.field_77994_a - given, itemstack1.func_77976_d());
                NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.give"), NEIClientUtils.mc().field_71439_g.field_71092_bJ, itemstack1.field_77993_c, qty, itemstack1.func_77960_j());
            }
        }
    }

    public static void updateUnlimitedItems() {
        ItemStack itemstack = NEIClientUtils.getHeldItem();
        if (itemstack != null && itemstack.field_77994_a > 64) {
            itemstack.field_77994_a = 1;
        }
        ItemStack[] aitemstack = NEIClientUtils.mc().field_71439_g.field_71071_by.field_70462_a;
        for (int slot = 0; slot < aitemstack.length; ++slot) {
            ItemStack itemstack1 = aitemstack[slot];
            if (itemstack1 == null) continue;
            if (itemstack1.field_77994_a < 0 || itemstack1.field_77994_a > 64) {
                itemstack1.field_77994_a = 111;
            }
            if (itemstack1.func_77960_j() <= -32000 || itemstack1.func_77960_j() >= -30000) continue;
            itemstack1.func_77964_b(-32000);
        }
    }

    public static boolean isValidItem(ItemStack test) {
        for (ItemStack stack : ItemList.items) {
            if (!NEIClientUtils.areStacksIdentical(stack, test)) continue;
            return true;
        }
        return false;
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.getInsertableQuantity(new InventoryRange((IInventory)player.field_71071_by, 0, 36), itemstack) > 0;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getCreativeMode() {
        if (NEIClientConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIClientUtils.mc().field_71442_b.func_78758_h()) {
            return 1;
        }
        return 0;
    }

    public static void cycleCreativeMode() {
        int mode = NEIClientUtils.getCreativeMode();
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendCycleCreativeMode();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.creative"), mode ^ 1, NEIClientUtils.mc().field_71439_g.field_71092_bJ);
        }
    }

    public static long getTime() {
        return NEIClientUtils.mc().field_71441_e.func_72912_H().func_76073_f();
    }

    public static void setTime(long l) {
        NEIClientUtils.mc().field_71441_e.func_72912_H().func_76068_b(l);
    }

    public static void setHourForward(int hour) {
        long day = NEIClientUtils.getTime() / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetTime(hour);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.time"), newTime);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Integer) && !(args[i] instanceof Long)) continue;
            messageformat.setFormatByArgumentIndex(i, numberformat);
        }
        NEIClientUtils.mc().field_71439_g.func_71165_d(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIClientUtils.mc().field_71441_e.func_72912_H().func_76059_o();
    }

    public static void toggleRaining() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleRain();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.rain"), NEIClientUtils.isRaining() ? 0 : 1);
        }
    }

    public static void healPlayer() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendHeal();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.heal"), NEIClientUtils.mc().field_71439_g.field_71092_bJ);
        }
    }

    public static void toggleMagnetMode() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleMagnetMode();
        }
    }

    public static ArrayList concatIntegersToRanges(List damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static ArrayList addIntegersToRanges(List ranges, List damages) {
        for (int[] range : ranges) {
            for (int integer = range[0]; integer <= range[1]; ++integer) {
                damages.add(integer);
            }
        }
        return NEIClientUtils.concatIntegersToRanges(damages);
    }

    public static void dumpIDs() {
        try {
            boolean blocks = NEIClientConfig.getBooleanSetting("ID dump.blockIDs");
            boolean items = NEIClientConfig.getBooleanSetting("ID dump.itemIDs");
            boolean unusedblocks = NEIClientConfig.getBooleanSetting("ID dump.unused blockIDs");
            boolean unuseditems = NEIClientConfig.getBooleanSetting("ID dump.unused itemIDs");
            String s = "IDMap dump " + new SimpleDateFormat("d-M-y").format(new Date()) + " at " + new SimpleDateFormat("H.m.s.S").format(new Date()) + ".txt";
            File writeTo = new File(Minecraft.func_71380_b(), s);
            if (!writeTo.exists()) {
                writeTo.createNewFile();
            }
            PrintWriter writer = new PrintWriter(writeTo);
            for (int i = 1; i < Item.field_77698_e.length; ++i) {
                String name;
                if (i < Block.field_71973_m.length && Block.field_71973_m[i] != null && Block.field_71973_m[i].field_71990_ca != 0) {
                    if (!blocks) continue;
                    Block block = Block.field_71973_m[i];
                    name = block.func_71917_a();
                    if (name == null) {
                        name = block.getClass().getCanonicalName();
                    }
                    writer.println("Block. Name: " + name + ". ID: " + i);
                    continue;
                }
                if (Item.field_77698_e[i] != null) {
                    if (!items) continue;
                    Item item = Item.field_77698_e[i];
                    name = item.func_77658_a();
                    if (name == null) {
                        name = item.getClass().getCanonicalName();
                    }
                    writer.println("Item. Name: " + name + ". ID: " + i);
                    continue;
                }
                if (i < Block.field_71973_m.length) {
                    if (!unusedblocks) continue;
                    writer.println("Block. Unused ID: " + i);
                    continue;
                }
                if (!unuseditems) continue;
                writer.println("Item. Unused ID: " + i);
            }
            writer.close();
            NEIClientUtils.addChatMessage("Dumped IDMap to " + s);
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static void setItemQuantity(int i) {
        NEIClientConfig.setItemQuantity(i);
        LayoutManager.quantity.setText(Integer.toString(i));
    }

    public static GuiContainer getGuiContainer() {
        if (NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
            return (GuiContainer)NEIClientUtils.mc().field_71462_r;
        }
        return null;
    }

    public static void overlayScreen(GuiScreen gui) {
        if (NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
            FastTransferManger.clickSlot(NEIClientUtils.getGuiContainer(), -999);
        }
        NEIClientUtils.mc().field_71462_r = null;
        NEIClientUtils.mc().func_71373_a(gui);
    }

    public static boolean altKey() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }
}

