/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.ItemKey;
import codechicken.core.inventory.SlotDummy;
import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.BlockCoord;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.ContainerPotionCreator;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.InterActionMap;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetServerHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;

public class NEISPH
implements PacketCustom.IServerPacketHandler {
    public static final String channel = "NEI";

    @Override
    public void handlePacket(PacketCustom packet, NetServerHandler nethandler, EntityPlayerMP sender) {
        if (!NEIServerConfig.authenticatePacket(sender, packet)) {
            return;
        }
        switch (packet.getType()) {
            case 1: {
                this.handleGiveItem(sender, packet);
                break;
            }
            case 4: {
                NEIServerUtils.deleteAllItems(sender);
                break;
            }
            case 5: {
                this.setInventorySlot(sender, packet);
                break;
            }
            case 6: {
                NEIServerUtils.toggleMagnetMode(sender);
                break;
            }
            case 7: {
                NEIServerUtils.setHourForward(sender.field_70170_p, packet.readUnsignedByte(), true);
                break;
            }
            case 8: {
                NEIServerUtils.healPlayer((EntityPlayer)sender);
                break;
            }
            case 9: {
                NEIServerUtils.toggleRaining(sender.field_70170_p, true);
                break;
            }
            case 10: {
                this.sendPermissableActionsTo(sender);
                this.sendBannedBlocksTo(sender);
                this.sendDisabledPropertiesTo(sender, sender.field_71093_bK);
                NEISPH.sendMagnetModeTo(sender, NEIServerUtils.isMagnetMode(sender));
                NEISPH.sendCreativeModeTo(sender, NEIServerUtils.getCreativeMode(sender));
                break;
            }
            case 11: {
                sender.func_71110_a(sender.field_71070_bA, sender.field_71070_bA.func_75138_a());
                break;
            }
            case 12: {
                this.handlePropertyChange(sender, packet);
                break;
            }
            case 13: {
                NEIServerUtils.toggleCreativeMode(sender);
                break;
            }
            case 14: {
                NEIServerUtils.cycleCreativeInv(sender, packet.readInt());
                break;
            }
            case 15: {
                this.handleMobSpawnerID(sender.field_70170_p, packet.readCoord(), packet.readString());
                break;
            }
            case 20: {
                this.handleContainerPacket(sender, packet);
                break;
            }
            case 21: {
                this.openEnchantmentGui(sender);
                break;
            }
            case 22: {
                this.modifyEnchantment(sender, packet.readUnsignedByte(), packet.readUnsignedByte(), packet.readBoolean());
                break;
            }
            case 23: {
                this.processCreativeInv(sender, packet.readBoolean());
                break;
            }
            case 24: {
                this.openPotionGui(sender, packet);
                break;
            }
            case 25: {
                this.handleDummySlotSet(sender, packet);
            }
        }
    }

    private void handleDummySlotSet(EntityPlayerMP sender, PacketCustom packet) {
        short slotNumber = packet.readShort();
        ItemStack stack = packet.readItemStack(true);
        Slot slot = sender.field_71070_bA.func_75139_a((int)slotNumber);
        if (slot instanceof SlotDummy) {
            slot.func_75215_d(stack);
        }
    }

    private void handleContainerPacket(EntityPlayerMP sender, PacketCustom packet) {
        if (sender.field_71070_bA instanceof ContainerExtended) {
            ((ContainerExtended)sender.field_71070_bA).handleInputPacket(packet);
        }
    }

    private void handleMobSpawnerID(World world, BlockCoord coord, String mobtype) {
        TileEntity tile = world.func_72796_p(coord.x, coord.y, coord.z);
        if (tile instanceof TileEntityMobSpawner) {
            ((TileEntityMobSpawner)tile).func_98049_a().func_98272_a(mobtype);
            tile.func_70296_d();
            world.func_72845_h(coord.x, coord.y, coord.z);
        }
    }

    private void handlePropertyChange(EntityPlayerMP sender, PacketCustom packet) {
        int id = packet.readUnsignedByte();
        if (NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, (String)AllowedPropertyMap.idToFeatureClassMap.get(id))) {
            this.handlePropertyChange(sender.field_71093_bK, id, packet.readBoolean());
        }
    }

    private void processCreativeInv(EntityPlayerMP sender, boolean open) {
        if (open) {
            ServerUtils.openSMPContainer(sender, new ContainerCreativeInv((EntityPlayer)sender, new ExtendedCreativeInv(NEIServerConfig.forPlayer(sender.field_71092_bJ), Side.SERVER)), new IGuiPacketSender(){

                @Override
                public void sendPacket(EntityPlayerMP player, int windowId) {
                    PacketCustom packet = new PacketCustom(NEISPH.channel, 23);
                    packet.writeBoolean(true);
                    packet.writeByte(windowId);
                    packet.sendToPlayer((EntityPlayer)player);
                }
            });
        } else {
            sender.func_71128_l();
            PacketCustom packet = new PacketCustom(channel, 23);
            packet.writeBoolean(false);
            packet.sendToPlayer((EntityPlayer)sender);
        }
    }

    private void handlePropertyChange(int dim, int propID, boolean disable) {
        NEIServerConfig.setPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(propID), disable);
        this.sendDisabledPropertiesTo(null, dim);
    }

    private void sendDisabledPropertiesTo(EntityPlayerMP player, int dim) {
        ArrayList disabledProperties = new ArrayList();
        for (Map.Entry prop : AllowedPropertyMap.nameToIDMap.entrySet()) {
            if (!NEIServerConfig.isPropertyDisabled(dim, (String)prop.getKey())) continue;
            disabledProperties.add(prop.getValue());
        }
        PacketCustom packet = new PacketCustom(channel, 12);
        packet.writeByte(disabledProperties.size());
        Iterator i$ = disabledProperties.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            packet.writeByte(i);
        }
        if (player != null) {
            packet.sendToPlayer((EntityPlayer)player);
        } else {
            for (EntityPlayer sendplayer : ServerUtils.getPlayersInDimension(dim)) {
                packet.sendToPlayer(sendplayer);
            }
        }
    }

    private void handleGiveItem(EntityPlayerMP player, PacketCustom packet) {
        boolean infinite = packet.readBoolean();
        boolean doSpawn = packet.readBoolean();
        int num = packet.readUnsignedByte();
        LinkedList<String> name = new LinkedList<String>();
        for (int i = 0; i < num; ++i) {
            name.add(packet.readString());
        }
        ItemStack item = packet.readItemStack();
        if (item == null) {
            ServerUtils.sendChatTo(player, "\u00a7fNo such item.");
            return;
        }
        item.field_77994_a = packet.readInt();
        NEIServerUtils.givePlayerItem(player, item, infinite, name, doSpawn);
    }

    private void setInventorySlot(EntityPlayerMP player, PacketCustom packet) {
        boolean container = packet.readBoolean();
        short slot = packet.readShort();
        ItemStack item = packet.readItemStack();
        if (!NEIServerConfig.canPlayerUseFeature(player.field_71092_bJ, item == null ? "delete" : "item")) {
            return;
        }
        NEIServerUtils.setSlotContents((EntityPlayer)player, slot, item, container);
    }

    private void modifyEnchantment(EntityPlayerMP player, int e, int lvl, boolean add) {
        ContainerEnchantmentModifier containerem = (ContainerEnchantmentModifier)player.field_71070_bA;
        if (add) {
            containerem.addEnchantment(e, lvl);
        } else {
            containerem.removeEnchantment(e);
        }
    }

    private void openEnchantmentGui(EntityPlayerMP player) {
        ServerUtils.openSMPContainer(player, (Container)new ContainerEnchantmentModifier(player.field_71071_by, player.field_70170_p, 0, 0, 0), new IGuiPacketSender(){

            @Override
            public void sendPacket(EntityPlayerMP player, int windowId) {
                PacketCustom packet = new PacketCustom(NEISPH.channel, 21);
                packet.writeByte(windowId);
                packet.sendToPlayer((EntityPlayer)player);
            }
        });
    }

    private void openPotionGui(EntityPlayerMP player, PacketCustom packet) {
        InventoryBasic b = new InventoryBasic("potionStore", true, 9);
        for (int i = 0; i < b.func_70302_i_(); ++i) {
            b.func_70299_a(i, packet.readItemStack());
        }
        ServerUtils.openSMPContainer(player, new ContainerPotionCreator(player.field_71071_by, (IInventory)b), new IGuiPacketSender(){

            @Override
            public void sendPacket(EntityPlayerMP player, int windowId) {
                PacketCustom packet = new PacketCustom(NEISPH.channel, 24);
                packet.writeByte(windowId);
                packet.sendToPlayer((EntityPlayer)player);
            }
        });
    }

    public static void sendMagnetModeTo(EntityPlayerMP player, boolean enable) {
        PacketCustom packet = new PacketCustom(channel, 6);
        packet.writeBoolean(enable);
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendCreativeModeTo(EntityPlayerMP player, int mode) {
        PacketCustom packet = new PacketCustom(channel, 7);
        packet.writeByte(mode);
        packet.sendToPlayer((EntityPlayer)player);
    }

    private void sendPermissableActionsTo(EntityPlayerMP player) {
        LinkedList<Integer> actions = new LinkedList<Integer>();
        for (InterActionMap action : InterActionMap.values()) {
            if (!NEIServerConfig.canPlayerUseFeature(player.field_71092_bJ, action.getName())) continue;
            actions.add(action.ordinal());
        }
        PacketCustom packet = new PacketCustom(channel, 10);
        packet.writeByte(actions.size());
        Iterator i$ = actions.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            packet.writeByte(i);
        }
        packet.sendToPlayer((EntityPlayer)player);
    }

    private void sendBannedBlocksTo(EntityPlayerMP player) {
        ArrayList bannedblocks = new ArrayList();
        for (Map.Entry entry : NEIServerConfig.bannedblocks.entrySet()) {
            if (NEIServerConfig.isPlayerInList(player.field_71092_bJ, (HashSet)entry.getValue(), true)) continue;
            bannedblocks.add(entry.getKey());
        }
        PacketCustom packet = new PacketCustom(channel, 11);
        packet.writeInt(bannedblocks.size());
        for (ItemKey hash : bannedblocks) {
            packet.writeShort(hash.item.field_77993_c);
            packet.writeShort(hash.item.func_77960_j());
        }
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendHasServerSideTo(EntityPlayerMP player) {
        System.out.println("Sending serverside check to: " + player.field_71092_bJ);
        PacketCustom packet = new PacketCustom(channel, 1);
        packet.writeByte(5);
        packet.writeString(CommonUtils.getWorldName(player.field_70170_p));
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendAddMagneticItemTo(EntityPlayerMP player, EntityItem item) {
        PacketCustom packet = new PacketCustom(channel, 13);
        packet.writeInt(item.field_70157_k);
        packet.sendToPlayer((EntityPlayer)player);
    }
}

