/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.config.ConfigFile;
import codechicken.core.config.ConfigTag;
import codechicken.core.inventory.ItemKey;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.PlayerSave;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class NEIServerConfig {
    public static HashMap playerSaves = new HashMap();
    public static HashMap bannedblocks = new HashMap();
    public static ConfigFile serverConfig = new ConfigFile(new File(CommonUtils.getMinecraftDir(), "config/NEIServer.cfg")).setComment("NEI Server Permissions \n Names are Comma (,) separated \n ALL, OP and NONE are special names");
    public static File worldSaveFile;
    public static File worldSaveDir;
    public static NBTTagCompound worldCompound;
    private static MinecraftServer server;

    public static void load(World world) {
        if (MinecraftServer.func_71276_C() == server) {
            return;
        }
        System.out.println("Loading NEI");
        server = MinecraftServer.func_71276_C();
        NEIServerConfig.initDefaults();
        NEIServerConfig.loadBannedBlocks();
        NEIServerConfig.loadSavedConfig(world);
    }

    private static void loadSavedConfig(World world) {
        try {
            worldSaveDir = CommonUtils.getWorldBaseSaveLocation(world);
            worldSaveFile = new File(worldSaveDir, "NEI.dat");
            if (!worldSaveFile.getParentFile().exists()) {
                worldSaveFile.getParentFile().mkdirs();
            }
            if (!worldSaveFile.exists()) {
                worldSaveFile.createNewFile();
            }
            if (worldSaveFile.length() == 0L) {
                worldCompound = new NBTTagCompound();
            } else {
                DataInputStream din = new DataInputStream(new FileInputStream(worldSaveFile));
                worldCompound = (NBTTagCompound)NBTBase.func_74739_b((DataInput)din);
                din.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDefaults() {
        serverConfig.setNewLineMode(1);
        serverConfig.getTag("permissions").useBraces();
        serverConfig.getTag("permissions").setComment("List of players who can use these features. :Eg. time=CodeChicken, Friend1");
        serverConfig.getTag("BannedBlocks").useBraces();
        serverConfig.getTag("BannedBlocks").setComment("List of players who can use these blocks. :Anyone not listed here will not have these blocks appear in their item panel.:format is {itemID}::{itemDamage}:Eg. 12::5=CodeChicken, Friend1");
        NEIServerConfig.setDefaultFeature("time", new String[0]);
        NEIServerConfig.setDefaultFeature("rain", new String[0]);
        NEIServerConfig.setDefaultFeature("heal", new String[0]);
        NEIServerConfig.setDefaultFeature("magnet", new String[0]);
        NEIServerConfig.setDefaultFeature("creative", new String[0]);
        NEIServerConfig.setDefaultFeature("enchant", new String[0]);
        NEIServerConfig.setDefaultFeature("potion", new String[0]);
        NEIServerConfig.setDefaultFeature("save-state", new String[0]);
        NEIServerConfig.setDefaultFeature("item", new String[0]);
        NEIServerConfig.setDefaultFeature("delete", new String[0]);
        NEIServerConfig.setDefaultFeature("notify-item", "CONSOLE, OP");
        serverConfig.getTag("BannedBlocks." + Block.field_71986_z.field_71990_ca + ":0").setDefaultValue("NONE");
    }

    private static void setDefaultFeature(String featurename, String ... names) {
        if (names.length == 0) {
            names = new String[]{"OP"};
        }
        String list = "";
        for (int i = 0; i < names.length; ++i) {
            if (i >= 1) {
                list = list + ", ";
            }
            list = list + names[i];
        }
        serverConfig.getTag("permissions." + featurename).setDefaultValue(list);
    }

    public static boolean canPlayerUseFeature(String playername, String featurename) {
        return NEIServerConfig.isPlayerInList(playername, NEIServerConfig.getPlayerList("permissions." + featurename), true);
    }

    public static boolean isPlayerInList(String playername, HashSet list, boolean allowCards) {
        if (playername.equals("CONSOLE")) {
            return list.contains(playername);
        }
        playername = playername.toLowerCase();
        if (allowCards) {
            if (list.contains("ALL")) {
                return true;
            }
            if ((ServerUtils.isPlayerOP(playername) || ServerUtils.isPlayerOwner(playername)) && list.contains("OP")) {
                return true;
            }
        }
        return list.contains(playername);
    }

    public static boolean isPropertyDisabled(int dim, String name) {
        return NEIServerConfig.getDimCompound(dim).func_74767_n("disabled" + name);
    }

    private static NBTTagCompound getDimCompound(int dim) {
        if (!worldCompound.func_74764_b("dim" + dim)) {
            worldCompound.func_74766_a("dim" + dim, new NBTTagCompound());
        }
        return worldCompound.func_74775_l("dim" + dim);
    }

    public static void setPropertyDisabled(int dim, String name, boolean disable) {
        NEIServerConfig.getDimCompound(dim).func_74757_a("disabled" + name, disable);
        NEIServerConfig.saveWorldCompound();
    }

    private static void saveWorldCompound() {
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(worldSaveFile));
            NBTBase.func_74731_a((NBTBase)worldCompound, (DataOutput)dout);
            dout.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HashSet getPlayerList(String tag) {
        String[] list = serverConfig.getTag(tag).getValue("").replace(" ", "").split(",");
        return new HashSet<String>(Arrays.asList(list));
    }

    public static void addPlayerToList(String playername, String tag) {
        HashSet list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.add(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    public static void remPlayerFromList(String playername, String tag) {
        HashSet list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.remove(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    private static void savePlayerList(String tag, Collection list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append((String)iterator.next());
            ++i;
        }
        serverConfig.getTag(tag).setValue(sb.toString());
    }

    private static void loadBannedBlocks() {
        ConfigTag banTag = serverConfig.getTag("BannedBlocks");
        for (Map.Entry entry : banTag.childTagMap().entrySet()) {
            String ident = (String)entry.getKey();
            String[] num = ident.split(":");
            ItemKey hash = num.length == 1 ? new ItemKey(Integer.parseInt(num[0]), -1) : new ItemKey(Integer.parseInt(num[0]), Integer.parseInt(num[1]));
            bannedblocks.put(hash, NEIServerConfig.getPlayerList(((ConfigTag)entry.getValue()).qualifiedname));
        }
    }

    public static PlayerSave forPlayer(String username) {
        return (PlayerSave)playerSaves.get(username);
    }

    public static void loadPlayer(EntityPlayer player) {
        System.out.println("Loading Player: " + player.field_71092_bJ);
        playerSaves.put(player.field_71092_bJ, new PlayerSave(player.field_71092_bJ, new File(worldSaveDir, "NEI/players")));
    }

    public static void unloadPlayer(EntityPlayer player) {
        System.out.println("Unloading Player: " + player.field_71092_bJ);
        PlayerSave playerSave = (PlayerSave)playerSaves.remove(player.field_71092_bJ);
        if (playerSave != null) {
            playerSave.save();
        }
    }

    public static boolean authenticatePacket(EntityPlayerMP sender, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: 
            case 5: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "item");
            }
            case 4: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "delete");
            }
            case 6: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "magnet");
            }
            case 7: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "time");
            }
            case 8: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "heal");
            }
            case 9: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "rain");
            }
            case 13: 
            case 14: 
            case 23: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "creative");
            }
            case 21: 
            case 22: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "enchant");
            }
            case 24: {
                return NEIServerConfig.canPlayerUseFeature(sender.field_71092_bJ, "potion");
            }
        }
        return true;
    }
}

