/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class NEIServerUtils {
    public static boolean isRaining(World world) {
        return world.func_72912_H().func_76059_o();
    }

    public static void toggleRaining(World world, boolean notify) {
        boolean raining;
        boolean bl = raining = !world.func_72896_J();
        if (!raining) {
            ((WorldServer)world).field_73011_w.resetRainAndThunder();
        } else {
            world.func_72913_w();
        }
        if (notify) {
            ServerUtils.sendChatToAll("Rain turned " + (raining ? "on" : "off"));
        }
    }

    public static void healPlayer(EntityPlayer player) {
        player.func_70691_i(20);
        player.func_71024_bL().func_75122_a(20, 1.0f);
        player.func_70066_B();
    }

    public static long getTime(World world) {
        return world.func_72912_H().func_76073_f();
    }

    public static void setTime(long l, World world) {
        world.func_72912_H().func_76068_b(l);
    }

    public static void setSlotContents(EntityPlayer player, int slot, ItemStack item, boolean containerInv) {
        if (slot == -999) {
            player.field_71071_by.func_70437_b(item);
        } else if (containerInv) {
            player.field_71070_bA.func_75141_a(slot, item);
        } else {
            player.field_71071_by.func_70299_a(slot, item);
        }
    }

    public static void deleteAllItems(EntityPlayerMP player) {
        for (int i = 0; i < player.field_71070_bA.field_75151_b.size(); ++i) {
            ((Slot)player.field_71070_bA.field_75151_b.get(i)).func_75215_d(null);
        }
        player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }

    public static void setHourForward(World world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll("Day " + NEIServerUtils.getTime(world) / 24000L + ". " + hour + ":00");
        }
    }

    public static void advanceDisabledTimes(World world) {
        int hour;
        int dim = CommonUtils.getDimension(world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (true) {
            int zone = newhour / 6;
            try {
                if (!NEIServerConfig.isPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(zone))) break;
                newhour = (zone + 1) % 4 * 6;
            }
            catch (NumberFormatException nfe) {
                String s = "Time: " + NEIServerUtils.getTime(world) + ", Hour: " + hour + ", NewHour: " + newhour + ", Zone: " + zone + ", Map: " + AllowedPropertyMap.idToNameMap.toString();
                ServerUtils.mc().func_71201_j(s);
                throw nfe;
            }
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        int i;
        for (i = 0; i < player.field_71071_by.func_70302_i_() - 4; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            return true;
        }
        if (!itemstack.func_77951_h()) {
            if (itemstack.func_77976_d() == 1) {
                return false;
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invstack = player.field_71071_by.func_70301_a(i);
                if (invstack == null || invstack.field_77993_c != itemstack.field_77993_c || !invstack.func_77985_e() || invstack.field_77994_a >= invstack.func_77976_d() || invstack.field_77994_a >= player.field_71071_by.func_70297_j_() || invstack.func_77981_g() && invstack.func_77960_j() != itemstack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    public static int getSlotForStack(Container c, int firstSlot, int lastSlot, ItemStack item) {
        Slot slot;
        int slotIndex;
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            int filled;
            slot = c.func_75139_a(slotIndex);
            if (!slot.func_75216_d() || !item.func_77985_e() || (filled = slot.func_75211_c().field_77994_a) >= slot.func_75219_a() || filled >= item.func_77976_d() || !NEIServerUtils.areStacksSameType(slot.func_75211_c(), item)) continue;
            return slotIndex;
        }
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            slot = c.func_75139_a(slotIndex);
            if (slot.func_75216_d()) continue;
            return slotIndex;
        }
        return -1;
    }

    public static int getSlotForStack(IInventory inv, int firstSlot, int lastSlot, ItemStack item) {
        int slotIndex;
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            int filled;
            ItemStack slotStack = inv.func_70301_a(slotIndex);
            if (slotStack == null || !item.func_77985_e() || (filled = slotStack.field_77994_a) >= inv.func_70297_j_() || filled >= item.func_77976_d() || !NEIServerUtils.areStacksSameType(slotStack, item)) continue;
            return slotIndex;
        }
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            if (inv.func_70301_a(slotIndex) != null) continue;
            return slotIndex;
        }
        return -1;
    }

    public static void sendNotice(String s, String permission) {
        NEIServerUtils.sendNotice(s, permission, -1);
    }

    public static void sendNotice(String s, String permission, int colour) {
        if (NEIServerConfig.canPlayerUseFeature("CONSOLE", permission)) {
            Logger.getLogger("Minecraft").info(s.replaceAll("\u00a7.", ""));
        }
        for (EntityPlayerMP player : ServerUtils.mc().func_71203_ab().field_72404_b) {
            if (!NEIServerConfig.canPlayerUseFeature(player.field_71092_bJ, permission)) continue;
            ServerUtils.sendChatTo(player, s);
        }
    }

    public static boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        return InventoryUtils.canStack(stack1, stack2);
    }

    public static boolean areStacksSameTypeCrafting(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.field_77993_c == stack2.field_77993_c && (stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == -1 || stack2.func_77960_j() == -1 || stack1.func_77973_b().func_77645_m());
    }

    public static int compareStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.field_77993_c != stack2.field_77993_c) {
            return stack1.field_77993_c - stack2.field_77993_c;
        }
        if (stack1.field_77994_a != stack2.field_77994_a) {
            return stack1.field_77994_a - stack2.field_77994_a;
        }
        return stack1.func_77960_j() - stack2.func_77960_j();
    }

    public static boolean areStacksIdentical(ItemStack stack1, ItemStack stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static void givePlayerItem(EntityPlayerMP player, ItemStack stack, boolean infinite, LinkedList name, boolean doGive) {
        if (stack.func_77973_b() == null) {
            player.field_71135_a.func_72567_b((Packet)new Packet3Chat("\u00a7fNo such item."));
            return;
        }
        StringBuilder namebuilder = new StringBuilder();
        boolean first = true;
        for (String string : name) {
            if (!first) {
                namebuilder.append(" ");
            }
            namebuilder.append(string.trim());
            first = false;
        }
        String itemname = namebuilder.toString();
        int given = 0;
        if (!doGive) {
            given = stack.field_77994_a;
        } else if (infinite) {
            player.field_71071_by.func_70441_a(stack);
        } else {
            int qty;
            int increment = stack.func_77976_d();
            for (given = 0; given < stack.field_77994_a; given += qty) {
                qty = Math.min(stack.field_77994_a - given, increment);
                int slotNo = NEIServerUtils.getSlotForStack((IInventory)player.field_71071_by, 0, 36, stack);
                if (slotNo == -1) break;
                ItemStack slotStack = player.field_71071_by.func_70301_a(slotNo);
                int current = slotStack != null ? slotStack.field_77994_a : 0;
                qty = Math.min(qty, player.field_71071_by.func_70297_j_() - current);
                player.field_71071_by.func_70299_a(slotNo, NEIServerUtils.copyStack(stack, qty + current));
            }
        }
        if (infinite) {
            NEIServerUtils.sendNotice("Giving " + player.field_71092_bJ + " infinite " + "\u00a7f" + itemname, "notify-item");
        } else {
            NEIServerUtils.sendNotice("Giving " + player.field_71092_bJ + " " + given + " of " + "\u00a7f" + itemname, "notify-item");
        }
        player.field_71070_bA.func_75142_b();
    }

    public static ItemStack copyStack(ItemStack itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.field_77994_a += i;
        return itemstack.func_77979_a(i);
    }

    public static ItemStack copyStack(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.field_77994_a);
    }

    public static boolean isMagnetMode(EntityPlayerMP player) {
        return NEIServerConfig.forPlayer(player.field_71092_bJ).getMagnetMode();
    }

    public static void toggleMagnetMode(EntityPlayerMP player) {
        PlayerSave playerSave;
        playerSave.setMagnetMode(!(playerSave = NEIServerConfig.forPlayer(player.field_71092_bJ)).getMagnetMode());
        NEISPH.sendMagnetModeTo(player, playerSave.getMagnetMode());
    }

    public static int getCreativeMode(EntityPlayerMP player) {
        if (NEIServerConfig.forPlayer(player.field_71092_bJ).getCreativeInv()) {
            return 2;
        }
        if (player.field_71134_c.func_73083_d()) {
            return 1;
        }
        return 0;
    }

    public static void toggleCreativeMode(EntityPlayerMP player) {
        int mode = (NEIServerUtils.getCreativeMode(player) + 1) % 3;
        player.field_71134_c.func_73076_a(mode == 0 ? EnumGameType.SURVIVAL : EnumGameType.CREATIVE);
        NEIServerConfig.forPlayer(player.field_71092_bJ).setCreativeInv(mode == 2);
        NEISPH.sendCreativeModeTo(player, mode);
    }

    public static void cycleCreativeInv(EntityPlayerMP player, int steps) {
        int col;
        int row;
        int col2;
        int row2;
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack[][] slots = new ItemStack[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.field_71092_bJ);
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            slots[9][hotbar] = inventory.field_70462_a[hotbar];
        }
        for (row2 = 0; row2 < 3; ++row2) {
            for (col2 = 0; col2 < 9; ++col2) {
                slots[row2 + 6][col2] = inventory.field_70462_a[(row2 + 1) * 9 + col2];
            }
        }
        for (row2 = 0; row2 < 6; ++row2) {
            for (col2 = 0; col2 < 9; ++col2) {
                slots[row2][col2] = playerSave.creativeInv[row2 * 9 + col2];
            }
        }
        ItemStack[][] newslots = new ItemStack[10][];
        for (row = 0; row < 10; ++row) {
            newslots[(row + steps + 10) % 10] = slots[row];
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            inventory.field_70462_a[hotbar] = newslots[9][hotbar];
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                inventory.field_70462_a[(row + 1) * 9 + col] = newslots[row + 6][col];
            }
        }
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                playerSave.creativeInv[row * 9 + col] = newslots[row][col];
            }
        }
        playerSave.setDirty();
    }

    public static List getEnchantments(ItemStack itemstack) {
        NBTTagList nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.func_77986_q()) != null) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short word0 = ((NBTTagCompound)nbttaglist.func_74743_b(i)).func_74765_d("id");
                short word1 = ((NBTTagCompound)nbttaglist.func_74743_b(i)).func_74765_d("lvl");
                int[] ai = new int[]{word0, word1};
                arraylist.add(ai);
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(ItemStack itemstack, int e) {
        List allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(ItemStack itemstack, int e) {
        List allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List enchantments, Enchantment e) {
        for (int[] ai : enchantments) {
            if (e.func_77326_a(Enchantment.field_77331_b[ai[0]])) continue;
            return true;
        }
        return false;
    }
}

