/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ServerUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerSave {
    public ItemStack[] creativeInv;
    private File saveFile;
    private NBTTagCompound saveCompound;
    public String username;
    private boolean isDirty;
    private boolean creativeInvDirty;
    public boolean wasOp;

    public PlayerSave(String playername, File saveLocation) {
        this.username = playername;
        this.wasOp = ServerUtils.isPlayerOP(playername);
        this.saveFile = new File(saveLocation, this.username + ".dat");
        if (!this.saveFile.getParentFile().exists()) {
            this.saveFile.getParentFile().mkdirs();
        }
        this.load();
    }

    private void load() {
        this.saveCompound = new NBTTagCompound();
        try {
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
            }
            if (this.saveFile.length() > 0L) {
                DataInputStream din = new DataInputStream(new FileInputStream(this.saveFile));
                this.saveCompound = (NBTTagCompound)NBTBase.func_74739_b((DataInput)din);
                din.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadCreativeInv();
    }

    private void loadCreativeInv() {
        this.creativeInv = new ItemStack[54];
        NBTTagList itemList = this.saveCompound.func_74761_m("creativeitems");
        if (itemList != null) {
            for (int tagPos = 0; tagPos < itemList.func_74745_c(); ++tagPos) {
                NBTTagCompound stacksave = (NBTTagCompound)itemList.func_74743_b(tagPos);
                this.creativeInv[stacksave.func_74771_c((String)"Slot") & 0xFF] = ItemStack.func_77949_a((NBTTagCompound)stacksave);
            }
        }
    }

    public boolean getMagnetMode() {
        return this.saveCompound.func_74767_n("magnetmode");
    }

    public boolean getCreativeInv() {
        return this.saveCompound.func_74767_n("creativeinv");
    }

    public void setMagnetMode(boolean b) {
        this.saveCompound.func_74757_a("magnetmode", b);
        this.setDirty();
    }

    public void setCreativeInv(boolean b) {
        this.saveCompound.func_74757_a("creativeinv", b);
        this.setDirty();
    }

    public void save() {
        if (!this.isDirty) {
            return;
        }
        if (this.creativeInvDirty) {
            this.saveCreativeInv();
        }
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(this.saveFile));
            NBTBase.func_74731_a((NBTBase)this.saveCompound, (DataOutput)dout);
            dout.close();
            this.isDirty = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveCreativeInv() {
        NBTTagList invsave = new NBTTagList();
        for (int i = 0; i < this.creativeInv.length; ++i) {
            if (this.creativeInv[i] == null) continue;
            NBTTagCompound stacksave = new NBTTagCompound();
            stacksave.func_74774_a("Slot", (byte)i);
            this.creativeInv[i].func_77955_b(stacksave);
            invsave.func_74742_a((NBTBase)stacksave);
        }
        this.saveCompound.func_74782_a("creativeitems", (NBTBase)invsave);
        this.creativeInvDirty = false;
    }

    public void setCreativeDirty() {
        this.isDirty = true;
        this.creativeInvDirty = true;
    }

    public void setDirty() {
        this.isDirty = true;
    }
}

