/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class PositionedStack {
    public int relx;
    public int rely;
    public ItemStack[] items;
    public ItemStack item;

    public PositionedStack(Object object, int x, int y) {
        if (object instanceof ItemStack) {
            this.items = new ItemStack[]{(ItemStack)object};
        } else if (object instanceof ItemStack[]) {
            this.items = (ItemStack[])object;
        } else if (object instanceof List) {
            this.items = ((List)object).toArray(new ItemStack[0]);
        } else {
            throw new ClassCastException("not an ItemStack or ItemStack[]");
        }
        this.generatePermutations();
        if (this.items.length == 0) {
            System.out.println("No items in recipe");
            this.items = new ItemStack[]{new ItemStack((Block)Block.field_72067_ar)};
        }
        this.setPermutationToRender(0);
        this.relx = x;
        this.rely = y;
    }

    private void generatePermutations() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            if (item == null || item.func_77973_b() == null) continue;
            ItemStack permutation = item.func_77946_l();
            stacks.add(permutation);
            if (item.func_77960_j() != Short.MAX_VALUE) continue;
            permutation.func_77964_b(0);
            for (int damage = 1; damage <= 15; ++damage) {
                permutation = item.func_77946_l();
                permutation.func_77964_b(damage);
                if (!NEIClientUtils.isValidItem(permutation)) continue;
                stacks.add(permutation);
            }
        }
        this.items = stacks.toArray(new ItemStack[0]);
    }

    public void setMaxSize(int i) {
        for (ItemStack item : this.items) {
            if (item.field_77994_a <= i) continue;
            item.field_77994_a = i;
        }
    }

    public PositionedStack copy() {
        return new PositionedStack(this.items, this.relx, this.rely);
    }

    public void setPermutationToRender(int index) {
        this.item = this.items[index].func_77946_l();
        if (this.item.func_77960_j() == -1) {
            this.item.func_77964_b(0);
        }
    }
}

