/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class ServerHandler
implements ITickHandler,
IPlayerTracker {
    private static ServerHandler instance;

    public static void load() {
        instance = new ServerHandler();
        PacketCustom.assignHandler("NEI", 0, 255, new NEISPH());
        TickRegistry.registerTickHandler((ITickHandler)instance, (Side)Side.SERVER);
        GameRegistry.registerPlayerTracker((IPlayerTracker)instance);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            this.processDisabledProperties((World)tickData[0]);
        }
        if (type.contains(TickType.WORLDLOAD)) {
            NEIServerConfig.load((World)tickData[0]);
        }
        if (type.contains(TickType.PLAYER)) {
            EntityPlayerMP player = (EntityPlayerMP)tickData[0];
            PlayerSave save = NEIServerConfig.forPlayer(player.field_71092_bJ);
            if (save == null) {
                return;
            }
            this.updateMagneticPlayer(player, save);
            this.updateOpChange(player, save);
            save.save();
        }
    }

    private void updateOpChange(EntityPlayerMP player, PlayerSave save) {
        boolean isOp = ServerUtils.isPlayerOP(save.username);
        if (isOp != save.wasOp) {
            NEISPH.sendHasServerSideTo(player);
            save.wasOp = isOp;
        }
    }

    private void processDisabledProperties(World world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isPropertyDisabled(CommonUtils.getDimension(world), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    private void updateMagneticPlayer(EntityPlayerMP player, PlayerSave save) {
        if (!save.getMagnetMode() || player.field_70128_L) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = player.field_70170_p.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b((double)distancexz, (double)distancey, (double)distancexz));
        for (EntityItem item : items) {
            double rationspeedy;
            if (item.field_70293_c > 0 || !NEIServerUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            if (item.field_70293_c == 0) {
                NEISPH.sendAddMagneticItemTo(player, item);
            }
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz < 1.0) {
                item.func_70100_b_((EntityPlayer)player);
            }
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + speedxz * dx;
            double vy = item.field_70181_x + speedy * dy;
            double vz = item.field_70179_y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            item.field_70159_w = vx;
            item.field_70181_x = vy;
            item.field_70179_y = vz;
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD, TickType.PLAYER, TickType.WORLDLOAD);
    }

    public String getLabel() {
        return "NEI Server";
    }

    public void onPlayerLogin(EntityPlayer player) {
        NEIServerConfig.loadPlayer(player);
        NEISPH.sendHasServerSideTo((EntityPlayerMP)player);
    }

    public void onPlayerLogout(EntityPlayer player) {
        NEIServerConfig.unloadPlayer(player);
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
        NEISPH.sendHasServerSideTo((EntityPlayerMP)player);
    }

    public void onPlayerRespawn(EntityPlayer player) {
        NEISPH.sendHasServerSideTo((EntityPlayerMP)player);
    }
}

