/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.LayoutManager;
import codechicken.nei.Widget;
import codechicken.nei.forge.GuiContainerManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public abstract class TextField
extends Widget {
    private String text = "";
    public boolean centered;
    public long backdowntime;
    public int backs;
    public String identifier;
    public int cursorCounter;

    public TextField(String ident) {
        this.identifier = ident;
    }

    public int getTextColour() {
        return this.focused() ? -2039584 : -7303024;
    }

    public void drawBox(GuiContainerManager gui) {
        gui.drawRect(this.x, this.y, this.width, this.height, -6250336);
        gui.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2, -16777216);
    }

    @Override
    public void draw(GuiContainerManager gui, int mousex, int mousey) {
        this.drawBox(gui);
        String drawtext = this.text;
        if (this.text.length() > this.getMaxTextLength()) {
            int startOffset = drawtext.length() - this.getMaxTextLength();
            if (startOffset < 0 || startOffset > drawtext.length()) {
                startOffset = 0;
            }
            drawtext = drawtext.substring(startOffset);
        }
        if (this.focused() && this.cursorCounter / 6 % 2 == 0) {
            drawtext = drawtext + '_';
        }
        int textWidth = gui.getStringWidth(this.text);
        int textx = this.centered ? this.x + (this.width - textWidth) / 2 : this.x + 4;
        int texty = this.y + (this.height + 1) / 2 - 3;
        gui.drawText(textx, texty, drawtext, this.getTextColour());
    }

    @Override
    public void onGuiClick(int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            this.setFocus(false);
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 1) {
            this.setText("");
        }
        this.setFocus(true);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (LayoutManager.getInputFocused() != this) {
            return false;
        }
        if (keyID == 14) {
            if (this.text.length() > 0) {
                this.setText(this.text.substring(0, this.text.length() - 1));
                this.backdowntime = System.currentTimeMillis();
            }
        } else if (keyID == 28 || keyID == 1) {
            this.setFocus(false);
            this.onExit();
        } else if (keyChar == '\u0016') {
            String pastestring = GuiScreen.func_73870_l();
            if (pastestring == null) {
                pastestring = "";
            }
            if (this.isValid(this.text + pastestring)) {
                this.setText(this.text + pastestring);
            }
        } else if (this.isValid(this.text + keyChar)) {
            this.setText(this.text + keyChar);
        }
        return true;
    }

    public void onExit() {
    }

    public abstract void onTextChange(String var1);

    public boolean isValid(String string) {
        return ChatAllowedCharacters.field_71568_a.indexOf(string.charAt(string.length() - 1)) >= 0;
    }

    @Override
    public void update(GuiContainerManager gui) {
        ++this.cursorCounter;
        if (this.backdowntime > 0L) {
            if (Keyboard.isKeyDown((int)14) && this.text.length() > 0) {
                if ((float)(System.currentTimeMillis() - this.backdowntime) > 200.0f / (1.0f + (float)this.backs * 0.3f)) {
                    this.setText(this.text.substring(0, this.text.length() - 1));
                    this.backdowntime = System.currentTimeMillis();
                    ++this.backs;
                }
            } else {
                this.backdowntime = 0L;
                this.backs = 0;
            }
        }
    }

    public void setText(String s) {
        String oldText = this.text;
        this.text = this.filterText(s);
        this.onTextChange(oldText);
    }

    public String filterText(String s) {
        return s;
    }

    private int getMaxTextLength() {
        return this.width / 6 - 2;
    }

    public void setFocus(boolean focus) {
        if (focus) {
            LayoutManager.setInputFocused(this);
        } else if (this.focused()) {
            LayoutManager.setInputFocused(null);
        }
    }

    public boolean focused() {
        return LayoutManager.getInputFocused() == this;
    }

    public String text() {
        return this.text;
    }
}

