/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.alg.MathHelper;
import codechicken.core.render.RenderUtils;
import codechicken.nei.ClientHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class WorldOverlayRenderer {
    @ForgeSubscribe
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        GL11.glPushMatrix();
        EntityLiving entity = event.context.field_72777_q.field_71451_h;
        RenderUtils.translateToWorldCoords((Entity)entity, event.partialTicks);
        this.renderChunkBounds((Entity)entity);
        this.renderMobSpawnOverlay((Entity)entity);
        GL11.glPopMatrix();
    }

    private void renderMobSpawnOverlay(Entity entity) {
        if (ClientHandler.instance().mobSpawnOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        int curSpawnMode = 2;
        World world = entity.field_70170_p;
        int x1 = (int)entity.field_70165_t;
        int z1 = (int)entity.field_70161_v;
        int y1 = (int)MathHelper.clip(entity.field_70163_u, 16.0, world.func_72800_K() - 16);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (int x = x1 - 16; x <= x1 + 16; ++x) {
            for (int z = z1 - 16; z <= z1 + 16; ++z) {
                Chunk chunk = world.func_72938_d(x, z);
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (biome.func_76747_a(EnumCreatureType.monster).isEmpty() || biome.func_76741_f() <= 0.0f) continue;
                for (int y = y1 - 16; y < y1 + 16; ++y) {
                    int spawnMode = this.getSpawnMode(chunk, aabb, x, y, z);
                    if (spawnMode == 0) continue;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 1) {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        curSpawnMode = spawnMode;
                    }
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)(z + 1));
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)(z + 1));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private int getSpawnMode(Chunk chunk, AxisAlignedBB aabb, int x, int y, int z) {
        if (!SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.monster, (World)chunk.field_76637_e, (int)x, (int)y, (int)z) || chunk.func_76614_a(EnumSkyBlock.Block, x & 0xF, y, z & 0xF) >= 8) {
            return 0;
        }
        aabb.field_72340_a = (double)x + 0.2;
        aabb.field_72336_d = (double)x + 0.8;
        aabb.field_72338_b = (double)y + 0.01;
        aabb.field_72337_e = (double)y + 1.8;
        aabb.field_72339_c = (double)z + 0.2;
        aabb.field_72334_f = (double)z + 0.8;
        if (!chunk.field_76637_e.func_72855_b(aabb) || !chunk.field_76637_e.func_72840_a(aabb).isEmpty() || chunk.field_76637_e.func_72953_d(aabb)) {
            return 0;
        }
        if (chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF) >= 8) {
            return 1;
        }
        return 2;
    }

    private void renderChunkBounds(Entity entity) {
        if (ClientHandler.instance().chunkOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                double x1 = entity.field_70176_ah + cx << 4;
                double z1 = entity.field_70164_aj + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)dist);
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (ClientHandler.instance().chunkOverlay != 2 || cx != 0 || cz != 0) continue;
                dy = 32.0;
                y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)0.4);
                for (double y = (double)((int)y1); y <= y2; y += 1.0) {
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                }
                for (double h = 1.0; h <= 15.0; h += 1.0) {
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z2);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

