/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.asm;

import codechicken.core.asm.ASMHelper;
import codechicken.core.asm.CC_ClassWriter;
import codechicken.core.asm.ClassHeirachyManager;
import codechicken.core.asm.ClassOverrider;
import codechicken.core.asm.InstructionComparator;
import codechicken.core.asm.ObfuscationMappings;
import codechicken.nei.asm.NEICorePlugin;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.IClassTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NEITransformer
implements IClassTransformer {
    public byte[] transformer001(String name, byte[] bytes) {
        ObfuscationMappings.ClassMapping classmap = new ObfuscationMappings.ClassMapping("net/minecraft/client/gui/inventory/GuiContainer");
        if (ClassHeirachyManager.classExtends(name, classmap.javaClass(), bytes)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            ObfuscationMappings.DescriptorMapping methodmap = new ObfuscationMappings.DescriptorMapping("net/minecraft/client/gui/GuiScreen", "updateScreen", "()V");
            ObfuscationMappings.DescriptorMapping supermap = new ObfuscationMappings.DescriptorMapping(methodmap, cnode.superName);
            InsnList supercall = new InsnList();
            supercall.add((AbstractInsnNode)new VarInsnNode(25, 0));
            supercall.add((AbstractInsnNode)supermap.toInsn(183));
            boolean changed = false;
            for (MethodNode methodnode : cnode.methods) {
                InsnList importantNodeList;
                if (!methodmap.matches(methodnode) || InstructionComparator.insnListMatches(importantNodeList = InstructionComparator.getImportantList(methodnode.instructions), supercall, 0)) continue;
                methodnode.instructions.insertBefore(methodnode.instructions.getFirst(), supercall);
                System.out.println("Inserted super call into " + name + "." + supermap.s_name);
                changed = true;
            }
            if (changed) {
                bytes = ASMHelper.createBytes(cnode, 3);
            }
        }
        return bytes;
    }

    public byte[] transformer002(String name, byte[] bytes) {
        ObfuscationMappings.ClassMapping classmap = new ObfuscationMappings.ClassMapping("net/minecraft/block/BlockMobSpawner");
        if (classmap.isClass(name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            ObfuscationMappings.DescriptorMapping methodmap = new ObfuscationMappings.DescriptorMapping("net/minecraft/block/Block", "onBlockPlacedBy", "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/EntityLiving;Lnet/minecraft/item/ItemStack;)V");
            MethodNode methodnode = (MethodNode)cnode.visitMethod(1, methodmap.s_name, methodmap.s_desc, null, null);
            methodnode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodnode.instructions.add((AbstractInsnNode)new FieldInsnNode(179, "codechicken/nei/ItemMobSpawner", "placedX", "I"));
            methodnode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodnode.instructions.add((AbstractInsnNode)new FieldInsnNode(179, "codechicken/nei/ItemMobSpawner", "placedY", "I"));
            methodnode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            methodnode.instructions.add((AbstractInsnNode)new FieldInsnNode(179, "codechicken/nei/ItemMobSpawner", "placedZ", "I"));
            methodnode.instructions.add((AbstractInsnNode)new InsnNode(177));
            bytes = ASMHelper.createBytes(cnode, 3);
            System.out.println("Generated BlockMobSpawner helper method.");
        }
        return bytes;
    }

    public byte[] transformer003(String name, byte[] bytes) {
        ObfuscationMappings.DescriptorMapping methodmap = new ObfuscationMappings.DescriptorMapping("net/minecraft/inventory/Slot", "getBackgroundIconTexture", "()Ljava/lang/String;");
        if (methodmap.isClass(name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            boolean declared = false;
            for (MethodNode method : cnode.methods) {
                if (!methodmap.matches(method)) continue;
                declared = true;
                break;
            }
            if (!declared) {
                CC_ClassWriter cw = new CC_ClassWriter(2);
                cnode.accept((ClassVisitor)cw);
                MethodVisitor mv = cw.visitMethod(1, "getBackgroundIconTexture", "()Ljava/lang/String;", null, null);
                mv.visitCode();
                mv.visitLdcInsn((Object)"/gui/items.png");
                mv.visitInsn(176);
                mv.visitMaxs(1, 0);
                mv.visitEnd();
                bytes = cw.toByteArray();
                System.out.println("Generated default " + methodmap.s_owner + ".getBackgroundIconTexture().");
            }
        }
        return bytes;
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            if (FMLRelauncher.side().equals("CLIENT")) {
                bytes = this.transformer001(name, bytes);
                bytes = this.transformer002(name, bytes);
                bytes = this.transformer003(name, bytes);
                bytes = ClassOverrider.overrideBytes(name, bytes, new ObfuscationMappings.ClassMapping("net/minecraft/client/gui/inventory/GuiContainer"), NEICorePlugin.location);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }
}

