/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.forge;

import codechicken.nei.forge.DefaultSlotClickHandler;
import codechicken.nei.forge.IContainerDrawHandler;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerObjectHandler;
import codechicken.nei.forge.IContainerSlotClickHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerManager {
    public GuiContainer window;
    public static RenderItem drawItems = new RenderItem();
    public static final LinkedList tooltipHandlers = new LinkedList();
    public static final LinkedList inputHandlers = new LinkedList();
    public static final LinkedList drawHandlers = new LinkedList();
    public static final LinkedList objectHandlers = new LinkedList();
    public static final LinkedList slotClickHandlers = new LinkedList();
    private static HashSet stackTraces;

    public GuiContainerManager(GuiContainer screen) {
        this.window = screen;
    }

    public static void addTooltipHandler(IContainerTooltipHandler handler) {
        tooltipHandlers.add(handler);
    }

    public static void addInputHandler(IContainerInputHandler handler) {
        inputHandlers.add(handler);
    }

    public static void addDrawHandler(IContainerDrawHandler handler) {
        drawHandlers.add(handler);
    }

    public static void addObjectHandler(IContainerObjectHandler handler) {
        objectHandlers.add(handler);
    }

    public static void addSlotClickHandler(IContainerSlotClickHandler handler) {
        slotClickHandlers.addFirst(handler);
    }

    public Point getMousePosition() {
        Minecraft mc = this.window.field_73882_e;
        ScaledResolution scaledresolution = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        return new Point(Mouse.getX() * w / mc.field_71443_c, h - Mouse.getY() * h / mc.field_71440_d - 1);
    }

    public ItemStack getStackMouseOver() {
        Slot slot;
        Point mousePos = this.getMousePosition();
        ItemStack item = null;
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            item = objectHandler.getStackUnderMouse(this.window, mousePos.x, mousePos.y);
            if (item == null) continue;
            return item;
        }
        if (!this.objectUnderMouse(mousePos.x, mousePos.y) && (slot = this.window.func_74187_b(mousePos.x, mousePos.y)) != null) {
            item = slot.func_75211_c();
        }
        return item;
    }

    public int getStringWidth(String s) {
        if (s == null || s.equals("")) {
            return 0;
        }
        return GuiContainerManager.getStringWidthNoColours(this.window.field_73886_k, s);
    }

    public static int getStringWidthNoColours(FontRenderer fontRenderer, String s) {
        int pos;
        while ((pos = s.indexOf(167)) != -1) {
            s = s.substring(0, pos) + s.substring(pos + 2);
        }
        return fontRenderer.func_78256_a(s);
    }

    public static List itemDisplayNameMultiline(ItemStack itemstack, GuiContainer gui, boolean includeHandlers) {
        List<String> namelist = null;
        try {
            namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, includeHandlers && Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        if (includeHandlers) {
            for (IContainerTooltipHandler handler : tooltipHandlers) {
                namelist = handler.handleItemTooltip(gui, itemstack, namelist);
            }
        }
        namelist.set(0, "\u00a7" + Integer.toHexString(itemstack.func_77953_t().field_77937_e) + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + (String)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, false);
        return (String)list.get(0);
    }

    public static String concatenatedDisplayName(ItemStack itemstack, boolean includeHandlers) {
        int pos;
        List list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, includeHandlers);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : list) {
            if (first) {
                first = false;
            } else {
                sb.append("#");
            }
            sb.append(name);
        }
        String s = sb.toString();
        while ((pos = s.indexOf(167)) != -1) {
            s = s.substring(0, pos) + s.substring(pos + 2);
        }
        return s;
    }

    public void drawRect(int x, int y, int w, int h, int colour) {
        this.window.func_73733_a(x, y, x + w, y + h, colour, colour);
    }

    public void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        this.window.func_73733_a(x, y, x + w, y + h, colour1, colour2);
    }

    public void drawTexturedModalRect(int x, int y, int tx, int ty, int w, int h) {
        this.window.func_73729_b(x, y, tx, ty, w, h);
    }

    public void drawText(int x, int y, String text, int colour, boolean shadow) {
        if (shadow) {
            this.window.field_73886_k.func_78261_a(text, x, y, colour);
        } else {
            this.window.field_73886_k.func_78276_b(text, x, y, colour);
        }
    }

    public void drawTextCentered(int x, int y, int w, int h, String text, int colour, boolean shadow) {
        this.drawText(x + (w - this.getStringWidth(text)) / 2, y + (h - 8) / 2, text, colour, shadow);
    }

    public void drawTextCentered(String text, int x, int y, int colour, boolean shadow) {
        this.drawText(x - this.getStringWidth(text) / 2, y, text, colour, shadow);
    }

    public void drawText(int x, int y, String text, boolean shadow) {
        this.drawText(x, y, text, -1, shadow);
    }

    public void drawText(int x, int y, String text, int colour) {
        this.drawText(x, y, text, colour, true);
    }

    public void drawTextCentered(int x, int y, int w, int h, String text, int colour) {
        this.drawText(x + (w - this.getStringWidth(text)) / 2, y + (h - 8) / 2, text, colour);
    }

    public void drawTextCentered(String text, int x, int y, int colour) {
        this.drawText(x - this.getStringWidth(text) / 2, y, text, colour);
    }

    public void drawText(int x, int y, String text) {
        this.drawText(x, y, text, -1);
    }

    public void drawTip(int x, int y, String text) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(text);
        this.drawMultilineTip(x, y, temp);
    }

    public void drawMultilineTip(int x, int y, List list) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (list.size() > 0) {
            int maxwidth = 0;
            for (int line = 0; line < list.size(); ++line) {
                int swidth = GuiContainerManager.getStringWidthNoColours(this.window.field_73886_k, (String)list.get(line));
                if (swidth <= maxwidth) continue;
                maxwidth = swidth;
            }
            if (x + maxwidth > this.window.field_73880_f - 16) {
                x = this.window.field_73880_f - maxwidth - 16;
            }
            if (y < 16) {
                y = 16;
            }
            int drawx = x - this.window.field_74198_m + 12;
            int drawy = y - this.window.field_74197_n - 12;
            int w = maxwidth;
            int h = 8;
            if (list.size() > 1) {
                h += 2 + (list.size() - 1) * 10;
            }
            this.window.field_73735_i = 300.0f;
            GuiContainer.field_74196_a.field_77023_b = 300.0f;
            int i4 = -267386864;
            this.drawGradientRect(drawx - 3, drawy - 4, w + 6, 1, i4, i4);
            this.drawGradientRect(drawx - 3, drawy + h + 3, w + 6, 1, i4, i4);
            this.drawGradientRect(drawx - 3, drawy - 3, w + 6, h + 6, i4, i4);
            this.drawGradientRect(drawx - 4, drawy - 3, 1, h + 6, i4, i4);
            this.drawGradientRect(drawx + w + 3, drawy - 3, 1, h + 6, i4, i4);
            int colour1 = 0x505000FF;
            int colour2 = (colour1 & 0xFEFEFE) >> 1 | colour1 & 0xFF000000;
            this.drawGradientRect(drawx - 3, drawy - 2, 1, h + 4, colour1, colour2);
            this.drawGradientRect(drawx + w + 2, drawy - 2, 1, h + 4, colour1, colour2);
            this.drawGradientRect(drawx - 3, drawy - 3, w + 6, 1, colour1, colour1);
            this.drawGradientRect(drawx - 3, drawy + h + 2, w + 6, 1, colour2, colour2);
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                this.window.field_73886_k.func_78261_a(s, drawx, drawy, -1);
                if (i == 0) {
                    drawy += 2;
                }
                drawy += 10;
            }
            this.window.field_73735_i = 0.0f;
            GuiContainer.field_74196_a.field_77023_b = 0.0f;
        }
    }

    public void drawItem(int i, int j, ItemStack itemstack) {
        GuiContainerManager.drawItem(i, j, itemstack, this.getFontRenderer(itemstack), this.window.field_73882_e.field_71446_o);
    }

    public FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer f;
        if (stack != null && stack.func_77973_b() != null && (f = stack.func_77973_b().getFontRenderer(stack)) != null) {
            return f;
        }
        return this.window.field_73886_k;
    }

    public static void drawItem(int i, int j, ItemStack itemstack, FontRenderer fontRenderer, RenderEngine renderEngine) {
        GuiContainerManager.enable3DRender();
        GuiContainerManager.drawItems.field_77023_b += 100.0f;
        try {
            drawItems.func_82406_b(fontRenderer, renderEngine, itemstack, i, j);
            drawItems.func_77021_b(fontRenderer, renderEngine, itemstack, i, j);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = itemstack + sw.toString();
            if (!stackTraces.contains(stackTrace)) {
                System.err.println("Error while rendering: " + itemstack);
                e.printStackTrace();
                stackTraces.add(stackTrace);
            }
            if (Tessellator.field_78398_a.field_78415_z) {
                Tessellator.field_78398_a.func_78381_a();
            }
            drawItems.func_77015_a(fontRenderer, renderEngine, new ItemStack(51, 1, 0), i, j);
        }
        GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        GuiContainerManager.enable2DRender();
        if (Tessellator.field_78398_a.field_78415_z) {
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public void setColouredItemRender(boolean enable) {
        GuiContainerManager.drawItems.field_77024_a = !enable;
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public void bindTexture(String s) {
        this.window.field_73882_e.field_71446_o.func_98187_b(s);
    }

    public void load() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.load(this.window);
        }
    }

    public void refresh() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public void guiTick() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public boolean lastKeyTyped(int keyID, char keyChar) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.lastKeyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean firstKeyTyped(int keyID, char keyChar) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onKeyTyped(this.window, keyChar, keyID);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.keyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseClicked(this.window, mousex, mousey, button);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.mouseClicked(this.window, mousex, mousey, button)) continue;
            return true;
        }
        return false;
    }

    public void mouseWheel(int scrolled) {
        Point mousepos = this.getMousePosition();
        for (IContainerInputHandler inputHandler : inputHandlers) {
            inputHandler.onMouseScrolled(this.window, mousepos.x, mousepos.y, scrolled);
        }
        for (IContainerInputHandler inputHandler : inputHandlers) {
            if (!inputHandler.mouseScrolled(this.window, mousepos.x, mousepos.y, scrolled)) continue;
            return;
        }
    }

    public void mouseUp(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseUp(this.window, mousex, mousey, button);
        }
    }

    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseDragged(this.window, mousex, mousey, button, heldTime);
        }
    }

    public void preDraw() {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.onPreDraw(this.window);
        }
    }

    public void renderObjects(int mousex, int mousey) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderObjects(this.window, mousex, mousey);
        }
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.postRenderObjects(this.window, mousex, mousey);
        }
    }

    public void renderToolTips(int mousex, int mousey) {
        List tooltip = this.window.handleTooltip(mousex, mousey, new LinkedList());
        for (IContainerTooltipHandler handler : tooltipHandlers) {
            tooltip = handler.handleTooltipFirst(this.window, mousex, mousey, tooltip);
        }
        if (tooltip.isEmpty() && this.shouldShowTooltip()) {
            ItemStack stack = this.getStackMouseOver();
            if (stack != null) {
                tooltip = GuiContainerManager.itemDisplayNameMultiline(stack, this.window, true);
            }
            tooltip = this.window.handleItemTooltip(stack, mousex, mousey, tooltip);
        }
        this.drawMultilineTip(mousex, mousey, tooltip);
    }

    public boolean shouldShowTooltip() {
        for (IContainerObjectHandler handler : objectHandlers) {
            if (handler.shouldShowTooltip(this.window)) continue;
            return false;
        }
        return this.window.field_73882_e.field_71439_g.field_71071_by.func_70445_o() == null;
    }

    public void renderSlotUnderlay(Slot slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotUnderlay(this.window, slot);
        }
    }

    public void renderSlotOverlay(Slot slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotOverlay(this.window, slot);
        }
    }

    public boolean objectUnderMouse(int mousex, int mousey) {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            if (!objectHandler.objectUnderMouse(this.window, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public void handleMouseClick(Slot slot, int slotIndex, int button, int modifier) {
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.beforeSlotClick(this.window, slotIndex, button, slot, modifier);
        }
        boolean eventHandled = false;
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            eventHandled = handler.handleSlotClick(this.window, slotIndex, button, slot, modifier, eventHandled);
        }
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.afterSlotClick(this.window, slotIndex, button, slot, modifier);
        }
    }

    static {
        GuiContainerManager.addSlotClickHandler(new DefaultSlotClickHandler());
        stackTraces = new HashSet();
    }
}

