/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import org.lwjgl.opengl.GL11;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final HashSet ingredientIDs = new HashSet();
    public static final HashSet apotions = new HashSet();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class getGuiClass() {
        return GuiBrewingStand.class;
    }

    @Override
    public String getRecipeName() {
        return "Brewing";
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (CachedBrewingRecipe recipe : apotions) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (result.field_77993_c != Item.field_77726_bs.field_77779_bT) {
            return;
        }
        int damage = result.func_77960_j();
        for (CachedBrewingRecipe recipe : apotions) {
            if (recipe.result.item.func_77960_j() != damage) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.field_77993_c != Item.field_77726_bs.field_77779_bT && !ingredientIDs.contains(ingredient.field_77993_c)) {
            return;
        }
        for (CachedBrewingRecipe recipe : apotions) {
            if (!NEIServerUtils.areStacksSameType(recipe.ingredient.item, ingredient) && !NEIServerUtils.areStacksSameType(recipe.precursorPotion.item, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "/gui/alchemy.png";
    }

    public void drawForegrounda(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTexture("/gui/alchemy.png");
        int t = this.cycleticks % 120 / 4;
        gui.drawTexturedModalRect(92, 5, 176, 0, 8, t + 1);
        t = this.cycleticks % 35;
        gui.drawTexturedModalRect(60, 33 - t, 185, 31 - t, 12, t - 1);
    }

    @Override
    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(gui, 60, 1, 185, -2, 12, 30, 35, 3);
    }

    public void searchPotions() {
        HashSet newPotions;
        TreeSet<Integer> allPotions = new TreeSet<Integer>();
        HashSet<Integer> nextLevelPotions = new HashSet<Integer>();
        nextLevelPotions.add(0);
        do {
            newPotions = new HashSet();
            for (Integer basePotionID : nextLevelPotions) {
                if (ItemPotion.func_77831_g((int)basePotionID)) continue;
                for (Integer ingredID : ingredientIDs) {
                    int result = PotionHelper.func_77913_a((int)basePotionID, (String)Item.field_77698_e[ingredID].func_77666_t());
                    if (ItemPotion.func_77831_g((int)result)) {
                        this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                        continue;
                    }
                    List baseMods = Item.field_77726_bs.func_77834_f(basePotionID.intValue());
                    List newMods = Item.field_77726_bs.func_77834_f(result);
                    if (basePotionID > 0 && baseMods == newMods || baseMods != null && (baseMods.equals(newMods) || newMods == null) || basePotionID == result || this.levelModifierChanged(basePotionID, result)) continue;
                    this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                }
            }
        } while ((nextLevelPotions = newPotions).size() > 0);
        allPotions.add(0);
        API.setItemDamageVariants(Item.field_77726_bs.field_77779_bT, allPotions);
        API.addSetRange("Vanilla.Items.Potions", new MultiItemRange().add((Item)Item.field_77726_bs));
        API.addSetRange("Vanilla.Items.Potions.Splash", new MultiItemRange().add((Item)Item.field_77726_bs, 16384, 32768));
        MultiItemRange positivepots = new MultiItemRange();
        MultiItemRange negativepots = new MultiItemRange();
        MultiItemRange neutralpots = new MultiItemRange();
        Iterator i$ = allPotions.iterator();
        while (i$.hasNext()) {
            Iterator i$2;
            int potionID = (Integer)i$.next();
            List effectlist = Item.field_77726_bs.func_77834_f(potionID);
            int type = 0;
            if (effectlist != null && !effectlist.isEmpty() && (i$2 = effectlist.iterator()).hasNext()) {
                PotionEffect potioneffect = (PotionEffect)i$2.next();
                type = Potion.field_76425_a[potioneffect.func_76456_a()].func_76398_f() ? -1 : 1;
            }
            if (type == 0) {
                neutralpots.add((Item)Item.field_77726_bs, potionID, potionID);
                continue;
            }
            if (type == 1) {
                positivepots.add((Item)Item.field_77726_bs, potionID, potionID);
                continue;
            }
            if (type != -1) continue;
            negativepots.add((Item)Item.field_77726_bs, potionID, potionID);
        }
        API.addSetRange("Items.Potions.Positive", positivepots);
        API.addSetRange("Items.Potions.Negative", negativepots);
        API.addSetRange("Items.Potions.Neutral", neutralpots);
    }

    private boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private void addPotion(int ingred, int basePotion, int result, TreeSet allPotions, HashSet newPotions) {
        apotions.add(new CachedBrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int hashcode;
        PositionedStack precursorPotion;
        PositionedStack result;
        PositionedStack ingredient;

        public CachedBrewingRecipe(int ingredID, int basePotionID, int resultDamage) {
            super(BrewingRecipeHandler.this);
            this.precursorPotion = new PositionedStack(new ItemStack(Item.field_77726_bs.field_77779_bT, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(new ItemStack(ingredID, 1, 0), 74, 6);
            this.result = new PositionedStack(new ItemStack(Item.field_77726_bs.field_77779_bT, 1, resultDamage), 97, 35);
            this.calculateHashcode();
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        @Override
        public ArrayList getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.ingredient);
            recipestacks.add(this.precursorPotion);
            return recipestacks;
        }

        private void calculateHashcode() {
            this.hashcode = this.result.item.func_77960_j() << 16 + this.precursorPotion.item.func_77960_j();
            this.hashcode = 31 * this.hashcode + (this.ingredient.item.field_77993_c << 16 + this.ingredient.item.func_77960_j());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedBrewingRecipe)) {
                return false;
            }
            CachedBrewingRecipe recipe2 = (CachedBrewingRecipe)obj;
            return this.result.item.func_77960_j() == recipe2.result.item.func_77960_j() && this.precursorPotion.item.func_77960_j() == recipe2.precursorPotion.item.func_77960_j() && NEIServerUtils.areStacksSameType(this.ingredient.item, recipe2.ingredient.item);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

