/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.FastTransferManger;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class DefaultOverlayHandler
implements IOverlayHandler {
    int offsetx;
    int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        ArrayList ingredients = recipe.getIngredientStacks(recipeIndex);
        List ingredStacks = this.getPermutationIngredients(ingredients);
        this.findInventoryQuantities(gui, ingredStacks);
        List assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private void moveIngredients(GuiContainer gui, List assignedIngredients, int quantity) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            ItemStack pstack = distrib.permutation;
            int transferCap = quantity * pstack.field_77994_a;
            int transferred = 0;
            int destSlotIndex = 0;
            Slot dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.func_77976_d();
            for (Slot slot : gui.field_74193_d.field_75151_b) {
                ItemStack stack;
                if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) || !InventoryUtils.canStack(stack = slot.func_75211_c(), pstack)) continue;
                FastTransferManger.clickSlot(gui, slot.field_75222_d);
                int amount = Math.min(transferCap - transferred, stack.field_77994_a);
                for (int c = 0; c < amount; ++c) {
                    FastTransferManger.clickSlot(gui, dest.field_75222_d, 1);
                    ++transferred;
                    if (++slotTransferred < slotTransferCap) continue;
                    if (++destSlotIndex == distrib.slots.length) {
                        dest = null;
                        break;
                    }
                    dest = distrib.slots[destSlotIndex];
                    slotTransferred = 0;
                }
                FastTransferManger.clickSlot(gui, slot.field_75222_d);
                if (transferred < transferCap && dest != null) continue;
                continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.func_77976_d()) {
                allSlots = istack.numSlots * istack.stack.func_77976_d();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List ingredients, List assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        for (int i = 0; i < recipeSlots.length; ++i) {
            for (Slot slot : recipeSlots[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = ((IngredientDistribution)assignedIngredients.get((int)i)).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.func_75216_d()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.func_77976_d() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            ((IngredientDistribution)assignedIngredients.get((int)i)).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private List assignIngredients(List ingredients, List ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (int j = 0; j < ingredStacks.size(); ++j) {
                    int relsize;
                    DistributedIngred istack = (DistributedIngred)ingredStacks.get(j);
                    if (!InventoryUtils.canStack(pstack, istack.stack) || istack.invAmount - istack.distributed < pstack.field_77994_a || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.field_77994_a) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.field_77994_a;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(GuiContainer gui, List ingredStacks) {
        for (Slot slot : gui.field_74193_d.field_75151_b) {
            ItemStack pstack;
            DistributedIngred istack;
            if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) || (istack = this.findIngred(ingredStacks, pstack = slot.func_75211_c())) == null) continue;
            istack.invAmount += pstack.field_77994_a;
        }
    }

    private List getPermutationIngredients(List ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.field_77994_a;
            }
        }
        return ingredStacks;
    }

    public Slot[][] mapIngredSlots(GuiContainer gui, List ingredients) {
        Slot[][] recipeSlotList = new Slot[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<Slot> recipeSlots = new LinkedList<Slot>();
            PositionedStack pstack = (PositionedStack)ingredients.get(i);
            for (Slot slot : gui.field_74193_d.field_75151_b) {
                if (slot.field_75223_e != pstack.relx + this.offsetx || slot.field_75221_f != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new Slot[0]);
        }
        return recipeSlotList;
    }

    public void clickSlot(GuiContainer window, int slotIndex, int button, int modifier) {
        Container container = window.field_74193_d;
        Slot slot = null;
        if (slotIndex >= 0 && slotIndex < container.field_75151_b.size()) {
            slot = container.func_75139_a(slotIndex);
        }
        window.func_74191_a(slot, slotIndex, button, modifier);
    }

    public DistributedIngred findIngred(List ingredStacks, ItemStack pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!InventoryUtils.canStack(pstack, istack.stack)) continue;
            return istack;
        }
        return null;
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ItemStack permutation;
        public Slot[] slots;

        public IngredientDistribution(DistributedIngred distrib, ItemStack permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }

    public static class DistributedIngred {
        public ItemStack stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(ItemStack item) {
            this.stack = InventoryUtils.copyStack(item, 1);
        }
    }
}

