/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.InventoryCraftingDummy;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeFireworks;

public class FireworkRecipeHandler
extends ShapelessRecipeHandler {
    public String[] tooltips = new String[]{"Dyes add colours to the charges", "Recolouring adds fade colours to the charge", "Multiple charges can be spawned from one rocket"};
    private InventoryCrafting inventoryCrafting = new InventoryCraftingDummy();
    private RecipeFireworks recipeFireworks = new RecipeFireworks();
    public ArrayList mfireworks = new ArrayList();

    public FireworkRecipeHandler() {
        this.stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
        this.loadAllFireworks();
    }

    private void loadAllFireworks() {
        Item[] shapes = new Item[]{null, Item.field_77811_bE, Item.field_77733_bq, Item.field_77676_L, Item.field_82799_bQ};
        Item[] effects = new Item[]{null, Item.field_77702_n, Item.field_77751_aT};
        for (Item shape : shapes) {
            for (Item effect : effects) {
                this.genRecipe(Item.field_77677_M, shape, effect, Item.field_77756_aW, Item.field_77756_aW, 0);
            }
        }
        this.genRecipe(Item.field_77677_M, Item.field_77759_aK, Item.field_92106_bV, 2);
        this.genRecipe(Item.field_77677_M, Item.field_77677_M, Item.field_77759_aK, Item.field_92106_bV, 2);
        this.genRecipe(Item.field_77677_M, Item.field_77677_M, Item.field_77677_M, Item.field_77759_aK, Item.field_92106_bV, 2);
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.func_70299_a(i, null);
        }
        this.inventoryCrafting.func_70299_a(0, new ItemStack(Item.field_77677_M));
        this.inventoryCrafting.func_70299_a(1, new ItemStack(Item.field_77756_aW));
        this.recipeFireworks.func_77569_a(this.inventoryCrafting, null);
        ItemStack charge = this.recipeFireworks.func_77572_b(null);
        this.genRecipe(charge, Item.field_77756_aW, Item.field_77756_aW, 1);
    }

    private void genRecipe(Object ... params) {
        int i;
        int numIngreds = 0;
        for (i = 0; i < params.length - 2; ++i) {
            if (params[i] == null) continue;
            ++numIngreds;
        }
        for (i = 0; i < params.length - 1; ++i) {
            if (!(params[i] instanceof Item)) continue;
            params[i] = new ItemStack((Item)params[i], 1, -1);
        }
        Object[] ingreds = new Object[numIngreds];
        int j = 0;
        for (int i2 = 0; i2 < params.length - 2; ++i2) {
            if (params[i2] == null) continue;
            ingreds[j++] = params[i2];
        }
        this.mfireworks.add(new CachedFireworkRecipe(ingreds, params[params.length - 2], (Integer)params[params.length - 1]));
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (CachedFireworkRecipe recipe : this.mfireworks) {
            if (recipe.result.item.field_77993_c != result.field_77993_c) continue;
            recipe.cycle();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && this.getClass() == FireworkRecipeHandler.class) {
            this.arecipes.addAll(this.mfireworks);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (CachedFireworkRecipe recipe : this.mfireworks) {
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.cycle();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
            if (this.cycleticks % 20 == 0) {
                for (TemplateRecipeHandler.CachedRecipe crecipe : this.arecipes) {
                    ((CachedFireworkRecipe)crecipe).cycle();
                }
            }
        }
    }

    @Override
    public String getRecipeName() {
        return "Fireworks";
    }

    @Override
    public List handleTooltip(GuiRecipe gui, List currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        Point mousepos = gui.manager.getMousePosition();
        Point relMouse = new Point(mousepos.x - gui.field_74198_m, mousepos.y - gui.field_74197_n);
        Point recipepos = gui.getRecipePosition(recipe);
        if (currenttip.isEmpty() && gui.manager.getStackMouseOver() == null && new Rectangle(recipepos.x, recipepos.y, 166, 55).contains(relMouse)) {
            currenttip.add(this.tooltips[((CachedFireworkRecipe)this.arecipes.get((int)recipe)).recipeType]);
        }
        return currenttip;
    }

    public class CachedFireworkRecipe
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        LinkedList itemList;
        public Object[] baseIngredients;
        public Object extraIngred;
        public int recipeType;

        public CachedFireworkRecipe(Object[] base, Object extra, int type) {
            super((ShapelessRecipeHandler)FireworkRecipeHandler.this, new ItemStack(Item.field_92104_bU));
            this.itemList = new LinkedList();
            this.baseIngredients = base;
            this.extraIngred = extra;
            this.recipeType = type;
            this.cycle();
        }

        public void cycle() {
            this.itemList.clear();
            for (Object obj : this.baseIngredients) {
                this.itemList.add(obj);
            }
            int extras = FireworkRecipeHandler.this.cycleticks / 40 % (10 - this.itemList.size());
            for (int i = 0; i < extras; ++i) {
                this.itemList.add(this.extraIngred);
            }
            this.setIngredients(this.itemList);
            ArrayList ingreds = this.getIngredients();
            for (int i = 0; i < 9; ++i) {
                FireworkRecipeHandler.this.inventoryCrafting.func_70299_a(i, i < ingreds.size() ? ((PositionedStack)ingreds.get((int)i)).item : null);
            }
            if (!FireworkRecipeHandler.this.recipeFireworks.func_77569_a(FireworkRecipeHandler.this.inventoryCrafting, null)) {
                throw new RuntimeException("Invalid Recipe?");
            }
            this.setResult(FireworkRecipeHandler.this.recipeFireworks.func_77572_b(null));
        }
    }
}

