/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;

public class FurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList afuels;
    public static TreeSet efuels;

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
    }

    @Override
    public Class getGuiClass() {
        return GuiFurnace.class;
    }

    @Override
    public String getRecipeName() {
        return "Smelting";
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("smelting") && this.getClass() == FurnaceRecipeHandler.class) {
            ItemStack item;
            HashMap recipes;
            HashMap metarecipes = null;
            try {
                recipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), 1);
                try {
                    metarecipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), 3);
                }
                catch (ArrayIndexOutOfBoundsException e) {}
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            for (Map.Entry recipe : recipes.entrySet()) {
                item = (ItemStack)recipe.getValue();
                this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)recipe.getKey()).intValue(), 1, -1), item));
            }
            if (metarecipes == null) {
                return;
            }
            for (Map.Entry recipe : metarecipes.entrySet()) {
                item = (ItemStack)recipe.getValue();
                this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        ItemStack item;
        HashMap recipes;
        HashMap metarecipes = null;
        try {
            recipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), 1);
            try {
                metarecipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), 3);
            }
            catch (ArrayIndexOutOfBoundsException e) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (!NEIServerUtils.areStacksSameType(item, result)) continue;
            this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)recipe.getKey()).intValue(), 1, -1), item));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (!NEIServerUtils.areStacksSameType(item, result)) continue;
            this.arecipes.add(new SmeltingPair(new ItemStack(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item));
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && this.getClass() == FurnaceRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack item;
        HashMap recipes;
        HashMap metarecipes = null;
        try {
            recipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), 1);
            try {
                metarecipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), 3);
            }
            catch (ArrayIndexOutOfBoundsException e) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (ingredient.field_77993_c != (Integer)recipe.getKey()) continue;
            this.arecipes.add(new SmeltingPair(ingredient, item));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (ingredient.field_77993_c != (Integer)((List)recipe.getKey()).get(0) || ingredient.func_77960_j() != ((Integer)((List)recipe.getKey()).get(1)).intValue()) continue;
            this.arecipes.add(new SmeltingPair(ingredient, item));
        }
    }

    @Override
    public String getGuiTexture() {
        return "/gui/furnace.png";
    }

    @Override
    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(gui, 74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void removeFuels() {
        efuels = new TreeSet();
        efuels.add(Block.field_72000_bn.field_71990_ca);
        efuels.add(Block.field_72001_bo.field_71990_ca);
        efuels.add(Block.field_72053_aD.field_71990_ca);
        efuels.add(Block.field_72042_aI.field_71990_ca);
        efuels.add(Block.field_72054_aE.field_71990_ca);
        efuels.add(Block.field_72004_bj.field_71990_ca);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (Item item : Item.field_77698_e) {
            ItemStack stack;
            int burnTime;
            if (item == null || efuels.contains(item.field_77779_bT) || (burnTime = TileEntityFurnace.func_70398_a((ItemStack)new ItemStack(item, 1))) <= 0) continue;
            afuels.add(new FuelPair(new ItemStack(item, 1), burnTime));
            for (int i = 1; i < 16 && NEIClientUtils.isValidItem(stack = new ItemStack(item, 1, i)); ++i) {
                afuels.add(new FuelPair(stack, burnTime));
            }
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "smelting";
    }

    static {
        FurnaceRecipeHandler.removeFuels();
        FurnaceRecipeHandler.findFuels();
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack(ingred, 51, 42);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred, ItemStack result) {
            super(FurnaceRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack(ingred, 51, 6);
            this.result = new PositionedStack(result, 111, 24);
        }

        @Override
        public PositionedStack getIngredient() {
            int cycle = FurnaceRecipeHandler.this.cycleticks / 48;
            if (this.ingred.item.func_77960_j() == -1) {
                PositionedStack stack = this.ingred.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem(stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.ingred;
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        @Override
        public PositionedStack getOtherStack() {
            return ((FuelPair)FurnaceRecipeHandler.afuels.get((int)(FurnaceRecipeHandler.this.cycleticks / 48 % FurnaceRecipeHandler.afuels.size()))).stack;
        }
    }
}

