/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.GuiNEIButton;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.ContainerRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipe
extends GuiContainer
implements IGuiContainerOverlay {
    public int page;
    public int recipetype;
    public ContainerRecipe slotcontainer;
    public GuiContainer firstGui;
    public GuiContainer prevGui;
    public GuiButton nextpage;
    public GuiButton prevpage;
    public GuiButton overlay1;
    public GuiButton overlay2;
    public ArrayList currenthandlers = new ArrayList();

    protected GuiRecipe(GuiContainer prevgui) {
        super(new ContainerRecipe());
        this.slotcontainer = (ContainerRecipe)this.field_74193_d;
        this.prevGui = prevgui;
        this.firstGui = prevgui;
        if (prevgui instanceof IGuiContainerOverlay) {
            this.firstGui = ((IGuiContainerOverlay)((Object)prevgui)).getFirstScreen();
        }
    }

    @Override
    public boolean isClientOnly() {
        return true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.currenthandlers = this.getCurrentRecipeHandlers();
        GuiNEIButton nexttype = new GuiNEIButton(0, this.field_73880_f / 2 - 70, (this.field_73881_g - this.field_74195_c) / 2 + 3, 13, 12, "<");
        GuiNEIButton prevtype = new GuiNEIButton(1, this.field_73880_f / 2 + 57, (this.field_73881_g - this.field_74195_c) / 2 + 3, 13, 12, ">");
        this.nextpage = new GuiNEIButton(2, this.field_73880_f / 2 - 70, (this.field_73881_g + this.field_74195_c) / 2 - 18, 13, 12, "<");
        this.prevpage = new GuiNEIButton(3, this.field_73880_f / 2 + 57, (this.field_73881_g + this.field_74195_c) / 2 - 18, 13, 12, ">");
        this.overlay1 = new GuiNEIButton(4, this.field_73880_f / 2 + 65, (this.field_73881_g - this.field_74195_c) / 2 + 63, 13, 12, "?");
        this.overlay2 = new GuiNEIButton(5, this.field_73880_f / 2 + 65, (this.field_73881_g - this.field_74195_c) / 2 + 128, 13, 12, "?");
        this.field_73887_h.add(nexttype);
        this.field_73887_h.add(prevtype);
        this.field_73887_h.add(this.nextpage);
        this.field_73887_h.add(this.prevpage);
        this.field_73887_h.add(this.overlay1);
        this.field_73887_h.add(this.overlay2);
        if (this.currenthandlers.size() == 1) {
            nexttype.field_73748_h = false;
            prevtype.field_73748_h = false;
        }
        this.refreshPage();
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1) {
            this.firstGui.refresh();
            this.field_73882_e.func_71373_a(this.firstGui);
            return;
        }
        if (this.manager.lastKeyTyped(i, c)) {
            return;
        }
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        for (int recipe = this.page * recipehandler.recipiesPerPage(); recipe < recipehandler.numRecipes() && recipe < (this.page + 1) * recipehandler.recipiesPerPage(); ++recipe) {
            if (!recipehandler.keyTyped(this, c, i, recipe)) continue;
            return;
        }
        if (i == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
            this.firstGui.refresh();
            this.field_73882_e.func_71373_a(this.firstGui);
        } else if (i == NEIClientConfig.getKeyBinding("back")) {
            this.firstGui.refresh();
            this.field_73882_e.func_71373_a(this.prevGui);
        }
    }

    @Override
    protected void func_73864_a(int par1, int par2, int par3) {
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        for (int recipe = this.page * recipehandler.recipiesPerPage(); recipe < recipehandler.numRecipes() && recipe < (this.page + 1) * recipehandler.recipiesPerPage(); ++recipe) {
            if (!recipehandler.mouseClicked(this, par3, recipe)) continue;
            return;
        }
        super.func_73864_a(par1, par2, par3);
    }

    @Override
    protected void func_73875_a(GuiButton guibutton) {
        super.func_73875_a(guibutton);
        switch (guibutton.field_73741_f) {
            case 0: {
                this.prevType();
                break;
            }
            case 1: {
                this.nextType();
                break;
            }
            case 2: {
                this.prevPage();
                break;
            }
            case 3: {
                this.nextPage();
                break;
            }
            case 4: {
                this.overlayRecipe(this.page * ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).recipiesPerPage());
                break;
            }
            case 5: {
                this.overlayRecipe(this.page * ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).recipiesPerPage() + 1);
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).onUpdate();
        this.refreshPage();
    }

    @Override
    public List handleTooltip(int mousex, int mousey, List currenttip) {
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            currenttip = recipehandler.handleTooltip(this, currenttip, i);
        }
        return currenttip;
    }

    @Override
    public List handleItemTooltip(ItemStack stack, int mousex, int mousey, List currenttip) {
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            currenttip = recipehandler.handleItemTooltip(this, stack, currenttip, i);
        }
        return currenttip;
    }

    private void nextPage() {
        ++this.page;
        if (this.page > (((IRecipeHandler)this.currenthandlers.get(this.recipetype)).numRecipes() - 1) / ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).recipiesPerPage()) {
            this.page = 0;
        }
    }

    private void prevPage() {
        --this.page;
        if (this.page < 0) {
            this.page = (((IRecipeHandler)this.currenthandlers.get(this.recipetype)).numRecipes() - 1) / ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).recipiesPerPage();
        }
    }

    private void nextType() {
        ++this.recipetype;
        if (this.recipetype >= this.currenthandlers.size()) {
            this.recipetype = 0;
        }
        this.page = 0;
    }

    private void prevType() {
        --this.recipetype;
        if (this.recipetype < 0) {
            this.recipetype = this.currenthandlers.size() - 1;
        }
        this.page = 0;
    }

    private void overlayRecipe(int recipe) {
        IRecipeOverlayRenderer renderer = ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).getOverlayRenderer(this.firstGui, recipe);
        IOverlayHandler handler = ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).getOverlayHandler(this.firstGui, recipe);
        boolean shift = NEIClientUtils.shiftKey();
        if (handler != null && (renderer == null || shift)) {
            this.firstGui.refresh();
            this.field_73882_e.func_71373_a(this.firstGui);
            handler.overlayRecipe(this.firstGui, (IRecipeHandler)this.currenthandlers.get(this.recipetype), recipe, shift);
        } else if (!(renderer == null || handler != null && shift)) {
            this.firstGui.refresh();
            this.field_73882_e.func_71373_a(this.firstGui);
            LayoutManager.overlayRenderer = renderer;
        }
    }

    public void refreshPage() {
        boolean multiplepages;
        this.refreshSlots();
        IRecipeHandler handler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        this.nextpage.field_73748_h = multiplepages = handler.numRecipes() > handler.recipiesPerPage();
        this.prevpage.field_73748_h = multiplepages;
        GuiContainer mainInv = this.getFirstScreen();
        this.overlay1.field_73743_d = (this.field_73881_g - this.field_74195_c) / 2 + (handler.recipiesPerPage() == 2 ? 63 : 128);
        this.overlay1.field_73748_h = handler.hasOverlay(mainInv, mainInv.field_74193_d, this.page * handler.recipiesPerPage());
        this.overlay2.field_73748_h = handler.recipiesPerPage() == 2 && this.page * handler.recipiesPerPage() + 1 < handler.numRecipes() && handler.hasOverlay(mainInv, mainInv.field_74193_d, this.page * handler.recipiesPerPage() + 1);
    }

    private void refreshSlots() {
        this.slotcontainer.field_75151_b.clear();
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            Point p = this.getRecipePosition(i);
            ArrayList stacks = recipehandler.getIngredientStacks(i);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            stacks = recipehandler.getOtherStacks(i);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            PositionedStack result = recipehandler.getResultStack(i);
            if (result == null) continue;
            this.slotcontainer.addSlot(result, p.x, p.y);
        }
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        GuiContainerManager.enable2DRender();
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        String s = recipehandler.getRecipeName();
        this.field_73886_k.func_78276_b(s, (this.field_74194_b - this.field_73886_k.func_78256_a(s)) / 2, 5, 0x404040);
        s = "Page " + (this.page + 1) + "/" + ((((IRecipeHandler)this.currenthandlers.get(this.recipetype)).numRecipes() - 1) / recipehandler.recipiesPerPage() + 1);
        this.field_73886_k.func_78276_b(s, (this.field_74194_b - this.field_73886_k.func_78256_a(s)) / 2, this.field_74195_c - 16, 0x404040);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)5.0f, (float)16.0f, (float)0.0f);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            recipehandler.drawForeground(this.manager, i);
            GL11.glTranslatef((float)0.0f, (float)65.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    @Override
    protected void func_74185_a(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/codechicken/nei/recipebg.png");
        int j = (this.field_73880_f - this.field_74194_b) / 2;
        int k = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_74194_b, this.field_74195_c);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(j + 5), (float)(k + 16), (float)0.0f);
        IRecipeHandler recipehandler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            recipehandler.drawBackground(this.manager, i);
            GL11.glTranslatef((float)0.0f, (float)65.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    @Override
    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    public boolean isMouseOver(PositionedStack stack, int recipe) {
        Slot stackSlot = this.slotcontainer.getSlotWithStack(stack, this.getRecipePosition((int)recipe).x, this.getRecipePosition((int)recipe).y);
        Point mousepos = this.manager.getMousePosition();
        Slot mouseoverSlot = this.func_74187_b(mousepos.x, mousepos.y);
        return stackSlot == mouseoverSlot;
    }

    public Point getRecipePosition(int recipe) {
        return new Point(5, 16 + recipe % ((IRecipeHandler)this.currenthandlers.get(this.recipetype)).recipiesPerPage() * 65);
    }

    public abstract ArrayList getCurrentRecipeHandlers();
}

