/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEICompatibility;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.recipe.weakDependancy_Forge;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;

public class ShapedRecipeHandler
extends TemplateRecipeHandler {
    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    @Override
    public Class getGuiClass() {
        return GuiCrafting.class;
    }

    @Override
    public String getRecipeName() {
        return "Shaped Crafting";
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && this.getClass() == ShapedRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                CachedShapedRecipe recipe = null;
                if (irecipe instanceof ShapedRecipes) {
                    recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
                } else if (NEICompatibility.hasForge && weakDependancy_Forge.recipeInstanceShaped(irecipe)) {
                    recipe = weakDependancy_Forge.getShapedRecipe(this, irecipe);
                }
                if (recipe == null) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(irecipe.func_77571_b(), result)) continue;
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedRecipes) {
                recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
            } else if (NEICompatibility.hasForge && weakDependancy_Forge.recipeInstanceShaped(irecipe)) {
                recipe = weakDependancy_Forge.getShapedRecipe(this, irecipe);
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedRecipes) {
                recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
            } else if (NEICompatibility.hasForge && weakDependancy_Forge.recipeInstanceShaped(irecipe)) {
                recipe = weakDependancy_Forge.getShapedRecipe(this, irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "/gui/crafting.png";
    }

    @Override
    public String getOverlayIdentifier() {
        return "crafting";
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || RecipeInfo.hasDefaultOverlay(gui, "crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(ShapedRecipes recipe) {
            super(ShapedRecipeHandler.this);
            this.result = new PositionedStack(recipe.func_77571_b(), 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(recipe);
        }

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            super(ShapedRecipeHandler.this);
            this.result = new PositionedStack(out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public void setIngredients(ShapedRecipes recipe) {
            Object[] items;
            int height;
            int width;
            try {
                width = (Integer)ReflectionManager.getField(ShapedRecipes.class, Integer.class, (Object)recipe, 0);
                height = (Integer)ReflectionManager.getField(ShapedRecipes.class, Integer.class, (Object)recipe, 1);
                items = (ItemStack[])ReflectionManager.getField(ShapedRecipes.class, ItemStack[].class, (Object)recipe, 2);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.setIngredients(width, height, items);
        }

        @Override
        public ArrayList getIngredients() {
            return this.getCycledIngredients(ShapedRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }
    }
}

