/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.EnumGas;
import mekanism.client.BasicRenderingHandler;
import mekanism.client.ClientConnectionHandler;
import mekanism.client.ClientPlayerTickHandler;
import mekanism.client.ClientTickHandler;
import mekanism.client.GuiCombiner;
import mekanism.client.GuiControlPanel;
import mekanism.client.GuiCredits;
import mekanism.client.GuiCrusher;
import mekanism.client.GuiDynamicTank;
import mekanism.client.GuiElectricChest;
import mekanism.client.GuiElectricPump;
import mekanism.client.GuiEnergizedSmelter;
import mekanism.client.GuiEnergyCube;
import mekanism.client.GuiEnrichmentChamber;
import mekanism.client.GuiFactory;
import mekanism.client.GuiGasTank;
import mekanism.client.GuiMetallurgicInfuser;
import mekanism.client.GuiOsmiumCompressor;
import mekanism.client.GuiPasswordEnter;
import mekanism.client.GuiPasswordModify;
import mekanism.client.GuiPortableTeleporter;
import mekanism.client.GuiPurificationChamber;
import mekanism.client.GuiRobitCrafting;
import mekanism.client.GuiRobitInventory;
import mekanism.client.GuiRobitMain;
import mekanism.client.GuiRobitRepair;
import mekanism.client.GuiRobitSmelting;
import mekanism.client.GuiStopwatch;
import mekanism.client.GuiTeleporter;
import mekanism.client.GuiTheoreticalElementizer;
import mekanism.client.GuiWeatherOrb;
import mekanism.client.ItemRenderingHandler;
import mekanism.client.MachineRenderingHandler;
import mekanism.client.RenderChargepad;
import mekanism.client.RenderConfigurableMachine;
import mekanism.client.RenderDynamicTank;
import mekanism.client.RenderElectricChest;
import mekanism.client.RenderElectricPump;
import mekanism.client.RenderMechanicalPipe;
import mekanism.client.RenderMetallurgicInfuser;
import mekanism.client.RenderObsidianTNT;
import mekanism.client.RenderPressurizedTube;
import mekanism.client.RenderRobit;
import mekanism.client.RenderTheoreticalElementizer;
import mekanism.client.RenderTickHandler;
import mekanism.client.RenderUniversalCable;
import mekanism.client.Sound;
import mekanism.client.SoundHandler;
import mekanism.client.ThreadTankSparkle;
import mekanism.client.TransmitterRenderer;
import mekanism.common.CommonProxy;
import mekanism.common.EntityObsidianTNT;
import mekanism.common.EntityRobit;
import mekanism.common.IElectricChest;
import mekanism.common.InventoryElectricChest;
import mekanism.common.ItemPortableTeleporter;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityAdvancedElectricMachine;
import mekanism.common.TileEntityAdvancedFactory;
import mekanism.common.TileEntityChargepad;
import mekanism.common.TileEntityCombiner;
import mekanism.common.TileEntityControlPanel;
import mekanism.common.TileEntityCrusher;
import mekanism.common.TileEntityDynamicTank;
import mekanism.common.TileEntityDynamicValve;
import mekanism.common.TileEntityElectricChest;
import mekanism.common.TileEntityElectricMachine;
import mekanism.common.TileEntityElectricPump;
import mekanism.common.TileEntityEliteFactory;
import mekanism.common.TileEntityEnergizedSmelter;
import mekanism.common.TileEntityEnergyCube;
import mekanism.common.TileEntityEnrichmentChamber;
import mekanism.common.TileEntityFactory;
import mekanism.common.TileEntityGasTank;
import mekanism.common.TileEntityMechanicalPipe;
import mekanism.common.TileEntityMetallurgicInfuser;
import mekanism.common.TileEntityOsmiumCompressor;
import mekanism.common.TileEntityPressurizedTube;
import mekanism.common.TileEntityPurificationChamber;
import mekanism.common.TileEntityTeleporter;
import mekanism.common.TileEntityTheoreticalElementizer;
import mekanism.common.TileEntityUniversalCable;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static int MACHINE_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static int TRANSMITTER_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static int BASIC_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        Mekanism.configuration.load();
        Mekanism.enableSounds = Mekanism.configuration.get("general", "EnableSounds", true).getBoolean(true);
        Mekanism.fancyUniversalCableRender = Mekanism.configuration.get("general", "FancyUniversalCableRender", true).getBoolean(true);
        Mekanism.configuration.save();
    }

    @Override
    public int getArmorIndex(String string) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSound(TileEntity tileEntity) {
        if (Mekanism.enableSounds && SoundManager.field_77381_a != null) {
            Map map = Mekanism.audioHandler.sounds;
            synchronized (map) {
                Mekanism.audioHandler.register(tileEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSound(TileEntity tileEntity) {
        if (Mekanism.enableSounds && SoundManager.field_77381_a != null) {
            Map map = Mekanism.audioHandler.sounds;
            synchronized (map) {
                if (Mekanism.audioHandler.getFrom(tileEntity) != null) {
                    Mekanism.audioHandler.getFrom(tileEntity).remove();
                }
            }
        }
    }

    @Override
    public void openElectricChest(EntityPlayer entityplayer, int id, int windowId, boolean isBlock, int x, int y, int z) {
        TileEntityElectricChest tileEntity = (TileEntityElectricChest)entityplayer.field_70170_p.func_72796_p(x, y, z);
        if (id == 0) {
            if (isBlock) {
                FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiElectricChest(entityplayer.field_71071_by, tileEntity));
                entityplayer.field_71070_bA.field_75152_c = windowId;
            } else {
                FMLClientHandler.instance().getClient().field_71416_A.func_77366_a("random.chestopen", 1.0f, 1.0f);
                ItemStack stack = entityplayer.func_71045_bC();
                if (stack != null && stack.func_77973_b() instanceof IElectricChest && ((IElectricChest)stack.func_77973_b()).isElectricChest(stack)) {
                    InventoryElectricChest inventory = new InventoryElectricChest(entityplayer);
                    FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiElectricChest(entityplayer.field_71071_by, (IInventory)inventory));
                    entityplayer.field_71070_bA.field_75152_c = windowId;
                }
            }
        } else if (id == 1) {
            if (isBlock) {
                FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiPasswordEnter(tileEntity));
            } else {
                ItemStack stack = entityplayer.func_71045_bC();
                if (stack != null && stack.func_77973_b() instanceof IElectricChest && ((IElectricChest)stack.func_77973_b()).isElectricChest(stack)) {
                    FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiPasswordEnter(stack));
                }
            }
        } else if (id == 2) {
            if (isBlock) {
                FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiPasswordModify(tileEntity));
            } else {
                ItemStack stack = entityplayer.func_71045_bC();
                if (stack != null && stack.func_77973_b() instanceof IElectricChest && ((IElectricChest)stack.func_77973_b()).isElectricChest(stack)) {
                    FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiPasswordModify(stack));
                }
            }
        }
    }

    @Override
    public void registerSpecialTileEntities() {
        ClientRegistry.registerTileEntity(TileEntityEnrichmentChamber.class, (String)"EnrichmentChamber", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityOsmiumCompressor.class, (String)"OsmiumCompressor", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityCombiner.class, (String)"Combiner", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityCrusher.class, (String)"Crusher", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityFactory.class, (String)"SmeltingFactory", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityAdvancedFactory.class, (String)"AdvancedSmeltingFactory", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityEliteFactory.class, (String)"UltimateSmeltingFactory", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityPurificationChamber.class, (String)"PurificationChamber", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityEnergizedSmelter.class, (String)"EnergizedSmelter", (TileEntitySpecialRenderer)new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityTheoreticalElementizer.class, (String)"TheoreticalElementizer", (TileEntitySpecialRenderer)new RenderTheoreticalElementizer());
        ClientRegistry.registerTileEntity(TileEntityMetallurgicInfuser.class, (String)"MetallurgicInfuser", (TileEntitySpecialRenderer)new RenderMetallurgicInfuser());
        ClientRegistry.registerTileEntity(TileEntityPressurizedTube.class, (String)"PressurizedTube", (TileEntitySpecialRenderer)new RenderPressurizedTube());
        ClientRegistry.registerTileEntity(TileEntityUniversalCable.class, (String)"UniversalCable", (TileEntitySpecialRenderer)new RenderUniversalCable());
        ClientRegistry.registerTileEntity(TileEntityElectricPump.class, (String)"ElectricPump", (TileEntitySpecialRenderer)new RenderElectricPump());
        ClientRegistry.registerTileEntity(TileEntityElectricChest.class, (String)"ElectricChest", (TileEntitySpecialRenderer)new RenderElectricChest());
        ClientRegistry.registerTileEntity(TileEntityMechanicalPipe.class, (String)"MechanicalPipe", (TileEntitySpecialRenderer)new RenderMechanicalPipe());
        ClientRegistry.registerTileEntity(TileEntityDynamicTank.class, (String)"DynamicTank", (TileEntitySpecialRenderer)new RenderDynamicTank());
        ClientRegistry.registerTileEntity(TileEntityDynamicValve.class, (String)"DynamicValve", (TileEntitySpecialRenderer)new RenderDynamicTank());
        ClientRegistry.registerTileEntity(TileEntityChargepad.class, (String)"Chargepad", (TileEntitySpecialRenderer)new RenderChargepad());
    }

    @Override
    public void registerRenderInformation() {
        RenderingRegistry.registerEntityRenderingHandler(EntityObsidianTNT.class, (Render)new RenderObsidianTNT());
        RenderingRegistry.registerEntityRenderingHandler(EntityRobit.class, (Render)new RenderRobit());
        MinecraftForgeClient.registerItemRenderer((int)Mekanism.energyCubeID, (IItemRenderer)new ItemRenderingHandler());
        MinecraftForgeClient.registerItemRenderer((int)Mekanism.machineBlockID, (IItemRenderer)new ItemRenderingHandler());
        MinecraftForgeClient.registerItemRenderer((int)Mekanism.Robit.field_77779_bT, (IItemRenderer)new ItemRenderingHandler());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new MachineRenderingHandler());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new TransmitterRenderer());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BasicRenderingHandler());
        if (!EnumGas.HYDROGEN.hasTexture()) {
            EnumGas.HYDROGEN.gasIcon = FMLClientHandler.instance().getClient().field_71446_o.field_94155_m.func_94245_a("mekanism:LiquidHydrogen");
            EnumGas.HYDROGEN.texturePath = "/mods/mekanism/textures/items/LiquidHydrogen.png";
        }
        if (!EnumGas.OXYGEN.hasTexture()) {
            EnumGas.OXYGEN.gasIcon = FMLClientHandler.instance().getClient().field_71446_o.field_94155_m.func_94245_a("mekanism:LiquidOxygen");
            EnumGas.OXYGEN.texturePath = "/mods/mekanism/textures/items/LiquidOxygen.png";
        }
        System.out.println("[Mekanism] Render registrations complete.");
    }

    @Override
    public GuiScreen getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        switch (ID) {
            case 0: {
                return new GuiStopwatch(player);
            }
            case 1: {
                return new GuiCredits();
            }
            case 2: {
                return new GuiWeatherOrb(player);
            }
            case 3: {
                return new GuiEnrichmentChamber(player.field_71071_by, (TileEntityElectricMachine)tileEntity);
            }
            case 4: {
                return new GuiOsmiumCompressor(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 5: {
                return new GuiCombiner(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 6: {
                return new GuiCrusher(player.field_71071_by, (TileEntityElectricMachine)tileEntity);
            }
            case 7: {
                return new GuiTheoreticalElementizer(player.field_71071_by, (TileEntityTheoreticalElementizer)tileEntity);
            }
            case 8: {
                return new GuiEnergyCube(player.field_71071_by, (TileEntityEnergyCube)tileEntity);
            }
            case 9: {
                return new GuiControlPanel((TileEntityControlPanel)tileEntity, player, world);
            }
            case 10: {
                return new GuiGasTank(player.field_71071_by, (TileEntityGasTank)tileEntity);
            }
            case 11: {
                return new GuiFactory(player.field_71071_by, (TileEntityFactory)tileEntity);
            }
            case 12: {
                return new GuiMetallurgicInfuser(player.field_71071_by, (TileEntityMetallurgicInfuser)tileEntity);
            }
            case 13: {
                return new GuiTeleporter(player.field_71071_by, (TileEntityTeleporter)tileEntity);
            }
            case 14: {
                ItemStack itemStack = player.func_71045_bC();
                if (itemStack != null && itemStack.func_77973_b() instanceof ItemPortableTeleporter) {
                    return new GuiPortableTeleporter(player, itemStack);
                }
            }
            case 15: {
                return new GuiPurificationChamber(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 16: {
                return new GuiEnergizedSmelter(player.field_71071_by, (TileEntityElectricMachine)tileEntity);
            }
            case 17: {
                return new GuiElectricPump(player.field_71071_by, (TileEntityElectricPump)tileEntity);
            }
            case 18: {
                return new GuiDynamicTank(player.field_71071_by, (TileEntityDynamicTank)tileEntity);
            }
            case 19: {
                return new GuiPasswordEnter((TileEntityElectricChest)tileEntity);
            }
            case 20: {
                return new GuiPasswordModify((TileEntityElectricChest)tileEntity);
            }
            case 21: {
                EntityRobit robit = (EntityRobit)world.func_73045_a(x);
                if (robit != null) {
                    return new GuiRobitMain(player.field_71071_by, robit);
                }
            }
            case 22: {
                return new GuiRobitCrafting(player.field_71071_by, world, x);
            }
            case 23: {
                EntityRobit robit1 = (EntityRobit)world.func_73045_a(x);
                if (robit1 != null) {
                    return new GuiRobitInventory(player.field_71071_by, robit1);
                }
            }
            case 24: {
                EntityRobit robit2 = (EntityRobit)world.func_73045_a(x);
                if (robit2 != null) {
                    return new GuiRobitSmelting(player.field_71071_by, robit2);
                }
            }
            case 25: {
                return new GuiRobitRepair(player.field_71071_by, world, x);
            }
        }
        return null;
    }

    @Override
    public void doTankAnimation(TileEntityDynamicTank tileEntity) {
        new ThreadTankSparkle(tileEntity).start();
    }

    @Override
    public void loadUtilities() {
        super.loadUtilities();
        TickRegistry.registerTickHandler((ITickHandler)new ClientTickHandler(), (Side)Side.CLIENT);
        TickRegistry.registerTickHandler((ITickHandler)new ClientPlayerTickHandler(), (Side)Side.CLIENT);
        TickRegistry.registerTickHandler((ITickHandler)new RenderTickHandler(), (Side)Side.CLIENT);
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new ClientConnectionHandler());
    }

    @Override
    public void loadSoundHandler() {
        if (Mekanism.enableSounds) {
            Mekanism.audioHandler = new SoundHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadSoundHandler() {
        if (Mekanism.enableSounds && Mekanism.audioHandler != null) {
            Map map = Mekanism.audioHandler.sounds;
            synchronized (map) {
                HashMap sounds = new HashMap();
                sounds.putAll(Mekanism.audioHandler.sounds);
                for (Sound sound : sounds.values()) {
                    sound.remove();
                }
            }
        }
    }

    @Override
    public boolean isPaused() {
        GuiScreen screen;
        return FMLClientHandler.instance().getClient().func_71356_B() && !FMLClientHandler.instance().getClient().func_71401_C().func_71344_c() && (screen = FMLClientHandler.instance().getClient().field_71462_r) != null && screen.func_73868_f();
    }
}

